/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.ipcamera.onvif.soap.devices;

import io.antmedia.ipcamera.onvif.soap.OnvifDevice;
import io.antmedia.ipcamera.onvif.soap.SOAP;
import java.net.ConnectException;
import java.util.List;
import javax.xml.soap.SOAPException;
import org.onvif.ver10.media.wsdl.GetSnapshotUri;
import org.onvif.ver10.media.wsdl.GetSnapshotUriResponse;
import org.onvif.ver10.media.wsdl.GetStreamUri;
import org.onvif.ver10.media.wsdl.GetStreamUriResponse;
import org.onvif.ver10.media.wsdl.GetVideoEncoderConfigurationOptions;
import org.onvif.ver10.media.wsdl.GetVideoEncoderConfigurationOptionsResponse;
import org.onvif.ver10.media.wsdl.GetVideoSources;
import org.onvif.ver10.media.wsdl.GetVideoSourcesResponse;
import org.onvif.ver10.media.wsdl.SetVideoEncoderConfiguration;
import org.onvif.ver10.media.wsdl.SetVideoEncoderConfigurationResponse;
import org.onvif.ver10.schema.Profile;
import org.onvif.ver10.schema.StreamSetup;
import org.onvif.ver10.schema.StreamType;
import org.onvif.ver10.schema.Transport;
import org.onvif.ver10.schema.TransportProtocol;
import org.onvif.ver10.schema.VideoEncoderConfiguration;
import org.onvif.ver10.schema.VideoEncoderConfigurationOptions;
import org.onvif.ver10.schema.VideoSource;

public class MediaDevices {
    private OnvifDevice onvifDevice;
    private SOAP soap;

    public MediaDevices(OnvifDevice onvifDevice) {
        this.onvifDevice = onvifDevice;
        this.soap = onvifDevice.getSoap();
    }

    @Deprecated
    public String getHTTPStreamUri(int profileNumber) throws ConnectException, SOAPException {
        StreamSetup setup = new StreamSetup();
        setup.setStream(StreamType.RTP_UNICAST);
        Transport transport = new Transport();
        transport.setProtocol(TransportProtocol.HTTP);
        setup.setTransport(transport);
        return this.getStreamUri(setup, profileNumber);
    }

    public String getHTTPStreamUri(String profileToken) throws ConnectException, SOAPException {
        StreamSetup setup = new StreamSetup();
        setup.setStream(StreamType.RTP_UNICAST);
        Transport transport = new Transport();
        transport.setProtocol(TransportProtocol.HTTP);
        setup.setTransport(transport);
        return this.getStreamUri(profileToken, setup);
    }

    @Deprecated
    public String getUDPStreamUri(int profileNumber) throws ConnectException, SOAPException {
        StreamSetup setup = new StreamSetup();
        setup.setStream(StreamType.RTP_UNICAST);
        Transport transport = new Transport();
        transport.setProtocol(TransportProtocol.UDP);
        setup.setTransport(transport);
        return this.getStreamUri(setup, profileNumber);
    }

    public String getUDPStreamUri(String profileToken) throws ConnectException, SOAPException {
        StreamSetup setup = new StreamSetup();
        setup.setStream(StreamType.RTP_UNICAST);
        Transport transport = new Transport();
        transport.setProtocol(TransportProtocol.UDP);
        setup.setTransport(transport);
        return this.getStreamUri(profileToken, setup);
    }

    @Deprecated
    public String getTCPStreamUri(int profileNumber) throws ConnectException, SOAPException {
        StreamSetup setup = new StreamSetup();
        setup.setStream(StreamType.RTP_UNICAST);
        Transport transport = new Transport();
        transport.setProtocol(TransportProtocol.TCP);
        setup.setTransport(transport);
        return this.getStreamUri(setup, profileNumber);
    }

    public String getTCPStreamUri(String profileToken) throws ConnectException, SOAPException {
        StreamSetup setup = new StreamSetup();
        setup.setStream(StreamType.RTP_UNICAST);
        Transport transport = new Transport();
        transport.setProtocol(TransportProtocol.TCP);
        setup.setTransport(transport);
        return this.getStreamUri(profileToken, setup);
    }

    @Deprecated
    public String getRTSPStreamUri(int profileNumber) throws ConnectException, SOAPException {
        StreamSetup setup = new StreamSetup();
        setup.setStream(StreamType.RTP_UNICAST);
        Transport transport = new Transport();
        transport.setProtocol(TransportProtocol.TCP);
        setup.setTransport(transport);
        return this.getStreamUri(setup, profileNumber);
    }

    public String getRTSPStreamUri(String profileToken) throws ConnectException, SOAPException {
        StreamSetup setup = new StreamSetup();
        setup.setStream(StreamType.RTP_UNICAST);
        Transport transport = new Transport();
        transport.setProtocol(TransportProtocol.TCP);
        setup.setTransport(transport);
        return this.getStreamUri(profileToken, setup);
    }

    @Deprecated
    public String getStreamUri(StreamSetup streamSetup, int profileNumber) throws ConnectException, SOAPException {
        Profile profile = this.onvifDevice.getDevices().getProfiles().get(profileNumber);
        return this.getStreamUri(profile, streamSetup);
    }

    @Deprecated
    public String getStreamUri(Profile profile, StreamSetup streamSetup) throws ConnectException, SOAPException {
        return this.getStreamUri(profile.getToken(), streamSetup);
    }

    public String getStreamUri(String profileToken, StreamSetup streamSetup) throws SOAPException, ConnectException {
        GetStreamUri request = new GetStreamUri();
        GetStreamUriResponse response = new GetStreamUriResponse();
        request.setProfileToken(profileToken);
        request.setStreamSetup(streamSetup);
        response = (GetStreamUriResponse)this.soap.createSOAPMediaRequest(request, response, false);
        if (response == null) {
            return null;
        }
        return this.onvifDevice.replaceLocalIpWithProxyIp(response.getMediaUri().getUri());
    }

    public static VideoEncoderConfiguration getVideoEncoderConfiguration(Profile profile) {
        return profile.getVideoEncoderConfiguration();
    }

    public VideoEncoderConfigurationOptions getVideoEncoderConfigurationOptions(String profileToken) throws SOAPException, ConnectException {
        GetVideoEncoderConfigurationOptions request = new GetVideoEncoderConfigurationOptions();
        GetVideoEncoderConfigurationOptionsResponse response = new GetVideoEncoderConfigurationOptionsResponse();
        request.setProfileToken(profileToken);
        response = (GetVideoEncoderConfigurationOptionsResponse)this.soap.createSOAPMediaRequest(request, response, false);
        if (response == null) {
            return null;
        }
        return response.getOptions();
    }

    public boolean setVideoEncoderConfiguration(VideoEncoderConfiguration videoEncoderConfiguration) throws SOAPException, ConnectException {
        SetVideoEncoderConfiguration request = new SetVideoEncoderConfiguration();
        SetVideoEncoderConfigurationResponse response = new SetVideoEncoderConfigurationResponse();
        request.setConfiguration(videoEncoderConfiguration);
        request.setForcePersistence(true);
        response = (SetVideoEncoderConfigurationResponse)this.soap.createSOAPMediaRequest(request, response, true);
        return response != null;
    }

    public String getSceenshotUri(String profileToken) throws SOAPException, ConnectException {
        return this.getSnapshotUri(profileToken);
    }

    public String getSnapshotUri(String profileToken) throws SOAPException, ConnectException {
        GetSnapshotUri request = new GetSnapshotUri();
        GetSnapshotUriResponse response = new GetSnapshotUriResponse();
        request.setProfileToken(profileToken);
        response = (GetSnapshotUriResponse)this.soap.createSOAPMediaRequest(request, response, true);
        if (response == null || response.getMediaUri() == null) {
            return null;
        }
        return this.onvifDevice.replaceLocalIpWithProxyIp(response.getMediaUri().getUri());
    }

    public List<VideoSource> getVideoSources() throws SOAPException, ConnectException {
        GetVideoSources request = new GetVideoSources();
        GetVideoSourcesResponse response = new GetVideoSourcesResponse();
        response = (GetVideoSourcesResponse)this.soap.createSOAPMediaRequest(request, response, false);
        if (response == null) {
            return null;
        }
        return response.getVideoSources();
    }
}

