/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.ipcamera.onvif.soap.devices;

import io.antmedia.ipcamera.onvif.soap.OnvifDevice;
import io.antmedia.ipcamera.onvif.soap.SOAP;
import java.net.ConnectException;
import javax.xml.soap.SOAPException;
import org.onvif.ver10.schema.AbsoluteFocus;
import org.onvif.ver10.schema.FocusMove;
import org.onvif.ver10.schema.ImagingOptions20;
import org.onvif.ver10.schema.ImagingSettings20;
import org.onvif.ver20.imaging.wsdl.GetImagingSettings;
import org.onvif.ver20.imaging.wsdl.GetImagingSettingsResponse;
import org.onvif.ver20.imaging.wsdl.GetOptions;
import org.onvif.ver20.imaging.wsdl.GetOptionsResponse;
import org.onvif.ver20.imaging.wsdl.Move;
import org.onvif.ver20.imaging.wsdl.MoveResponse;
import org.onvif.ver20.imaging.wsdl.SetImagingSettings;
import org.onvif.ver20.imaging.wsdl.SetImagingSettingsResponse;

public class ImagingDevices {
    private OnvifDevice onvifDevice;
    private SOAP soap;

    public ImagingDevices(OnvifDevice onvifDevice) {
        this.onvifDevice = onvifDevice;
        this.soap = onvifDevice.getSoap();
    }

    public ImagingOptions20 getOptions(String videoSourceToken) {
        if (videoSourceToken == null) {
            return null;
        }
        GetOptions request = new GetOptions();
        GetOptionsResponse response = new GetOptionsResponse();
        request.setVideoSourceToken(videoSourceToken);
        try {
            response = (GetOptionsResponse)this.soap.createSOAPImagingRequest(request, response, false);
        }
        catch (ConnectException | SOAPException e) {
            e.printStackTrace();
            return null;
        }
        if (response == null) {
            return null;
        }
        return response.getImagingOptions();
    }

    public boolean moveFocus(String videoSourceToken, float absoluteFocusValue) {
        if (videoSourceToken == null) {
            return false;
        }
        Move request = new Move();
        MoveResponse response = new MoveResponse();
        AbsoluteFocus absoluteFocus = new AbsoluteFocus();
        absoluteFocus.setPosition(absoluteFocusValue);
        FocusMove focusMove = new FocusMove();
        focusMove.setAbsolute(absoluteFocus);
        request.setVideoSourceToken(videoSourceToken);
        request.setFocus(focusMove);
        try {
            response = (MoveResponse)this.soap.createSOAPImagingRequest(request, response, true);
        }
        catch (ConnectException | SOAPException e) {
            e.printStackTrace();
            return false;
        }
        return response != null;
    }

    public ImagingSettings20 getImagingSettings(String videoSourceToken) {
        if (videoSourceToken == null) {
            return null;
        }
        GetImagingSettings request = new GetImagingSettings();
        GetImagingSettingsResponse response = new GetImagingSettingsResponse();
        request.setVideoSourceToken(videoSourceToken);
        try {
            response = (GetImagingSettingsResponse)this.soap.createSOAPImagingRequest(request, response, true);
        }
        catch (ConnectException | SOAPException e) {
            e.printStackTrace();
            return null;
        }
        if (response == null) {
            return null;
        }
        return response.getImagingSettings();
    }

    public boolean setImagingSettings(String videoSourceToken, ImagingSettings20 imagingSettings) {
        if (videoSourceToken == null) {
            return false;
        }
        SetImagingSettings request = new SetImagingSettings();
        SetImagingSettingsResponse response = new SetImagingSettingsResponse();
        request.setVideoSourceToken(videoSourceToken);
        request.setImagingSettings(imagingSettings);
        try {
            response = (SetImagingSettingsResponse)this.soap.createSOAPImagingRequest(request, response, true);
        }
        catch (ConnectException | SOAPException e) {
            e.printStackTrace();
            return false;
        }
        return response != null;
    }
}

