/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.ipcamera.onvif.soap;

import io.antmedia.ipcamera.onvif.soap.OnvifDevice;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.SocketException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SOAP {
    private boolean logging = true;
    private OnvifDevice onvifDevice;

    public SOAP(OnvifDevice onvifDevice) {
        this.onvifDevice = onvifDevice;
    }

    public Object createSOAPDeviceRequest(Object soapRequestElem, Object soapResponseElem, boolean needsAuthentification) throws SOAPException, ConnectException {
        return this.createSOAPRequest(soapRequestElem, soapResponseElem, this.onvifDevice.getDeviceUri(), needsAuthentification);
    }

    public Object createSOAPPtzRequest(Object soapRequestElem, Object soapResponseElem, boolean needsAuthentification) throws SOAPException, ConnectException {
        return this.createSOAPRequest(soapRequestElem, soapResponseElem, this.onvifDevice.getPtzUri(), needsAuthentification);
    }

    public Object createSOAPMediaRequest(Object soapRequestElem, Object soapResponseElem, boolean needsAuthentification) throws SOAPException, ConnectException {
        return this.createSOAPRequest(soapRequestElem, soapResponseElem, this.onvifDevice.getMediaUri(), needsAuthentification);
    }

    public Object createSOAPImagingRequest(Object soapRequestElem, Object soapResponseElem, boolean needsAuthentification) throws SOAPException, ConnectException {
        return this.createSOAPRequest(soapRequestElem, soapResponseElem, this.onvifDevice.getImagingUri(), needsAuthentification);
    }

    public Object createSOAPEventsRequest(Object soapRequestElem, Object soapResponseElem, boolean needsAuthentification) throws SOAPException, ConnectException {
        return this.createSOAPRequest(soapRequestElem, soapResponseElem, this.onvifDevice.getEventsUri(), needsAuthentification);
    }

    public Object createSOAPRequest(Object soapRequestElem, Object soapResponseElem, String soapUri, boolean needsAuthentification) throws ConnectException, SOAPException {
        SOAPConnection soapConnection = null;
        SOAPMessage soapResponse = null;
        try {
            SOAPConnectionFactory soapConnectionFactory = SOAPConnectionFactory.newInstance();
            soapConnection = soapConnectionFactory.createConnection();
            SOAPMessage soapMessage = this.createSoapMessage(soapRequestElem, needsAuthentification);
            if (this.isLogging()) {
                System.out.print("Request SOAP Message (" + soapRequestElem.getClass().getSimpleName() + "): ");
                soapMessage.writeTo((OutputStream)System.out);
                System.out.println();
            }
            soapResponse = soapConnection.call(soapMessage, (Object)soapUri);
            if (this.isLogging()) {
                System.out.print("Response SOAP Message (" + soapResponseElem.getClass().getSimpleName() + "): ");
                soapResponse.writeTo((OutputStream)System.out);
                System.out.println();
            }
            if (soapResponseElem == null) {
                throw new NullPointerException("Improper SOAP Response Element given (is null).");
            }
            Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{soapResponseElem.getClass()}).createUnmarshaller();
            try {
                try {
                    soapResponseElem = unmarshaller.unmarshal((Node)soapResponse.getSOAPBody().extractContentAsDocument());
                }
                catch (SOAPException e) {
                    soapResponseElem = unmarshaller.unmarshal((Node)soapResponse.getSOAPBody().extractContentAsDocument());
                }
            }
            catch (UnmarshalException e) {
                this.onvifDevice.getLogger().warn("Could not unmarshal, ended in SOAP fault.");
            }
            Object object = soapResponseElem;
            return object;
        }
        catch (SocketException e) {
            throw new ConnectException(e.getMessage());
        }
        catch (SOAPException e) {
            this.onvifDevice.getLogger().error("Unexpected response. Response should be from class " + soapResponseElem.getClass() + ", but response is: " + soapResponse);
            throw e;
        }
        catch (IOException | JAXBException | ParserConfigurationException e) {
            this.onvifDevice.getLogger().error("Unhandled exception: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
        finally {
            try {
                soapConnection.close();
            }
            catch (SOAPException sOAPException) {}
        }
    }

    protected SOAPMessage createSoapMessage(Object soapRequestElem, boolean needAuthentification) throws SOAPException, ParserConfigurationException, JAXBException {
        MessageFactory messageFactory = MessageFactory.newInstance((String)"SOAP 1.2 Protocol");
        SOAPMessage soapMessage = messageFactory.createMessage();
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Marshaller marshaller = JAXBContext.newInstance((Class[])new Class[]{soapRequestElem.getClass()}).createMarshaller();
        marshaller.marshal(soapRequestElem, (Node)document);
        soapMessage.getSOAPBody().addDocument(document);
        this.createSoapHeader(soapMessage);
        soapMessage.saveChanges();
        return soapMessage;
    }

    protected void createSoapHeader(SOAPMessage soapMessage) throws SOAPException {
        this.onvifDevice.createNonce();
        String encrypedPassword = this.onvifDevice.getEncryptedPassword();
        if (encrypedPassword != null && this.onvifDevice.getUsername() != null) {
            SOAPPart sp = soapMessage.getSOAPPart();
            SOAPEnvelope se = sp.getEnvelope();
            SOAPHeader header = soapMessage.getSOAPHeader();
            se.addNamespaceDeclaration("wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
            se.addNamespaceDeclaration("wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            SOAPElement securityElem = header.addChildElement("Security", "wsse");
            SOAPElement usernameTokenElem = securityElem.addChildElement("UsernameToken", "wsse");
            SOAPElement usernameElem = usernameTokenElem.addChildElement("Username", "wsse");
            usernameElem.setTextContent(this.onvifDevice.getUsername());
            SOAPElement passwordElem = usernameTokenElem.addChildElement("Password", "wsse");
            passwordElem.setAttribute("Type", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest");
            passwordElem.setTextContent(encrypedPassword);
            SOAPElement nonceElem = usernameTokenElem.addChildElement("Nonce", "wsse");
            nonceElem.setAttribute("EncodingType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
            nonceElem.setTextContent(this.onvifDevice.getEncryptedNonce());
            SOAPElement createdElem = usernameTokenElem.addChildElement("Created", "wsu");
            createdElem.setTextContent(this.onvifDevice.getLastUTCTime());
        }
    }

    public boolean isLogging() {
        return this.logging;
    }

    public void setLogging(boolean logging) {
        this.logging = logging;
    }
}

