/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.ipcamera.onvif.soap;

import io.antmedia.ipcamera.onvif.log.Logger;
import io.antmedia.ipcamera.onvif.soap.SOAP;
import io.antmedia.ipcamera.onvif.soap.devices.ImagingDevices;
import io.antmedia.ipcamera.onvif.soap.devices.InitialDevices;
import io.antmedia.ipcamera.onvif.soap.devices.MediaDevices;
import io.antmedia.ipcamera.onvif.soap.devices.PtzDevices;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Random;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import javax.xml.soap.SOAPException;
import org.apache.commons.codec.binary.Base64;
import org.onvif.ver10.schema.Capabilities;

public class OnvifDevice {
    private final String HOST_IP;
    private String originalIp;
    private boolean isProxy;
    private String username;
    private String password;
    private String nonce;
    private String utcTime;
    private String serverDeviceUri;
    private String serverPtzUri;
    private String serverMediaUri;
    private String serverImagingUri;
    private String serverEventsUri;
    private SOAP soap;
    private InitialDevices initialDevices;
    private PtzDevices ptzDevices;
    private MediaDevices mediaDevices;
    private ImagingDevices imagingDevices;
    private Logger logger = new Logger();

    public OnvifDevice(String hostIp, String user, String password) throws ConnectException, SOAPException {
        this.HOST_IP = hostIp;
        if (!this.isOnline()) {
            throw new ConnectException("Host not available.");
        }
        this.serverDeviceUri = "http://" + this.HOST_IP + "/onvif/device_service";
        this.username = user;
        this.password = password;
        this.soap = new SOAP(this);
        this.initialDevices = new InitialDevices(this);
        this.ptzDevices = new PtzDevices(this);
        this.mediaDevices = new MediaDevices(this);
        this.imagingDevices = new ImagingDevices(this);
        this.init();
    }

    public OnvifDevice(String hostIp) throws ConnectException, SOAPException {
        this(hostIp, null, null);
    }

    private boolean isOnline() {
        String port = this.HOST_IP.contains(":") ? this.HOST_IP.substring(this.HOST_IP.indexOf(58) + 1) : "80";
        String ip = this.HOST_IP.contains(":") ? this.HOST_IP.substring(0, this.HOST_IP.indexOf(58)) : this.HOST_IP;
        Socket socket = null;
        try {
            try {
                InetSocketAddress sockaddr = new InetSocketAddress(ip, (int)new Integer(port));
                socket = new Socket();
                socket.connect(sockaddr, 5000);
            }
            catch (IOException | NumberFormatException e) {
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return false;
            }
        }
        finally {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    protected void init() throws ConnectException, SOAPException {
        Capabilities capabilities = this.getDevices().getCapabilities();
        if (capabilities == null) {
            throw new ConnectException("Capabilities not reachable.");
        }
        String localDeviceUri = capabilities.getDevice().getXAddr();
        if (localDeviceUri.startsWith("http://")) {
            this.originalIp = localDeviceUri.replace("http://", "");
            this.originalIp = this.originalIp.substring(0, this.originalIp.indexOf(47));
        } else {
            this.logger.error("Unknown/Not implemented local procotol!");
        }
        if (!this.originalIp.equals(this.HOST_IP)) {
            this.isProxy = true;
        }
        if (capabilities.getMedia() != null && capabilities.getMedia().getXAddr() != null) {
            this.serverMediaUri = this.replaceLocalIpWithProxyIp(capabilities.getMedia().getXAddr());
        }
        if (capabilities.getPTZ() != null && capabilities.getPTZ().getXAddr() != null) {
            this.serverPtzUri = this.replaceLocalIpWithProxyIp(capabilities.getPTZ().getXAddr());
        }
        if (capabilities.getImaging() != null && capabilities.getImaging().getXAddr() != null) {
            this.serverImagingUri = this.replaceLocalIpWithProxyIp(capabilities.getImaging().getXAddr());
        }
        if (capabilities.getMedia() != null && capabilities.getEvents().getXAddr() != null) {
            this.serverEventsUri = this.replaceLocalIpWithProxyIp(capabilities.getEvents().getXAddr());
        }
    }

    public String replaceLocalIpWithProxyIp(String original) {
        if (original.startsWith("http:///")) {
            original.replace("http:///", "http://" + this.HOST_IP);
        }
        if (this.isProxy) {
            return original.replace(this.originalIp, this.HOST_IP);
        }
        return original;
    }

    public String getUsername() {
        return this.username;
    }

    public String getEncryptedPassword() {
        return this.encryptPassword();
    }

    public String encryptPassword() {
        byte[] encryptedRaw;
        String nonce = this.getNonce();
        String timestamp = this.getUTCTime();
        String beforeEncryption = String.valueOf(nonce) + timestamp + this.password;
        try {
            encryptedRaw = OnvifDevice.sha1(beforeEncryption);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
        String encoded = Base64.encodeBase64String((byte[])encryptedRaw);
        return encoded;
    }

    private static byte[] sha1(String s) throws NoSuchAlgorithmException {
        MessageDigest SHA1 = null;
        SHA1 = MessageDigest.getInstance("SHA1");
        SHA1.reset();
        SHA1.update(s.getBytes());
        byte[] encryptedRaw = SHA1.digest();
        return encryptedRaw;
    }

    private String getNonce() {
        if (this.nonce == null) {
            this.createNonce();
        }
        return this.nonce;
    }

    public String getEncryptedNonce() {
        if (this.nonce == null) {
            this.createNonce();
        }
        return Base64.encodeBase64String((byte[])this.nonce.getBytes());
    }

    public void createNonce() {
        Random generator = new Random();
        this.nonce = "" + generator.nextInt();
    }

    public String getLastUTCTime() {
        return this.utcTime;
    }

    public String getUTCTime() {
        String utcTime;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-d'T'HH:mm:ss'Z'");
        sdf.setTimeZone(new SimpleTimeZone(2, "UTC"));
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        this.utcTime = utcTime = sdf.format(cal.getTime());
        return utcTime;
    }

    public SOAP getSoap() {
        return this.soap;
    }

    public InitialDevices getDevices() {
        return this.initialDevices;
    }

    public PtzDevices getPtz() {
        return this.ptzDevices;
    }

    public MediaDevices getMedia() {
        return this.mediaDevices;
    }

    public ImagingDevices getImaging() {
        return this.imagingDevices;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getDeviceUri() {
        return this.serverDeviceUri;
    }

    protected String getPtzUri() {
        return this.serverPtzUri;
    }

    protected String getMediaUri() {
        return this.serverMediaUri;
    }

    protected String getImagingUri() {
        return this.serverImagingUri;
    }

    protected String getEventsUri() {
        return this.serverEventsUri;
    }

    public Date getDate() {
        return this.initialDevices.getDate();
    }

    public String getName() {
        return this.initialDevices.getDeviceInformation().getModel();
    }

    public String getHostname() {
        return this.initialDevices.getHostname();
    }

    public String reboot() throws ConnectException, SOAPException {
        return this.initialDevices.reboot();
    }
}

