/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.audio;

import io.antmedia.webrtc.api.IAudioTrackListener;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.webrtc.AudioTrack;
import org.webrtc.CalledByNative;
import org.webrtc.Logging;
import org.webrtc.ThreadUtils;
import org.webrtc.audio.JavaAudioDeviceModule;

public class WebRtcAudioTrack {
    private static final String TAG = "WebRtcAudioTrackExternal";
    private static final int BITS_PER_SAMPLE = 16;
    private static final int CALLBACK_BUFFER_SIZE_MS = 10;
    private static final int BUFFERS_PER_SECOND = 100;
    private static final long AUDIO_TRACK_THREAD_JOIN_TIMEOUT_MS = 2000L;
    private static final int DEFAULT_USAGE = 0;
    private static final int AUDIO_TRACK_START = 0;
    private static final int AUDIO_TRACK_STOP = 1;
    private long nativeAudioTrack;
    private final ThreadUtils.ThreadChecker threadChecker = new ThreadUtils.ThreadChecker();
    private ByteBuffer byteBuffer;
    @Nullable
    private AudioTrack audioTrack;
    private volatile boolean speakerMute;
    private byte[] emptyBytes;
    @Nullable
    private final JavaAudioDeviceModule.AudioTrackErrorCallback errorCallback;
    @Nullable
    private final JavaAudioDeviceModule.AudioTrackStateCallback stateCallback;
    private int readSizeInBytes;
    private int sampleRate;
    private int bytesPerSample;
    private int channels;
    private IAudioTrackListener audioTrackListener;

    public ByteBuffer getPlayoutData() {
        this.byteBuffer.rewind();
        int sizeInBytes = this.byteBuffer.capacity();
        WebRtcAudioTrack.nativeGetPlayoutData(this.nativeAudioTrack, sizeInBytes);
        this.readSizeInBytes = sizeInBytes;
        WebRtcAudioTrack.assertTrue(sizeInBytes <= this.byteBuffer.remaining());
        return this.byteBuffer;
    }

    public int getReadSizeInBytes() {
        return this.readSizeInBytes;
    }

    @CalledByNative
    WebRtcAudioTrack(Object context, Object audioManager) {
        this(context, audioManager, null, null, null);
    }

    WebRtcAudioTrack(Object context, Object audioManager, @Nullable JavaAudioDeviceModule.AudioTrackErrorCallback errorCallback, @Nullable JavaAudioDeviceModule.AudioTrackStateCallback stateCallback, IAudioTrackListener audioTrackListener) {
        this.threadChecker.detachThread();
        this.errorCallback = errorCallback;
        this.stateCallback = stateCallback;
        this.audioTrackListener = audioTrackListener;
    }

    @CalledByNative
    public void setNativeAudioTrack(long nativeAudioTrack) {
        this.nativeAudioTrack = nativeAudioTrack;
    }

    @CalledByNative
    private boolean initPlayout(int sampleRate, int channels, double bufferSizeFactor) {
        int bytesPerFrame;
        this.threadChecker.checkIsOnValidThread();
        this.sampleRate = sampleRate;
        Logging.d(TAG, "initPlayout(sampleRate=" + sampleRate + ", channels=" + channels + ", bufferSizeFactor=" + bufferSizeFactor + ")");
        this.bytesPerSample = bytesPerFrame = channels * 2;
        this.channels = channels;
        this.byteBuffer = ByteBuffer.allocateDirect(bytesPerFrame * (sampleRate / 100));
        Logging.d(TAG, "byteBuffer.capacity: " + this.byteBuffer.capacity());
        this.emptyBytes = new byte[this.byteBuffer.capacity()];
        WebRtcAudioTrack.nativeCacheDirectBufferAddress(this.nativeAudioTrack, this.byteBuffer);
        return true;
    }

    @CalledByNative
    private boolean startPlayout() {
        this.threadChecker.checkIsOnValidThread();
        Logging.d(TAG, "startPlayout(sampleRate=" + this.sampleRate + ", channels=" + this.channels + ")");
        if (this.audioTrackListener != null) {
            this.audioTrackListener.playoutStarted();
        }
        return true;
    }

    public int getBytesPerSample() {
        return this.bytesPerSample;
    }

    @CalledByNative
    private boolean stopPlayout() {
        this.threadChecker.checkIsOnValidThread();
        if (this.audioTrackListener != null) {
            this.audioTrackListener.playoutStopped();
            this.audioTrackListener = null;
        }
        return true;
    }

    @CalledByNative
    private int getStreamMaxVolume() {
        this.threadChecker.checkIsOnValidThread();
        Logging.d(TAG, "getStreamMaxVolume");
        return 0;
    }

    @CalledByNative
    private boolean setStreamVolume(int volume) {
        this.threadChecker.checkIsOnValidThread();
        Logging.d(TAG, "setStreamVolume(" + volume + ")");
        Logging.e(TAG, "The device implements a fixed volume policy.");
        return false;
    }

    @CalledByNative
    private int getStreamVolume() {
        this.threadChecker.checkIsOnValidThread();
        Logging.d(TAG, "getStreamVolume");
        return 0;
    }

    @CalledByNative
    private int GetPlayoutUnderrunCount() {
        Logging.d(TAG, "GetPlayoutUnderrunCount");
        return -2;
    }

    private static void assertTrue(boolean condition) {
        if (!condition) {
            throw new AssertionError((Object)"Expected condition to be true");
        }
    }

    private static native void nativeCacheDirectBufferAddress(long var0, ByteBuffer var2);

    private static native void nativeGetPlayoutData(long var0, int var2);

    public void setSpeakerMute(boolean mute) {
        Logging.w(TAG, "setSpeakerMute(" + mute + ")");
        this.speakerMute = mute;
    }

    private void reportWebRtcAudioTrackInitError(String errorMessage) {
        Logging.e(TAG, "Init playout error: " + errorMessage);
        if (this.errorCallback != null) {
            this.errorCallback.onWebRtcAudioTrackInitError(errorMessage);
        }
    }

    private void reportWebRtcAudioTrackStartError(JavaAudioDeviceModule.AudioTrackStartErrorCode errorCode, String errorMessage) {
        Logging.e(TAG, "Start playout error: " + errorCode + ". " + errorMessage);
        if (this.errorCallback != null) {
            this.errorCallback.onWebRtcAudioTrackStartError(errorCode, errorMessage);
        }
    }

    private void reportWebRtcAudioTrackError(String errorMessage) {
        Logging.e(TAG, "Run-time playback error: " + errorMessage);
        if (this.errorCallback != null) {
            this.errorCallback.onWebRtcAudioTrackError(errorMessage);
        }
    }

    private void doAudioTrackStateCallback(int audioState) {
        Logging.d(TAG, "doAudioTrackStateCallback: " + audioState);
        if (this.stateCallback != null) {
            if (audioState == 0) {
                this.stateCallback.onWebRtcAudioTrackStart();
            } else if (audioState == 1) {
                this.stateCallback.onWebRtcAudioTrackStop();
            } else {
                Logging.e(TAG, "Invalid audio state");
            }
        }
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getChannels() {
        return this.channels;
    }
}

