/*
 * Decompiled with CFR 0.152.
 */
package org.red5.spring;

import org.red5.logging.Red5LoggerFactory;
import org.slf4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class Red5ApplicationContext
extends FileSystemXmlApplicationContext
implements ApplicationContextAware {
    private static final Logger log = Red5LoggerFactory.getLogger(Red5ApplicationContext.class);
    private ApplicationContext parentContext;
    private ApplicationContext applicationContext;
    private boolean refresh = true;

    public void afterPropertiesSet() {
        log.info("Red5ApplicationContext init");
        if (this.parentContext == null) {
            log.debug("Setting application context as parent");
            super.setParent(this.applicationContext);
        }
        super.afterPropertiesSet();
    }

    public void refresh() throws BeansException, IllegalStateException {
        if (this.refresh) {
            super.refresh();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        log.info("setApplicationContext: {}", (Object)applicationContext);
        this.applicationContext = applicationContext;
    }

    public void setParent(ApplicationContext parent) {
        super.setParent(parent);
        this.parentContext = parent;
    }

    public void setRefresh(boolean refresh) {
        this.refresh = refresh;
    }
}

