/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.tomcat;

import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.startup.Tomcat;
import org.red5.logging.Red5LoggerFactory;
import org.red5.server.LoaderBase;
import org.red5.server.api.IApplicationLoader;
import org.red5.server.tomcat.TomcatApplicationContext;
import org.slf4j.Logger;
import org.springframework.context.ApplicationContext;

public class TomcatApplicationLoader
implements IApplicationLoader {
    protected static Logger log = Red5LoggerFactory.getLogger(TomcatApplicationLoader.class);
    private Tomcat embedded;
    private Host host;
    private ApplicationContext rootCtx;

    protected TomcatApplicationLoader(Tomcat embedded, Host host, ApplicationContext rootCtx) {
        this.embedded = embedded;
        this.host = host;
        this.rootCtx = rootCtx;
    }

    @Override
    public ApplicationContext getRootContext() {
        log.debug("getRootContext");
        return this.rootCtx;
    }

    @Override
    public void loadApplication(String contextPath, String virtualHosts, String directory) throws Exception {
        log.debug("Load application - context path: {} directory: {} virtual hosts: {}", new Object[]{contextPath, directory, virtualHosts});
        if (directory.startsWith("file:")) {
            directory = directory.substring(5);
        }
        if (this.host.findChild(contextPath) == null) {
            String[] vhosts;
            Context c = this.embedded.addWebapp(contextPath, directory);
            LoaderBase.setRed5ApplicationContext(contextPath, new TomcatApplicationContext(c));
            this.host.addChild((Container)c);
            for (String s : vhosts = virtualHosts.split(",")) {
                if (!"*".equals(s)) {
                    if (s.indexOf(58) == -1) {
                        this.host.addAlias(s);
                        continue;
                    }
                    this.host.addAlias(s.split(":")[0]);
                    continue;
                }
                log.warn("\"*\" based virtual hosts not supported");
            }
        } else {
            log.warn("Context path already exists with host");
        }
    }
}

