/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.stream;

import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import org.red5.codec.IStreamCodecInfo;
import org.red5.codec.StreamCodecInfo;
import org.red5.io.amf3.Input;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.scope.IScopeHandler;
import org.red5.server.api.stream.IStream;
import org.red5.server.api.stream.IStreamAwareScopeHandler;
import org.red5.server.api.stream.StreamState;
import org.red5.server.net.rtmp.event.Notify;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStream
implements IStream {
    private static final Logger log = LoggerFactory.getLogger(AbstractStream.class);
    protected StreamState state = StreamState.UNINIT;
    private String name;
    private IStreamCodecInfo codecInfo = new StreamCodecInfo();
    private AtomicReference<Notify> metaData = new AtomicReference();
    private IScope scope;
    protected long creationTime;
    protected final transient Semaphore lock = new Semaphore(1, true);
    private long absoluteStartTimeMs;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IStreamCodecInfo getCodecInfo() {
        return this.codecInfo;
    }

    public Notify getMetaData() {
        Notify md = this.metaData.get();
        if (md != null) {
            try {
                return md.duplicate();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return md;
    }

    public void setMetaData(Notify metaData) {
        this.metaData.set(metaData);
        org.red5.io.amf.Input input = new org.red5.io.amf.Input(metaData.getData());
        byte object = input.readDataType();
        if (object == -17) {
            input = new Input(metaData.getData());
            ((Input)input).enforceAMF3();
            object = input.readDataType();
        }
        String actionOnFI = input.readString();
        byte readDataType = input.readDataType();
        if (readDataType == 7) {
            log.info("metadata read data type -->>>> core map");
            Map readMap = (Map)input.readMap();
            Object timeCode = readMap.get("timecode");
            if (timeCode != null) {
                this.absoluteStartTimeMs = Long.parseLong(timeCode.toString());
            }
        } else {
            log.info("metadata read data type -->>>> " + readDataType);
        }
    }

    public long getAbsoluteStartTimeMs() {
        return this.absoluteStartTimeMs;
    }

    @Override
    public IScope getScope() {
        return this.scope;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCodecInfo(IStreamCodecInfo codecInfo) {
        this.codecInfo = codecInfo;
    }

    public void setScope(IScope scope) {
        this.scope = scope;
    }

    public StreamState getState() {
        try {
            this.lock.acquireUninterruptibly();
            StreamState streamState = this.state;
            return streamState;
        }
        finally {
            this.lock.release();
        }
    }

    public void setState(StreamState state) {
        if (!this.state.equals((Object)state)) {
            try {
                this.lock.acquireUninterruptibly();
                this.state = state;
            }
            finally {
                this.lock.release();
            }
        }
    }

    protected IStreamAwareScopeHandler getStreamAwareHandler() {
        IScopeHandler handler;
        if (this.scope != null && (handler = this.scope.getHandler()) instanceof IStreamAwareScopeHandler) {
            return (IStreamAwareScopeHandler)handler;
        }
        return null;
    }
}

