/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.service;

import java.io.File;
import java.io.IOException;
import org.red5.io.IStreamableFile;
import org.red5.server.api.service.IStreamableFileService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseStreamableFileService
implements IStreamableFileService {
    private static final Logger log = LoggerFactory.getLogger(BaseStreamableFileService.class);

    @Override
    public void setPrefix(String prefix) {
    }

    @Override
    public abstract String getPrefix();

    @Override
    public void setExtension(String extension) {
    }

    @Override
    public abstract String getExtension();

    @Override
    public String prepareFilename(String name) {
        String prefix = this.getPrefix() + ":";
        if (((String)name).startsWith(prefix)) {
            name = ((String)name).substring(prefix.length());
            log.debug("prepareFilename - lastIndexOf: {} length: {}", (Object)((String)name).lastIndexOf(46), (Object)((String)name).length());
            if (((String)name).lastIndexOf(46) == -1 || ((String)name).lastIndexOf(46) != ((String)name).length() - 4) {
                name = (String)name + this.getExtension().split(",")[0];
            }
        }
        return name;
    }

    @Override
    public boolean canHandle(File file) {
        boolean valid = false;
        if (file.exists()) {
            String absPath = file.getAbsolutePath().toLowerCase();
            int dotIndex = absPath.lastIndexOf(46);
            if (dotIndex > -1) {
                String[] exts;
                String fileExt = absPath.substring(dotIndex);
                log.debug("canHandle - Path: {} Ext: {}", (Object)absPath, (Object)fileExt);
                for (String ext : exts = this.getExtension().split(",")) {
                    if (!ext.equals(fileExt)) continue;
                    valid = true;
                    break;
                }
            } else {
                log.warn("No file extension was detected, please retry with a supported extension: {}", (Object)this.getExtension());
            }
        }
        return valid;
    }

    @Override
    public abstract IStreamableFile getStreamableFile(File var1) throws IOException;
}

