/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.remoting.codec;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.io.amf3.Input;
import org.red5.io.object.Deserializer;
import org.red5.io.object.Input;
import org.red5.server.net.remoting.message.RemotingCall;
import org.red5.server.net.remoting.message.RemotingPacket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemotingProtocolDecoder {
    protected static Logger log = LoggerFactory.getLogger(RemotingProtocolDecoder.class);

    public List<Object> decodeBuffer(IoBuffer buffer) {
        LinkedList<Object> list = new LinkedList<Object>();
        Object packet = null;
        try {
            packet = this.decode(buffer);
        }
        catch (Exception e) {
            log.error("Decoding error", (Throwable)e);
            packet = null;
        }
        if (packet != null) {
            list.add(packet);
        }
        return list;
    }

    public Object decode(IoBuffer in) throws Exception {
        Map<String, Object> headers = this.readHeaders(in);
        List<RemotingCall> calls = this.decodeCalls(in);
        return new RemotingPacket(headers, calls);
    }

    protected Map<String, Object> readHeaders(IoBuffer in) {
        int version = in.getUnsignedShort();
        int count = in.getUnsignedShort();
        log.debug("Read headers - version: {} count: {}", (Object)version, (Object)count);
        if (count == 0) {
            return Collections.EMPTY_MAP;
        }
        Object input = version == 3 ? new org.red5.io.amf3.Input(in) : new org.red5.io.amf.Input(in);
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (int i = 0; i < count; ++i) {
            String name = input.getString();
            boolean required = in.get() == 1;
            int size = in.getInt();
            Object value = Deserializer.deserialize((Input)input, Object.class);
            log.debug("Header: {} Required: {} Size: {} Value: {}", new Object[]{name, required, size, value});
            result.put(name, value);
        }
        return result;
    }

    protected List<RemotingCall> decodeCalls(IoBuffer in) {
        log.debug("Decode calls");
        LinkedList<RemotingCall> calls = new LinkedList<RemotingCall>();
        Object input = new org.red5.io.amf.Input(in);
        int count = in.getUnsignedShort();
        log.debug("Calls: {}", (Object)count);
        int limit = in.limit();
        for (int i = 0; i < count; ++i) {
            String serviceMethod;
            String serviceName;
            in.limit(limit);
            String serviceString = input.getString();
            String clientCallback = input.getString();
            log.debug("callback: {}", (Object)clientCallback);
            Object[] args = null;
            boolean isAMF3 = false;
            int length = in.getInt();
            byte type = in.get();
            if (type == 10) {
                int elements = in.getInt();
                ArrayList<Object> values = new ArrayList<Object>();
                Input.RefStorage refStorage = null;
                for (int j = 0; j < elements; ++j) {
                    byte amf3Check = in.get();
                    in.position(in.position() - 1);
                    boolean bl = isAMF3 = amf3Check == 17;
                    input = isAMF3 ? (refStorage == null ? new org.red5.io.amf3.Input(in) : new org.red5.io.amf3.Input(in, refStorage)) : new org.red5.io.amf.Input(in);
                    input.reset();
                    values.add(Deserializer.deserialize((Input)input, Object.class));
                    if (!isAMF3) continue;
                    refStorage = ((org.red5.io.amf3.Input)input).getRefStorage();
                }
                args = values.toArray(new Object[values.size()]);
                if (log.isDebugEnabled()) {
                    for (Object element : args) {
                        log.debug("> " + element);
                    }
                }
            } else if (type == 5) {
                log.debug("Got null amf type");
            } else if (type != 10) {
                throw new RuntimeException("AMF0 array type expected but found " + type);
            }
            int dotPos = serviceString.lastIndexOf(46);
            if (dotPos != -1) {
                serviceName = serviceString.substring(0, dotPos);
                serviceMethod = serviceString.substring(dotPos + 1, serviceString.length());
            } else {
                serviceName = "";
                serviceMethod = serviceString;
            }
            boolean isMessaging = false;
            if ("".equals(serviceName) && "null".equals(serviceMethod)) {
                serviceName = "flexMessaging";
                serviceMethod = "handleRequest";
                isMessaging = true;
            }
            log.debug("Service: {} Method: {}", (Object)serviceName, (Object)serviceMethod);
            calls.add(new RemotingCall(serviceName, serviceMethod, args, clientCallback, isAMF3, isMessaging));
        }
        return calls;
    }
}

