/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.messaging;

import java.io.IOException;
import java.util.Map;
import org.red5.server.messaging.AbstractPipe;
import org.red5.server.messaging.IConsumer;
import org.red5.server.messaging.IMessage;
import org.red5.server.messaging.IPipeConnectionListener;
import org.red5.server.messaging.IProvider;
import org.red5.server.messaging.IPushableConsumer;
import org.red5.server.messaging.PipeConnectionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryPushPushPipe
extends AbstractPipe {
    private static final Logger log = LoggerFactory.getLogger(InMemoryPushPushPipe.class);

    public InMemoryPushPushPipe() {
    }

    public InMemoryPushPushPipe(IPipeConnectionListener listener) {
        this();
        this.addPipeConnectionListener(listener);
    }

    @Override
    public boolean subscribe(IConsumer consumer, Map<String, Object> paramMap) {
        if (consumer instanceof IPushableConsumer) {
            boolean success = super.subscribe(consumer, paramMap);
            if (log.isDebugEnabled()) {
                log.debug("Consumer subscribe{} {} params: {}", new Object[]{success ? "d" : " failed", consumer, paramMap});
            }
            if (success) {
                this.fireConsumerConnectionEvent(consumer, PipeConnectionEvent.EventType.CONSUMER_CONNECT_PUSH, paramMap);
            }
            return success;
        }
        throw new IllegalArgumentException("Non-pushable consumer not supported by PushPushPipe");
    }

    @Override
    public boolean subscribe(IProvider provider, Map<String, Object> paramMap) {
        boolean success = super.subscribe(provider, paramMap);
        if (log.isDebugEnabled()) {
            log.debug("Provider subscribe{} {} params: {}", new Object[]{success ? "d" : " failed", provider, paramMap});
        }
        if (success) {
            this.fireProviderConnectionEvent(provider, PipeConnectionEvent.EventType.PROVIDER_CONNECT_PUSH, paramMap);
        }
        return success;
    }

    @Override
    public IMessage pullMessage() {
        return null;
    }

    @Override
    public IMessage pullMessage(long wait) {
        return null;
    }

    @Override
    public void pushMessage(IMessage message) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("pushMessage: {} to {} consumers", (Object)message, (Object)this.consumers.size());
        }
        for (IConsumer consumer : this.consumers) {
            try {
                IPushableConsumer pcon = (IPushableConsumer)consumer;
                pcon.pushMessage(this, message);
            }
            catch (Throwable t) {
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                log.error("Exception pushing message to consumer", t);
            }
        }
    }
}

