/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.api.service;

import org.red5.server.api.IClient;
import org.red5.server.api.IConnection;
import org.red5.server.api.Red5;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.service.IPendingServiceCallback;
import org.red5.server.api.service.IServiceCapableConnection;
import org.red5.server.net.rtmp.event.ClientInvokeEvent;
import org.red5.server.net.rtmp.event.ClientNotifyEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceUtils {
    private static final Logger log = LoggerFactory.getLogger(ServiceUtils.class);

    public static boolean invokeOnConnection(String method, Object[] params) {
        return ServiceUtils.invokeOnConnection(method, params, null);
    }

    public static boolean invokeOnConnection(String method, Object[] params, IPendingServiceCallback callback) {
        IConnection conn = Red5.getConnectionLocal();
        if (conn != null) {
            log.debug("Connection for invoke: {}", (Object)conn);
            return ServiceUtils.invokeOnConnection(conn, method, params, callback);
        }
        log.warn("Connection was null (thread local), cannot execute invoke request");
        return false;
    }

    public static boolean invokeOnConnection(IConnection conn, String method, Object[] params) {
        return ServiceUtils.invokeOnConnection(conn, method, params, null);
    }

    public static boolean invokeOnConnection(IConnection conn, String method, Object[] params, IPendingServiceCallback callback) {
        if (conn instanceof IServiceCapableConnection) {
            if (callback == null) {
                ((IServiceCapableConnection)conn).invoke(method, params);
            } else {
                ((IServiceCapableConnection)conn).invoke(method, params, callback);
            }
            return true;
        }
        return false;
    }

    public static void invokeOnAllConnections(String method, Object[] params) {
        ServiceUtils.invokeOnAllConnections(method, params, null);
    }

    public static void invokeOnAllConnections(String method, Object[] params, IPendingServiceCallback callback) {
        IConnection conn = Red5.getConnectionLocal();
        if (conn != null) {
            log.debug("Connection for invoke on all: {}", (Object)conn);
            IScope scope = conn.getScope();
            log.debug("Scope for invoke on all: {}", (Object)scope);
            ServiceUtils.invokeOnAllScopeConnections(scope, method, params, callback);
        } else {
            log.warn("Connection was null (thread local), scope cannot be located and cannot execute invoke request");
        }
    }

    @Deprecated
    public static void invokeOnAllConnections(IScope scope, String method, Object[] params) {
        ServiceUtils.invokeOnAllScopeConnections(scope, method, params, null);
    }

    public static void invokeOnAllConnections(IScope scope, String method, Object[] params, IPendingServiceCallback callback) {
        ServiceUtils.invokeOnClient(null, scope, method, params, callback);
    }

    public static void invokeOnAllScopeConnections(IScope scope, String method, Object[] params, IPendingServiceCallback callback) {
        ClientInvokeEvent event = ClientInvokeEvent.build(method, params, callback);
        scope.dispatchEvent(event);
    }

    public static void invokeOnClient(IClient client, IScope scope, String method, Object[] params) {
        ServiceUtils.invokeOnClient(client, scope, method, params, null);
    }

    @Deprecated
    public static void invokeOnClient(IClient client, IScope scope, String method, Object[] params, IPendingServiceCallback callback) {
        if (client == null) {
            ServiceUtils.invokeOnAllScopeConnections(scope, method, params, callback);
        } else {
            IConnection conn = scope.lookupConnection(client);
            if (conn != null) {
                if (callback == null) {
                    ServiceUtils.invokeOnConnection(conn, method, params);
                } else {
                    ServiceUtils.invokeOnConnection(conn, method, params, callback);
                }
            }
        }
    }

    public static boolean notifyOnConnection(String method, Object[] params) {
        IConnection conn = Red5.getConnectionLocal();
        if (conn != null) {
            log.debug("Connection for notify: {}", (Object)conn);
            return ServiceUtils.notifyOnConnection(conn, method, params);
        }
        log.warn("Connection was null (thread local), cannot execute notify request");
        return false;
    }

    public static boolean notifyOnConnection(IConnection conn, String method, Object[] params) {
        if (conn instanceof IServiceCapableConnection) {
            ((IServiceCapableConnection)conn).notify(method, params);
            return true;
        }
        return false;
    }

    public static void notifyOnAllConnections(String method, Object[] params) {
        IConnection conn = Red5.getConnectionLocal();
        if (conn != null) {
            log.debug("Connection for notify on all: {}", (Object)conn);
            IScope scope = conn.getScope();
            log.debug("Scope for notify on all: {}", (Object)scope);
            ServiceUtils.notifyOnAllScopeConnections(scope, method, params);
        } else {
            log.warn("Connection was null (thread local), scope cannot be located and cannot execute notify request");
        }
    }

    @Deprecated
    public static void notifyOnAllConnections(IScope scope, String method, Object[] params) {
        ServiceUtils.notifyOnAllScopeConnections(scope, method, params);
    }

    public static void notifyOnAllScopeConnections(IScope scope, String method, Object[] params) {
        ClientNotifyEvent event = ClientNotifyEvent.build(method, params);
        scope.dispatchEvent(event);
    }

    @Deprecated
    public static void notifyOnClient(IClient client, IScope scope, String method, Object[] params) {
        if (client == null) {
            ServiceUtils.notifyOnAllScopeConnections(scope, method, params);
        } else {
            IConnection conn = scope.lookupConnection(client);
            if (conn != null) {
                ServiceUtils.notifyOnConnection(conn, method, params);
            }
        }
    }
}

