/*
 * Decompiled with CFR 0.152.
 */
package org.red5.logging;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.selector.ContextSelector;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.red5.logging.LoggingContextSelector;
import org.red5.logging.Red5LoggerFactory;
import org.slf4j.Logger;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.WebApplicationContext;

public class ContextLoggingListener
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent event) {
        ServletContext servletContext = event.getServletContext();
        String contextName = servletContext.getContextPath().replaceAll("/", "");
        if ("".equals(contextName)) {
            contextName = "root";
        }
        System.out.printf("Context init: %s%n", contextName);
        ConfigurableWebApplicationContext appctx = (ConfigurableWebApplicationContext)servletContext.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        if (appctx != null) {
            System.out.printf("ConfigurableWebApplicationContext is not null in ContextLoggingListener for: %s, this indicates a misconfiguration or load order problem%n", contextName);
        }
        try {
            ContextSelector selector = Red5LoggerFactory.getContextSelector();
            URL url = servletContext.getResource(String.format("/WEB-INF/classes/logback-%s.xml", contextName));
            if (url != null && Files.exists(Paths.get(url.toURI()), new LinkOption[0])) {
                System.out.printf("Context logger config found: %s%n", url.toURI());
            } else {
                url = servletContext.getResource("/WEB-INF/classes/logback.xml");
                if (url != null && Files.exists(Paths.get(url.toURI()), new LinkOption[0])) {
                    System.out.printf("Context logger config found: %s%n", url.toURI());
                }
            }
            LoggerContext loggerContext = url != null ? ((LoggingContextSelector)selector).getLoggerContext(contextName, url) : selector.getLoggerContext(contextName);
            servletContext.setAttribute("logger.context", (Object)loggerContext);
            Logger logger = Red5LoggerFactory.getLogger("ROOT", contextName);
            logger.info("Starting up context: {}", (Object)contextName);
        }
        catch (Exception e) {
            System.err.printf("LoggingContextSelector is not the correct type: %s%n", e.getMessage());
            e.printStackTrace();
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        ServletContext servletContext = event.getServletContext();
        LoggerContext context = (LoggerContext)servletContext.getAttribute("logger.context");
        if (context != null) {
            ch.qos.logback.classic.Logger logger = context.getLogger("ROOT");
            logger.debug("Shutting down context {}", (Object)context.getName());
            context.reset();
            context.stop();
        } else {
            System.err.printf("No logger context found for %s%n", event.getServletContext().getContextPath());
        }
    }
}

