/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.storage;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.event.ProgressEventType;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerBuilder;
import com.amazonaws.services.s3.transfer.Upload;
import io.antmedia.storage.StorageClient;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmazonS3StorageClient
extends StorageClient {
    private AmazonS3 amazonS3;
    protected static Logger logger = LoggerFactory.getLogger(AmazonS3StorageClient.class);

    public AmazonS3 getAmazonS3() {
        if (this.amazonS3 == null) {
            this.amazonS3 = this.initAmazonS3();
        }
        return this.amazonS3;
    }

    public AmazonS3 initAmazonS3() {
        AmazonS3ClientBuilder builder = AmazonS3ClientBuilder.standard();
        if (this.getEndpoint() != null && !this.getEndpoint().isEmpty() && this.getRegion() != null) {
            builder = (AmazonS3ClientBuilder)builder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.getEndpoint(), this.getRegion()));
        }
        if (this.getAccessKey() != null) {
            BasicAWSCredentials awsCredentials = new BasicAWSCredentials(this.getAccessKey(), this.getSecretKey());
            builder = (AmazonS3ClientBuilder)builder.withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)awsCredentials));
        }
        if ((this.getEndpoint() == null || this.getEndpoint().isEmpty()) && this.getRegion() != null) {
            builder = (AmazonS3ClientBuilder)builder.withRegion(Regions.fromName((String)this.getRegion()));
        }
        builder.withClientConfiguration(new ClientConfiguration().withMaxConnections(100).withConnectionTimeout(120000).withMaxErrorRetry(15));
        return (AmazonS3)builder.build();
    }

    @Override
    public void delete(String key) {
        if (this.isEnabled()) {
            AmazonS3 s3 = this.getAmazonS3();
            s3.deleteObject(this.getStorageName(), key);
        } else {
            logger.debug("S3 is not enabled to delete the file: {}", (Object)key);
        }
    }

    @Override
    public boolean fileExist(String key) {
        if (this.isEnabled()) {
            return this.getAmazonS3().doesObjectExist(this.getStorageName(), key);
        }
        logger.debug("S3 is not enabled to check the file existence: {}", (Object)key);
        return false;
    }

    public void save(File file, String type) {
        this.save(type + "/" + file.getName(), file);
    }

    @Override
    public void save(String key, File file, boolean deleteLocalFile) {
        if (this.isEnabled()) {
            TransferManager tm = this.getTransferManager();
            PutObjectRequest putRequest = new PutObjectRequest(this.getStorageName(), key, file);
            putRequest.setCannedAcl(this.getCannedAcl());
            Upload upload = tm.upload(putRequest);
            logger.info("{} upload has started with key: {}", (Object)file.getName(), (Object)key);
            upload.addProgressListener(event -> {
                if (event.getEventType() == ProgressEventType.TRANSFER_FAILED_EVENT) {
                    logger.error("S3 - Error: Upload failed for {} with key {}", (Object)file.getName(), (Object)key);
                } else if (event.getEventType() == ProgressEventType.TRANSFER_COMPLETED_EVENT) {
                    if (deleteLocalFile) {
                        this.deleteFile(file);
                    }
                    logger.info("File {} uploaded to S3 with key: {}", (Object)file.getName(), (Object)key);
                }
            });
            try {
                upload.waitForCompletion();
                logger.info("{} upload completed", (Object)file.getName());
            }
            catch (AmazonServiceException e1) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e1));
            }
            catch (InterruptedException e1) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e1));
                Thread.currentThread().interrupt();
            }
        } else {
            logger.debug("S3 is not enabled to save the file: {}", (Object)key);
        }
    }

    public TransferManager getTransferManager() {
        return TransferManagerBuilder.standard().withS3Client(this.getAmazonS3()).build();
    }

    public void deleteFile(File file) {
        try {
            Files.delete(file.toPath());
        }
        catch (IOException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    @Override
    public void reset() {
        this.amazonS3 = null;
    }

    public CannedAccessControlList getCannedAcl() {
        switch (this.getPermission()) {
            case "public-read": {
                return CannedAccessControlList.PublicRead;
            }
            case "private": {
                return CannedAccessControlList.Private;
            }
            case "public-read-write": {
                return CannedAccessControlList.PublicReadWrite;
            }
            case "authenticated-read": {
                return CannedAccessControlList.AuthenticatedRead;
            }
            case "log-delivery-write": {
                return CannedAccessControlList.LogDeliveryWrite;
            }
            case "bucket-owner-read": {
                return CannedAccessControlList.BucketOwnerRead;
            }
            case "bucket-owner-full-control": {
                return CannedAccessControlList.BucketOwnerFullControl;
            }
            case "aws-exec-read": {
                return CannedAccessControlList.AwsExecRead;
            }
        }
        return CannedAccessControlList.PublicRead;
    }
}

