/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.security;

import io.antmedia.datastore.db.DataStore;
import io.antmedia.datastore.db.DataStoreFactory;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.licence.ILicenceService;
import java.util.Map;
import org.red5.server.api.IConnection;
import org.red5.server.api.Red5;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.stream.IStreamPublishSecurity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class AcceptOnlyStreamsInDataStore
implements IStreamPublishSecurity {
    @Autowired
    private DataStoreFactory dataStoreFactory;
    private DataStore dataStore;
    @Value(value="${settings.acceptOnlyStreamsInDataStore:true}")
    private boolean enabled = true;
    private ILicenceService licenService = null;
    public static final String BEAN_NAME = "acceptOnlyStreamsInDataStore";
    protected static Logger logger = LoggerFactory.getLogger(AcceptOnlyStreamsInDataStore.class);

    @Override
    public boolean isPublishAllowed(IScope scope, String name, String mode, Map<String, String> queryParams) {
        ILicenceService licenceService;
        boolean result = false;
        if (this.enabled) {
            Broadcast broadcast = this.getDatastore().get(name);
            result = broadcast != null;
        } else {
            logger.info("AcceptOnlyStreamsInDataStore is not activated. Accepting all streams {}", (Object)name);
            result = true;
        }
        if (result && (licenceService = this.getLicenceService(scope)).isLicenceSuspended()) {
            logger.info("License is suspended and not accepting connection for {}", (Object)name);
            result = false;
        }
        if (!result) {
            IConnection connectionLocal = Red5.getConnectionLocal();
            if (connectionLocal != null) {
                connectionLocal.close();
            } else {
                logger.warn("Connection object is null for {}", (Object)name);
            }
        }
        return result;
    }

    public ILicenceService getLicenceService(IScope scope) {
        return (ILicenceService)scope.getContext().getBean(ILicenceService.BeanName.LICENCE_SERVICE.toString());
    }

    public DataStore getDatastore() {
        if (this.dataStore == null) {
            this.dataStore = this.dataStoreFactory.getDataStore();
        }
        return this.dataStore;
    }

    public void setDataStore(DataStore dataStore) {
        this.dataStore = dataStore;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public DataStoreFactory getDataStoreFactory() {
        return this.dataStoreFactory;
    }

    public void setDataStoreFactory(DataStoreFactory dataStoreFactory) {
        this.dataStoreFactory = dataStoreFactory;
    }
}

