/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.recorder;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.LongPointer;
import org.bytedeco.javacpp.ShortPointer;
import org.bytedeco.javacpp.indexer.ByteIndexer;
import org.bytedeco.javacpp.indexer.DoubleIndexer;
import org.bytedeco.javacpp.indexer.FloatIndexer;
import org.bytedeco.javacpp.indexer.Indexable;
import org.bytedeco.javacpp.indexer.Indexer;
import org.bytedeco.javacpp.indexer.IntIndexer;
import org.bytedeco.javacpp.indexer.LongIndexer;
import org.bytedeco.javacpp.indexer.ShortIndexer;
import org.bytedeco.javacpp.indexer.UByteIndexer;
import org.bytedeco.javacpp.indexer.UShortIndexer;

public class Frame
implements Indexable {
    public boolean keyFrame;
    public static final int DEPTH_BYTE = -8;
    public static final int DEPTH_UBYTE = 8;
    public static final int DEPTH_SHORT = -16;
    public static final int DEPTH_USHORT = 16;
    public static final int DEPTH_INT = -32;
    public static final int DEPTH_LONG = -64;
    public static final int DEPTH_FLOAT = 32;
    public static final int DEPTH_DOUBLE = 64;
    public int imageWidth;
    public int imageHeight;
    public int imageDepth;
    public int imageChannels;
    public int imageStride;
    public Buffer[] image;
    public int sampleRate;
    public int audioChannels;
    public Buffer[] samples;
    public Object opaque;
    public long timestamp;

    public Frame() {
    }

    public Frame(int width, int height, int depth, int channels) {
        int pixelSize = Math.abs(depth) / 8;
        this.imageWidth = width;
        this.imageHeight = height;
        this.imageDepth = depth;
        this.imageChannels = channels;
        this.imageStride = (this.imageWidth * this.imageChannels * pixelSize + 7 & 0xFFFFFFF8) / pixelSize;
        this.image = new Buffer[1];
        ByteBuffer buffer = ByteBuffer.allocateDirect(this.imageHeight * this.imageStride * pixelSize).order(ByteOrder.nativeOrder());
        switch (this.imageDepth) {
            case -8: 
            case 8: {
                this.image[0] = buffer;
                break;
            }
            case -16: 
            case 16: {
                this.image[0] = buffer.asShortBuffer();
                break;
            }
            case -32: {
                this.image[0] = buffer.asIntBuffer();
                break;
            }
            case -64: {
                this.image[0] = buffer.asLongBuffer();
                break;
            }
            case 32: {
                this.image[0] = buffer.asFloatBuffer();
                break;
            }
            case 64: {
                this.image[0] = buffer.asDoubleBuffer();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported depth value: " + this.imageDepth);
            }
        }
    }

    public <I extends Indexer> I createIndexer() {
        return this.createIndexer(true, 0);
    }

    public <I extends Indexer> I createIndexer(boolean direct) {
        return this.createIndexer(direct, 0);
    }

    public <I extends Indexer> I createIndexer(boolean direct, int i) {
        long[] sizes = new long[]{this.imageHeight, this.imageWidth, this.imageChannels};
        long[] strides = new long[]{this.imageStride, this.imageChannels, 1L};
        Buffer buffer = this.image[i];
        Object array = buffer.hasArray() ? buffer.array() : null;
        switch (this.imageDepth) {
            case 8: {
                return (I)(array != null ? UByteIndexer.create((byte[])((byte[])array), (long[])sizes, (long[])strides).indexable((Indexable)this) : (direct ? UByteIndexer.create((ByteBuffer)((ByteBuffer)buffer), (long[])sizes, (long[])strides).indexable((Indexable)this) : UByteIndexer.create((BytePointer)new BytePointer((ByteBuffer)buffer), (long[])sizes, (long[])strides, (boolean)false).indexable((Indexable)this)));
            }
            case -8: {
                return (I)(array != null ? ByteIndexer.create((byte[])((byte[])array), (long[])sizes, (long[])strides).indexable((Indexable)this) : (direct ? ByteIndexer.create((ByteBuffer)((ByteBuffer)buffer), (long[])sizes, (long[])strides).indexable((Indexable)this) : ByteIndexer.create((BytePointer)new BytePointer((ByteBuffer)buffer), (long[])sizes, (long[])strides, (boolean)false).indexable((Indexable)this)));
            }
            case 16: {
                return (I)(array != null ? UShortIndexer.create((short[])((short[])array), (long[])sizes, (long[])strides).indexable((Indexable)this) : (direct ? UShortIndexer.create((ShortBuffer)((ShortBuffer)buffer), (long[])sizes, (long[])strides).indexable((Indexable)this) : UShortIndexer.create((ShortPointer)new ShortPointer((ShortBuffer)buffer), (long[])sizes, (long[])strides, (boolean)false).indexable((Indexable)this)));
            }
            case -16: {
                return (I)(array != null ? ShortIndexer.create((short[])((short[])array), (long[])sizes, (long[])strides).indexable((Indexable)this) : (direct ? ShortIndexer.create((ShortBuffer)((ShortBuffer)buffer), (long[])sizes, (long[])strides).indexable((Indexable)this) : ShortIndexer.create((ShortPointer)new ShortPointer((ShortBuffer)buffer), (long[])sizes, (long[])strides, (boolean)false).indexable((Indexable)this)));
            }
            case -32: {
                return (I)(array != null ? IntIndexer.create((int[])((int[])array), (long[])sizes, (long[])strides).indexable((Indexable)this) : (direct ? IntIndexer.create((IntBuffer)((IntBuffer)buffer), (long[])sizes, (long[])strides).indexable((Indexable)this) : IntIndexer.create((IntPointer)new IntPointer((IntBuffer)buffer), (long[])sizes, (long[])strides, (boolean)false).indexable((Indexable)this)));
            }
            case -64: {
                return (I)(array != null ? LongIndexer.create((long[])((long[])array), (long[])sizes, (long[])strides).indexable((Indexable)this) : (direct ? LongIndexer.create((LongBuffer)((LongBuffer)buffer), (long[])sizes, (long[])strides).indexable((Indexable)this) : LongIndexer.create((LongPointer)new LongPointer((LongBuffer)buffer), (long[])sizes, (long[])strides, (boolean)false).indexable((Indexable)this)));
            }
            case 32: {
                return (I)(array != null ? FloatIndexer.create((float[])((float[])array), (long[])sizes, (long[])strides).indexable((Indexable)this) : (direct ? FloatIndexer.create((FloatBuffer)((FloatBuffer)buffer), (long[])sizes, (long[])strides).indexable((Indexable)this) : FloatIndexer.create((FloatPointer)new FloatPointer((FloatBuffer)buffer), (long[])sizes, (long[])strides, (boolean)false).indexable((Indexable)this)));
            }
            case 64: {
                return (I)(array != null ? DoubleIndexer.create((double[])((double[])array), (long[])sizes, (long[])strides).indexable((Indexable)this) : (direct ? DoubleIndexer.create((DoubleBuffer)((DoubleBuffer)buffer), (long[])sizes, (long[])strides).indexable((Indexable)this) : DoubleIndexer.create((DoublePointer)new DoublePointer((DoubleBuffer)buffer), (long[])sizes, (long[])strides, (boolean)false).indexable((Indexable)this)));
            }
        }
        assert (false);
        return null;
    }

    public Frame clone() {
        Frame newFrame = new Frame();
        newFrame.imageWidth = this.imageWidth;
        newFrame.imageHeight = this.imageHeight;
        newFrame.imageDepth = this.imageDepth;
        newFrame.imageChannels = this.imageChannels;
        newFrame.imageStride = this.imageStride;
        newFrame.keyFrame = this.keyFrame;
        newFrame.opaque = this.opaque;
        newFrame.image = Frame.cloneBufferArray(this.image);
        newFrame.audioChannels = this.audioChannels;
        newFrame.sampleRate = this.sampleRate;
        newFrame.samples = Frame.cloneBufferArray(this.samples);
        newFrame.timestamp = this.timestamp;
        return newFrame;
    }

    private static Buffer[] cloneBufferArray(Buffer[] srcBuffers) {
        Buffer[] clonedBuffers = null;
        if (srcBuffers != null) {
            int dataSize;
            int i;
            clonedBuffers = new Buffer[srcBuffers.length];
            for (i = 0; i < srcBuffers.length; ++i) {
                srcBuffers[i].rewind();
            }
            if (srcBuffers[0] instanceof ByteBuffer) {
                for (i = 0; i < srcBuffers.length; ++i) {
                    clonedBuffers[i] = ByteBuffer.allocateDirect(srcBuffers[i].capacity()).put((ByteBuffer)srcBuffers[i]).rewind();
                }
            } else if (srcBuffers[0] instanceof ShortBuffer) {
                dataSize = 2;
                for (i = 0; i < srcBuffers.length; ++i) {
                    clonedBuffers[i] = ByteBuffer.allocateDirect(srcBuffers[i].capacity() * dataSize).order(ByteOrder.nativeOrder()).asShortBuffer().put((ShortBuffer)srcBuffers[i]).rewind();
                }
            } else if (srcBuffers[0] instanceof IntBuffer) {
                dataSize = 4;
                for (i = 0; i < srcBuffers.length; ++i) {
                    clonedBuffers[i] = ByteBuffer.allocateDirect(srcBuffers[i].capacity() * dataSize).order(ByteOrder.nativeOrder()).asIntBuffer().put((IntBuffer)srcBuffers[i]).rewind();
                }
            } else if (srcBuffers[0] instanceof LongBuffer) {
                dataSize = 8;
                for (i = 0; i < srcBuffers.length; ++i) {
                    clonedBuffers[i] = ByteBuffer.allocateDirect(srcBuffers[i].capacity() * dataSize).order(ByteOrder.nativeOrder()).asLongBuffer().put((LongBuffer)srcBuffers[i]).rewind();
                }
            } else if (srcBuffers[0] instanceof FloatBuffer) {
                dataSize = 4;
                for (i = 0; i < srcBuffers.length; ++i) {
                    clonedBuffers[i] = ByteBuffer.allocateDirect(srcBuffers[i].capacity() * dataSize).order(ByteOrder.nativeOrder()).asFloatBuffer().put((FloatBuffer)srcBuffers[i]).rewind();
                }
            } else if (srcBuffers[0] instanceof DoubleBuffer) {
                dataSize = 8;
                for (i = 0; i < srcBuffers.length; ++i) {
                    clonedBuffers[i] = ByteBuffer.allocateDirect(srcBuffers[i].capacity() * dataSize).order(ByteOrder.nativeOrder()).asDoubleBuffer().put((DoubleBuffer)srcBuffers[i]).rewind();
                }
            }
            for (i = 0; i < srcBuffers.length; ++i) {
                srcBuffers[i].rewind();
            }
        }
        return clonedBuffers;
    }
}

