/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.muxer;

import io.antmedia.muxer.Muxer;
import io.antmedia.storage.StorageClient;
import io.vertx.core.Vertx;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bytedeco.ffmpeg.avcodec.AVBSFContext;
import org.bytedeco.ffmpeg.avcodec.AVBitStreamFilter;
import org.bytedeco.ffmpeg.avcodec.AVCodec;
import org.bytedeco.ffmpeg.avcodec.AVCodecContext;
import org.bytedeco.ffmpeg.avcodec.AVCodecParameters;
import org.bytedeco.ffmpeg.avcodec.AVPacket;
import org.bytedeco.ffmpeg.avformat.AVFormatContext;
import org.bytedeco.ffmpeg.avformat.AVIOContext;
import org.bytedeco.ffmpeg.avformat.AVStream;
import org.bytedeco.ffmpeg.avutil.AVDictionary;
import org.bytedeco.ffmpeg.avutil.AVRational;
import org.bytedeco.ffmpeg.global.avcodec;
import org.bytedeco.ffmpeg.global.avformat;
import org.bytedeco.ffmpeg.global.avutil;
import org.bytedeco.javacpp.BytePointer;
import org.red5.server.api.scope.IScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HLSMuxer
extends Muxer {
    private AVBSFContext bsfContext;
    private long lastDTS = -1L;
    protected static Logger logger = LoggerFactory.getLogger(HLSMuxer.class);
    private String hlsListSize = "20";
    private String hlsTime = "5";
    private String hlsPlayListType = null;
    private AVRational avRationalTimeBase;
    private long totalSize;
    private long partialTotalSize;
    private long startTime;
    private long currentTime;
    private long bitrate;
    private long bitrateReferenceTime;
    int videoWidth;
    int videoHeight;
    private AVPacket tmpPacket;
    private boolean deleteFileOnExit = true;
    private int audioIndex;
    private int videoIndex;
    private String hlsFlags;
    private String streamId;
    private String hlsEncryptionKeyInfoFile = null;
    private Map<Integer, AVRational> codecTimeBaseMap = new HashMap<Integer, AVRational>();
    private AVPacket videoPkt;
    protected StorageClient storageClient = null;
    private String subFolder = null;
    private String s3StreamsFolderPath = "streams";
    private boolean uploadHLSToS3 = true;
    private String segmentFilename;
    private static final int S3_CONSTANT = 2;

    public HLSMuxer(Vertx vertx, StorageClient storageClient, String s3StreamsFolderPath, int uploadExtensionsToS3) {
        super(vertx);
        this.storageClient = storageClient;
        if ((2 & uploadExtensionsToS3) == 0) {
            this.uploadHLSToS3 = false;
        }
        this.extension = ".m3u8";
        this.format = "hls";
        this.avRationalTimeBase = new AVRational();
        this.avRationalTimeBase.num(1);
        this.avRationalTimeBase.den(1);
        this.s3StreamsFolderPath = s3StreamsFolderPath;
    }

    public void setHlsParameters(String hlsListSize, String hlsTime, String hlsPlayListType, String hlsFlags, String hlsEncryptionKeyInfoFile) {
        if (hlsListSize != null) {
            this.hlsListSize = hlsListSize;
        }
        if (hlsTime != null) {
            this.hlsTime = hlsTime;
        }
        if (hlsPlayListType != null) {
            this.hlsPlayListType = hlsPlayListType;
        }
        this.hlsFlags = hlsFlags != null ? hlsFlags : "";
        if (hlsEncryptionKeyInfoFile != null && !hlsEncryptionKeyInfoFile.isEmpty()) {
            this.hlsEncryptionKeyInfoFile = hlsEncryptionKeyInfoFile;
        }
    }

    @Override
    public void init(IScope scope, String name, int resolutionHeight, String subFolder, int bitrate) {
        if (!this.isInitialized) {
            super.init(scope, name, resolutionHeight, subFolder, bitrate);
            this.streamId = name;
            this.subFolder = subFolder;
            this.options.put("hls_list_size", this.hlsListSize);
            this.options.put("hls_time", this.hlsTime);
            if (this.hlsEncryptionKeyInfoFile != null) {
                this.options.put("hls_key_info_file", this.hlsEncryptionKeyInfoFile);
            }
            this.bitrate = bitrate;
            logger.info("hls time: {}, hls list size: {} for stream:{}", new Object[]{this.hlsTime, this.hlsListSize, this.streamId});
            int bitrateKbps = bitrate / 1000;
            this.segmentFilename = this.file.getParentFile() + File.separator + name + "_";
            if (resolutionHeight != 0) {
                this.segmentFilename = this.segmentFilename + resolutionHeight + "p";
                if (bitrate != 0) {
                    this.segmentFilename = this.segmentFilename + bitrateKbps + "kbps";
                }
            }
            this.segmentFilename = this.segmentFilename + "%04d.ts";
            this.options.put("hls_segment_filename", this.segmentFilename);
            if (this.hlsPlayListType != null && (this.hlsPlayListType.equals("event") || this.hlsPlayListType.equals("vod"))) {
                this.options.put("hls_playlist_type", this.hlsPlayListType);
            }
            if (this.hlsFlags != null && !this.hlsFlags.isEmpty()) {
                this.options.put("hls_flags", this.hlsFlags);
            }
            this.tmpPacket = avcodec.av_packet_alloc();
            avcodec.av_init_packet((AVPacket)this.tmpPacket);
            this.videoPkt = avcodec.av_packet_alloc();
            avcodec.av_init_packet((AVPacket)this.videoPkt);
            this.isInitialized = true;
        }
    }

    public static void writeToFile(String absolutePath, String content) {
        block2: {
            try {
                Files.write(new File(absolutePath).toPath(), content.getBytes(), StandardOpenOption.CREATE);
            }
            catch (IOException e) {
                if (logger == null) break block2;
                logger.error(e.toString());
            }
        }
    }

    private AVFormatContext getOutputFormatContext() {
        if (this.outputFormatContext == null) {
            this.outputFormatContext = new AVFormatContext(null);
            int ret = avformat.avformat_alloc_output_context2((AVFormatContext)this.outputFormatContext, null, (String)this.format, (String)this.file.getAbsolutePath());
            if (ret < 0) {
                logger.info("Could not create output context for {}", (Object)this.file.getName());
                return null;
            }
        }
        return this.outputFormatContext;
    }

    private boolean isCodecSupported(int codecId) {
        return codecId == 27 || codecId == 86018 || codecId == 86017 || codecId == 173;
    }

    public long getBitrate() {
        return this.bitrate;
    }

    public long getAverageBitrate() {
        long duration = this.currentTime - this.startTime;
        if (duration > 0L) {
            return this.totalSize / duration * 8L;
        }
        return 0L;
    }

    private void writePacket(AVPacket pkt, AVRational inputTimebase, AVRational outputTimebase, int codecType) {
        if (this.outputFormatContext == null || !this.isRunning.get()) {
            logger.error("OutputFormatContext is not initialized correctly for {}", (Object)this.file.getName());
            return;
        }
        long pts = pkt.pts();
        long dts = pkt.dts();
        long duration = pkt.duration();
        long pos = pkt.pos();
        this.totalSize += (long)pkt.size();
        this.partialTotalSize += (long)pkt.size();
        this.currentTime = avutil.av_rescale_q((long)dts, (AVRational)inputTimebase, (AVRational)this.avRationalTimeBase);
        if (this.startTime == 0L) {
            this.startTime = this.currentTime;
            this.bitrateReferenceTime = this.currentTime;
        }
        if (this.currentTime - this.bitrateReferenceTime >= 1L) {
            this.bitrate = this.partialTotalSize * 8L;
            this.partialTotalSize = 0L;
            this.bitrateReferenceTime = this.currentTime;
        }
        pkt.pts(avutil.av_rescale_q_rnd((long)pkt.pts(), (AVRational)inputTimebase, (AVRational)outputTimebase, (int)8197));
        pkt.dts(avutil.av_rescale_q_rnd((long)pkt.dts(), (AVRational)inputTimebase, (AVRational)outputTimebase, (int)8197));
        pkt.duration(avutil.av_rescale_q((long)pkt.duration(), (AVRational)inputTimebase, (AVRational)outputTimebase));
        pkt.pos(-1L);
        if (codecType == 0) {
            int ret = avcodec.av_packet_ref((AVPacket)this.tmpPacket, (AVPacket)pkt);
            if (ret < 0) {
                logger.error("Cannot copy packet for {}", (Object)this.file.getName());
                return;
            }
            if (this.bsfContext != null) {
                ret = avcodec.av_bsf_send_packet((AVBSFContext)this.bsfContext, (AVPacket)this.tmpPacket);
                if (ret < 0) {
                    return;
                }
                while (avcodec.av_bsf_receive_packet((AVBSFContext)this.bsfContext, (AVPacket)this.tmpPacket) == 0) {
                    ret = avformat.av_write_frame((AVFormatContext)this.outputFormatContext, (AVPacket)this.tmpPacket);
                    if (ret >= 0 || !logger.isInfoEnabled()) continue;
                    byte[] data = new byte[64];
                    avutil.av_strerror((int)ret, (byte[])data, (long)data.length);
                    logger.info("cannot write video frame to muxer. Error: {} stream: {}", (Object)new String(data, 0, data.length), (Object)this.file.getName());
                }
            } else {
                ret = avformat.av_write_frame((AVFormatContext)this.outputFormatContext, (AVPacket)this.tmpPacket);
                if (ret < 0 && logger.isInfoEnabled()) {
                    byte[] data = new byte[64];
                    avutil.av_strerror((int)ret, (byte[])data, (long)data.length);
                    logger.info("cannot write video frame to muxer. Error: {} stream: {}", (Object)new String(data, 0, data.length), (Object)this.file.getName());
                }
            }
            avcodec.av_packet_unref((AVPacket)this.tmpPacket);
        } else {
            int ret = avformat.av_write_frame((AVFormatContext)this.outputFormatContext, (AVPacket)pkt);
            if (ret < 0 && logger.isInfoEnabled()) {
                byte[] data = new byte[64];
                avutil.av_strerror((int)ret, (byte[])data, (long)data.length);
                logger.info("cannot write frame(not video) to muxer. Error is {} stream: {}", (Object)new String(data, 0, data.length), (Object)this.file.getName());
            }
        }
        pkt.pts(pts);
        pkt.dts(dts);
        pkt.duration(duration);
        pkt.pos(pos);
    }

    @Override
    public synchronized void writeTrailer() {
        if (!this.isRunning.get() || this.outputFormatContext == null) {
            logger.warn("HLSMuxer trailer is returning because it's not correct state. Isrunning: {}, outputformatContext: {}", (Object)this.isRunning.get(), (Object)this.outputFormatContext);
            return;
        }
        this.isRunning.set(false);
        if (this.avRationalTimeBase != null) {
            this.avRationalTimeBase.close();
            this.avRationalTimeBase = null;
        }
        if (this.bsfContext != null) {
            avcodec.av_bsf_free((AVBSFContext)this.bsfContext);
            this.bsfContext = null;
        }
        if (this.tmpPacket != null) {
            avcodec.av_packet_free((AVPacket)this.tmpPacket);
            this.tmpPacket = null;
        }
        if (this.videoPkt != null) {
            avcodec.av_packet_free((AVPacket)this.videoPkt);
            this.videoPkt = null;
        }
        if (this.audioPkt != null) {
            avcodec.av_packet_free((AVPacket)this.audioPkt);
            this.audioPkt = null;
        }
        avformat.av_write_trailer((AVFormatContext)this.outputFormatContext);
        if ((this.outputFormatContext.oformat().flags() & 1) == 0) {
            avformat.avio_closep((AVIOContext)this.outputFormatContext.pb());
        }
        avformat.avformat_free_context((AVFormatContext)this.outputFormatContext);
        this.outputFormatContext = null;
        logger.info("Delete File onexit:{} upload to S3:{} stream:{} hls time:{} hlslist size:{} ", new Object[]{this.deleteFileOnExit, this.uploadHLSToS3, this.streamId, this.hlsTime, this.hlsListSize});
        this.vertx.setTimer((long)(Integer.parseInt(this.hlsTime) * Integer.parseInt(this.hlsListSize) * 1000), l -> {
            String filenameWithoutExtension = this.file.getName().substring(0, this.file.getName().lastIndexOf(this.extension));
            File[] files = this.file.getParentFile().listFiles((dir, name) -> name.contains(filenameWithoutExtension) && name.endsWith(".ts"));
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    try {
                        if (!files[i].exists()) continue;
                        if (this.uploadHLSToS3) {
                            this.storageClient.save(this.s3StreamsFolderPath + File.separator + (String)(this.subFolder != null ? this.subFolder + File.separator : "") + files[i].getName(), files[i], false);
                        }
                        if (!this.deleteFileOnExit) continue;
                        Files.delete(files[i].toPath());
                        continue;
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage());
                    }
                }
            }
            if (this.file.exists()) {
                try {
                    if (this.uploadHLSToS3) {
                        this.storageClient.save(this.s3StreamsFolderPath + File.separator + (String)(this.subFolder != null ? this.subFolder + File.separator : "") + this.file.getName(), this.file, false);
                    }
                    if (this.deleteFileOnExit) {
                        Files.delete(this.file.toPath());
                    }
                }
                catch (IOException e) {
                    logger.error(e.getMessage());
                }
            }
        });
        this.isRecording = false;
    }

    @Override
    public synchronized void writePacket(AVPacket pkt, AVCodecContext codecContext) {
        if (!this.isRunning.get() || !this.registeredStreamIndexList.contains(pkt.stream_index())) {
            if (this.time2log % 100 == 0) {
                logger.warn("not registered stream index {}", (Object)this.file.getName());
                ++this.time2log;
            }
            ++this.time2log;
            return;
        }
        AVStream outStream = this.outputFormatContext.streams(pkt.stream_index());
        AVRational codecTimebase = this.codecTimeBaseMap.get(pkt.stream_index());
        this.writePacket(pkt, codecTimebase, outStream.time_base(), outStream.codecpar().codec_type());
    }

    @Override
    public boolean addVideoStream(int width, int height, AVRational videoTimebase, int codecId, int streamIndex, boolean isAVC, AVCodecParameters codecpar) {
        boolean result = false;
        AVFormatContext outputContext = this.getOutputFormatContext();
        if (outputContext != null && this.isCodecSupported(codecId)) {
            this.registeredStreamIndexList.add(streamIndex);
            this.videoIndex = streamIndex;
            AVStream outStream = avformat.avformat_new_stream((AVFormatContext)outputContext, null);
            outStream.codecpar().width(width);
            outStream.codecpar().height(height);
            outStream.codecpar().codec_id(codecId);
            outStream.codecpar().codec_type(0);
            outStream.codecpar().format(0);
            outStream.codecpar().codec_tag(0);
            AVRational timeBase = new AVRational();
            timeBase.num(1).den(1000);
            this.codecTimeBaseMap.put(streamIndex, timeBase);
            this.videoWidth = width;
            this.videoHeight = height;
            result = true;
        }
        return result;
    }

    @Override
    public synchronized boolean addStream(AVCodec codec, AVCodecContext codecContext, int streamIndex) {
        AVFormatContext context = this.getOutputFormatContext();
        if (context == null) {
            return false;
        }
        if (this.isCodecSupported(codecContext.codec_id())) {
            this.registeredStreamIndexList.add(streamIndex);
            AVStream outStream = avformat.avformat_new_stream((AVFormatContext)context, (AVCodec)codec);
            outStream.index(streamIndex);
            if (codecContext.codec_type() == 0) {
                this.videoWidth = codecContext.width();
                this.videoHeight = codecContext.height();
                avcodec.avcodec_parameters_from_context((AVCodecParameters)outStream.codecpar(), (AVCodecContext)codecContext);
                outStream.time_base(codecContext.time_base());
                this.codecTimeBaseMap.put(streamIndex, codecContext.time_base());
            } else {
                int ret = avcodec.avcodec_parameters_from_context((AVCodecParameters)outStream.codecpar(), (AVCodecContext)codecContext);
                this.codecTimeBaseMap.put(streamIndex, codecContext.time_base());
                logger.info("copy codec parameter from context {} stream index: {}", (Object)ret, (Object)streamIndex);
                if (codecContext.codec_type() != 1) {
                    logger.warn("This should be audio codec for {}", (Object)this.file.getName());
                }
                outStream.time_base(codecContext.time_base());
                this.codecTimeBaseMap.put(streamIndex, codecContext.time_base());
            }
            outStream.codecpar().codec_tag(0);
            if ((context.oformat().flags() & 0x40) != 0) {
                codecContext.flags(codecContext.flags() | 0x400000);
            }
        }
        return true;
    }

    @Override
    public boolean addStream(AVCodecParameters codecParameters, AVRational timebase, int streamIndex) {
        boolean result = false;
        AVFormatContext outputContext = this.getOutputFormatContext();
        if (outputContext != null && this.isCodecSupported(codecParameters.codec_id())) {
            AVStream outStream = avformat.avformat_new_stream((AVFormatContext)outputContext, null);
            if (codecParameters.codec_type() == 0) {
                this.videoIndex = outStream.index();
                AVBitStreamFilter h264bsfc = avcodec.av_bsf_get_by_name((String)"h264_mp4toannexb");
                this.bsfContext = new AVBSFContext(null);
                int ret = avcodec.av_bsf_alloc((AVBitStreamFilter)h264bsfc, (AVBSFContext)this.bsfContext);
                if (ret < 0) {
                    logger.info("cannot allocate bsf context for {}", (Object)this.file.getName());
                    return false;
                }
                ret = avcodec.avcodec_parameters_copy((AVCodecParameters)this.bsfContext.par_in(), (AVCodecParameters)codecParameters);
                if (ret < 0) {
                    logger.info("cannot copy input codec parameters for {}", (Object)this.file.getName());
                    return false;
                }
                this.bsfContext.time_base_in(timebase);
                ret = avcodec.av_bsf_init((AVBSFContext)this.bsfContext);
                if (ret < 0) {
                    logger.info("cannot init bit stream filter context for {}", (Object)this.file.getName());
                    return false;
                }
                ret = avcodec.avcodec_parameters_copy((AVCodecParameters)outStream.codecpar(), (AVCodecParameters)this.bsfContext.par_out());
                if (ret < 0) {
                    logger.info("cannot copy codec parameters to output for {}", (Object)this.file.getName());
                    return false;
                }
                this.videoWidth = outStream.codecpar().width();
                this.videoHeight = outStream.codecpar().height();
                outStream.time_base(this.bsfContext.time_base_out());
                outStream.codecpar().codec_tag(0);
            } else {
                this.audioIndex = outStream.index();
                int ret = avcodec.avcodec_parameters_copy((AVCodecParameters)outStream.codecpar(), (AVCodecParameters)codecParameters);
                if (ret < 0) {
                    logger.info("Cannot get codec parameters for {}", (Object)this.file.getName());
                    return false;
                }
                if (codecParameters.codec_type() != 1) {
                    logger.warn("codec type should be audio but it is {}", (Object)codecParameters.codec_type());
                }
                outStream.codecpar().codec_tag(0);
            }
            outStream.time_base(timebase);
            this.codecTimeBaseMap.put(outStream.index(), timebase);
            this.registeredStreamIndexList.add(streamIndex);
            result = true;
        }
        return result;
    }

    @Override
    public synchronized boolean prepareIO() {
        AVFormatContext context = this.getOutputFormatContext();
        if (this.isRunning.get()) {
            return false;
        }
        int ret = 0;
        if ((context.oformat().flags() & 1) == 0) {
            AVIOContext pb = new AVIOContext(null);
            ret = avformat.avio_open((AVIOContext)pb, (String)this.file.getAbsolutePath(), (int)2);
            if (ret < 0) {
                logger.warn("Could not open output file: {} ", (Object)this.file.getAbsolutePath());
                return false;
            }
            context.pb(pb);
        }
        AVDictionary optionsDictionary = null;
        if (!this.options.isEmpty()) {
            optionsDictionary = new AVDictionary();
            Set keySet = this.options.keySet();
            for (String key : keySet) {
                avutil.av_dict_set((AVDictionary)optionsDictionary, (String)key, (String)((String)this.options.get(key)), (int)0);
            }
        }
        if ((ret = avformat.avformat_write_header((AVFormatContext)context, optionsDictionary)) < 0 && logger.isWarnEnabled()) {
            byte[] data = new byte[1024];
            avutil.av_strerror((int)ret, (byte[])data, (long)data.length);
            logger.warn("could not write header. File: {} Error: {}", (Object)this.file.getAbsolutePath(), (Object)new String(data, 0, data.length));
            return false;
        }
        if (optionsDictionary != null) {
            avutil.av_dict_free((AVDictionary)optionsDictionary);
        }
        this.isRunning.set(true);
        return true;
    }

    @Override
    public synchronized void writePacket(AVPacket avpacket, AVStream inStream) {
        int streamIndex;
        if (!this.isRunning.get() || !this.registeredStreamIndexList.contains(avpacket.stream_index())) {
            if (this.time2log % 100 == 0) {
                logger.warn("not registered stream index {}", (Object)this.file.getName());
                this.time2log = 0;
            }
            ++this.time2log;
            return;
        }
        if (inStream.codecpar().codec_type() == 0) {
            streamIndex = this.videoIndex;
        } else if (inStream.codecpar().codec_type() == 1) {
            streamIndex = this.audioIndex;
        } else {
            logger.error("Undefined codec type for {} stream index: {}", (Object)this.file.getName(), (Object)inStream.index());
            return;
        }
        AVStream outStream = this.getOutputFormatContext().streams(streamIndex);
        int index = avpacket.stream_index();
        avpacket.stream_index(streamIndex);
        this.writePacket(avpacket, inStream.time_base(), outStream.time_base(), outStream.codecpar().codec_type());
        avpacket.stream_index(index);
    }

    @Override
    public void writeAudioBuffer(ByteBuffer audioFrame, int streamIndex, long timestamp) {
        if (!this.isRunning.get()) {
            if (this.time2log % 100 == 0) {
                logger.warn("Not writing AudioBuffer for {} because Is running:{}", (Object)this.file.getName(), (Object)this.isRunning.get());
                this.time2log = 0;
            }
            ++this.time2log;
            return;
        }
        this.audioPkt.stream_index(streamIndex);
        this.audioPkt.pts(timestamp);
        this.audioPkt.dts(timestamp);
        audioFrame.rewind();
        this.audioPkt.flags(this.audioPkt.flags() | 1);
        this.audioPkt.data(new BytePointer(audioFrame));
        this.audioPkt.size(audioFrame.limit());
        this.audioPkt.position(0L);
        this.writePacket(this.audioPkt, (AVCodecContext)null);
        avcodec.av_packet_unref((AVPacket)this.audioPkt);
    }

    @Override
    public void writeVideoBuffer(ByteBuffer encodedVideoFrame, long dts, int frameRotation, int streamIndex, boolean isKeyFrame, long firstFrameTimeStamp, long pts) {
        if (!this.isRunning.get()) {
            if (this.time2log % 100 == 0) {
                logger.warn("Not writing to VideoBuffer for {} because Is running:{}", (Object)this.file.getName(), (Object)this.isRunning.get());
                this.time2log = 0;
            }
            ++this.time2log;
            return;
        }
        this.videoPkt.stream_index(streamIndex);
        this.videoPkt.pts(pts);
        this.videoPkt.dts(dts);
        encodedVideoFrame.rewind();
        if (isKeyFrame) {
            this.videoPkt.flags(this.videoPkt.flags() | 1);
        }
        BytePointer bytePointer = new BytePointer(encodedVideoFrame);
        this.videoPkt.data(bytePointer);
        this.videoPkt.size(encodedVideoFrame.limit());
        this.videoPkt.position(0L);
        this.writePacket(this.videoPkt, (AVCodecContext)null);
        avcodec.av_packet_unref((AVPacket)this.videoPkt);
    }

    public int getVideoWidth() {
        return this.videoWidth;
    }

    public int getVideoHeight() {
        return this.videoHeight;
    }

    public String getHlsListSize() {
        return this.hlsListSize;
    }

    public void setHlsListSize(String hlsListSize) {
        this.hlsListSize = hlsListSize;
    }

    public String getHlsTime() {
        return this.hlsTime;
    }

    public void setHlsTime(String hlsTime) {
        this.hlsTime = hlsTime;
    }

    public String getHlsPlayListType() {
        return this.hlsPlayListType;
    }

    public void setHlsPlayListType(String hlsPlayListType) {
        this.hlsPlayListType = hlsPlayListType;
    }

    public boolean isDeleteFileOnExit() {
        return this.deleteFileOnExit;
    }

    public void setDeleteFileOnExit(boolean deleteFileOnExist) {
        this.deleteFileOnExit = deleteFileOnExist;
    }

    public boolean isUploadingToS3() {
        return this.uploadHLSToS3;
    }

    public String getSegmentFilename() {
        return this.segmentFilename;
    }
}

