/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.ipcamera.onvifdiscovery;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProbeReceiverThread
extends Thread {
    private final Collection<String> addresses;
    private final CountDownLatch serverStarted;
    private final DatagramSocket socket;
    private final CountDownLatch serverFinished;

    public ProbeReceiverThread(Collection<String> addresses, CountDownLatch serverStarted, DatagramSocket socket, CountDownLatch serverFinished) {
        this.addresses = addresses;
        this.serverStarted = serverStarted;
        this.socket = socket;
        this.serverFinished = serverFinished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            DatagramPacket packet = new DatagramPacket(new byte[4096], 4096);
            this.socket.setSoTimeout(4000);
            long timerStarted = System.currentTimeMillis();
            while (System.currentTimeMillis() - timerStarted < 4000L) {
                this.serverStarted.countDown();
                this.socket.receive(packet);
                Collection<String> collection = ProbeReceiverThread.parseSoapResponseForUrls(Arrays.copyOf(packet.getData(), packet.getLength()));
                for (String key : collection) {
                    this.addresses.add(key);
                }
            }
        }
        catch (SocketException | SocketTimeoutException packet) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.serverFinished.countDown();
            this.socket.close();
        }
    }

    private static Collection<Node> getNodeMatching(Node body, String regexp) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        if (body.getNodeName().matches(regexp)) {
            nodes.add(body);
        }
        if (body.getChildNodes().getLength() == 0) {
            return nodes;
        }
        NodeList returnList = body.getChildNodes();
        for (int k = 0; k < returnList.getLength(); ++k) {
            Node node = returnList.item(k);
            nodes.addAll(ProbeReceiverThread.getNodeMatching(node, regexp));
        }
        return nodes;
    }

    private static Collection<String> parseSoapResponseForUrls(byte[] data) throws SOAPException, IOException {
        ArrayList<String> urls = new ArrayList<String>();
        MessageFactory factory = MessageFactory.newInstance((String)"SOAP 1.2 Protocol");
        MimeHeaders headers = new MimeHeaders();
        headers.addHeader("Content-type", "application/soap+xml");
        SOAPMessage message = factory.createMessage(headers, (InputStream)new ByteArrayInputStream(data));
        SOAPBody body = message.getSOAPBody();
        for (Node node : ProbeReceiverThread.getNodeMatching((Node)body, ".*:XAddrs")) {
            if (node.getTextContent().length() <= 0) continue;
            urls.addAll(Arrays.asList(node.getTextContent().split(" ")));
        }
        return urls;
    }
}

