/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.ipcamera.onvifdiscovery;

import io.antmedia.ipcamera.onvifdiscovery.ProbeReceiverThread;
import io.antmedia.ipcamera.onvifdiscovery.ProbeSenderThread;
import io.antmedia.ipcamera.onvifdiscovery.URLComparator;
import java.io.File;
import java.io.IOException;
import java.net.BindException;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceDiscovery {
    protected static Logger logger = LoggerFactory.getLogger(DeviceDiscovery.class);
    public static final String WS_DISCOVERY_SOAP_VERSION = "SOAP 1.2 Protocol";
    public static final String WS_DISCOVERY_CONTENT_TYPE = "application/soap+xml";
    public static final int WS_DISCOVERY_TIMEOUT = 4000;
    public static final int WS_DISCOVERY_PORT = 3702;

    private DeviceDiscovery() {
    }

    public static Collection<URL> discoverWsDevicesAsUrls(boolean useIpv4) {
        return DeviceDiscovery.discoverWsDevicesAsUrls("", "", useIpv4);
    }

    public static Collection<URL> discoverWsDevicesAsUrls(String regexpProtocol, String regexpPath, boolean useIpv4, List<String> targetAddresses) {
        String probeMsgTemplate;
        try {
            File probeMsgFile = new File(Thread.currentThread().getContextClassLoader().getResource("probe-template.xml").toURI());
            probeMsgTemplate = FileUtils.readFileToString((File)probeMsgFile, (String)"UTF-8");
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
        TreeSet<URL> urls = new TreeSet<URL>(new URLComparator());
        for (String key : DeviceDiscovery.discoverWsDevices(probeMsgTemplate, useIpv4, targetAddresses)) {
            try {
                URL url = new URL(key);
                boolean ok = true;
                if (!regexpProtocol.isEmpty() && !url.getProtocol().matches(regexpProtocol)) {
                    ok = false;
                }
                if (!regexpPath.isEmpty() && !url.getPath().matches(regexpPath)) {
                    ok = false;
                }
                if (!ok) continue;
                urls.add(url);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return urls;
    }

    public static Collection<URL> discoverWsDevicesAsUrls(String regexpProtocol, String regexpPath, boolean useIpv4) {
        return DeviceDiscovery.discoverWsDevicesAsUrls(regexpProtocol, regexpPath, useIpv4);
    }

    /*
     * Unable to fully structure code
     */
    public static Collection<String> discoverWsDevices(String probeMsgTemplate, boolean useIpv4, List<String> targetAddresses) {
        addresses = new ConcurrentSkipListSet<String>();
        serverStarted = new CountDownLatch(1);
        serverFinished = new CountDownLatch(1);
        addressList = new ArrayList<InetAddress>();
        if (targetAddresses != null && !targetAddresses.isEmpty()) {
            for (String addressStr : targetAddresses) {
                try {
                    addr = InetAddress.getByName(addressStr);
                    addressList.add(addr);
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
            }
        } else {
            try {
                interfaces = NetworkInterface.getNetworkInterfaces();
                if (interfaces == null) ** GOTO lbl32
                while (interfaces.hasMoreElements()) {
                    anInterface = interfaces.nextElement();
                    interfaceAddresses = anInterface.getInterfaceAddresses();
                    var10_14 = interfaceAddresses.iterator();
                    while (var10_14.hasNext()) {
                        address = (InterfaceAddress)var10_14.next();
                        addressList.add(address.getAddress());
                    }
                }
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
        }
lbl32:
        // 4 sources

        executorService = Executors.newCachedThreadPool();
        port = 50454;
        for (InetAddress address : addressList) {
            if (useIpv4 && address instanceof Inet6Address || !useIpv4 && address instanceof Inet4Address) continue;
            result = 0;
            while ((result = DeviceDiscovery.tryAddress(probeMsgTemplate, addresses, serverStarted, serverFinished, executorService, ++port, address)) == -1) {
            }
        }
        try {
            executorService.shutdown();
            executorService.awaitTermination(6000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
        return addresses;
    }

    public static int tryAddress(String probeMsgTemplate, Collection<String> addresses, CountDownLatch serverStarted, CountDownLatch serverFinished, ExecutorService executorService, int port, InetAddress address) {
        try {
            DatagramSocket socket = new DatagramSocket(port);
            ProbeReceiverThread probeReceiver = new ProbeReceiverThread(addresses, serverStarted, socket, serverFinished);
            ProbeSenderThread probeSender = new ProbeSenderThread(address, socket, probeMsgTemplate, serverStarted, serverFinished, probeReceiver);
            executorService.submit(probeSender);
        }
        catch (BindException e) {
            logger.error("Port:{} is in use. Trying new one", (Object)port);
            return -1;
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return port;
    }
}

