/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.filter;

import io.antmedia.AppSettings;
import io.antmedia.filter.AbstractFilter;
import io.antmedia.filter.TokenGenerator;
import io.antmedia.security.ITokenService;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.ConfigurableWebApplicationContext;

public class TokenFilterManager
extends AbstractFilter {
    private static final String REPLACE_CHARS_REGEX = "[\n|\r|\t]";
    private static final String NOT_INITIALIZED = "Not initialized";
    protected static Logger logger = LoggerFactory.getLogger(TokenFilterManager.class);
    private ITokenService tokenService;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String method = httpRequest.getMethod();
        String tokenId = ((HttpServletRequest)request).getParameter("token");
        String subscriberId = ((HttpServletRequest)request).getParameter("subscriberId");
        String subscriberCodeText = ((HttpServletRequest)request).getParameter("subscriberCode");
        if (tokenId != null) {
            tokenId = tokenId.replaceAll(REPLACE_CHARS_REGEX, "_");
        }
        if (subscriberId != null) {
            subscriberId = subscriberId.replaceAll(REPLACE_CHARS_REGEX, "_");
        }
        if (subscriberCodeText != null) {
            subscriberCodeText = subscriberCodeText.replaceAll(REPLACE_CHARS_REGEX, "_");
        }
        String sessionId = httpRequest.getSession().getId();
        String streamId = TokenFilterManager.getStreamId(httpRequest.getRequestURI());
        String clientIP = httpRequest.getRemoteAddr().replaceAll(REPLACE_CHARS_REGEX, "_");
        AppSettings appSettings = this.getAppSettings();
        TokenGenerator tokenGenerator = this.getTokenGenerator();
        if (appSettings == null) {
            httpResponse.sendError(403, "Server is getting initialized.");
            logger.warn("AppSettings not initialized. Server is getting started for stream id:{} from request: {}", (Object)streamId, (Object)clientIP);
            return;
        }
        logger.debug("Client IP: {}, request url:  {}, token:  {}, sessionId: {},streamId:  {} ", new Object[]{clientIP, httpRequest.getRequestURI(), tokenId, sessionId, streamId});
        String clusterToken = (String)request.getAttribute("ClusterToken");
        if ("GET".equals(method) || "HEAD".equals(method)) {
            if (tokenGenerator == null || clusterToken == null || clusterToken.equals(tokenGenerator.getGenetaredToken())) {
                ITokenService tokenServiceTmp;
                if ((appSettings.isTimeTokenSubscriberOnly() || appSettings.isEnableTimeTokenForPlay() || appSettings.isEnableTimeTokenForPublish()) && !(tokenServiceTmp = this.getTokenService()).checkTimeBasedSubscriber(subscriberId, streamId, sessionId, subscriberCodeText, false)) {
                    httpResponse.sendError(403, "Time Based subscriber id or code is invalid");
                    logger.warn("subscriber request for subscriberIDor subscriberCode is not valid");
                    return;
                }
                if (appSettings.isPlayTokenControlEnabled()) {
                    tokenServiceTmp = this.getTokenService();
                    if (tokenServiceTmp != null) {
                        if (!tokenServiceTmp.checkToken(tokenId, streamId, sessionId, "play")) {
                            httpResponse.sendError(403, "Invalid Token");
                            logger.warn("token {} is not valid", (Object)tokenId);
                            return;
                        }
                    } else {
                        httpResponse.sendError(403, NOT_INITIALIZED);
                        logger.warn("Token service is not initialized. Server is getting started for stream id:{} from request: {}", (Object)streamId, (Object)clientIP);
                        return;
                    }
                }
                if (appSettings.isHashControlPlayEnabled()) {
                    tokenServiceTmp = this.getTokenService();
                    if (tokenServiceTmp != null) {
                        if (!tokenServiceTmp.checkHash(tokenId, streamId, sessionId, "play")) {
                            httpResponse.sendError(403, "Invalid Hash");
                            logger.warn("hash {} is not valid", (Object)tokenId);
                            return;
                        }
                    } else {
                        httpResponse.sendError(403, NOT_INITIALIZED);
                        logger.warn("Token service is not initialized. Server is getting started for stream id:{} from request: {}", (Object)streamId, (Object)clientIP);
                        return;
                    }
                }
                if (appSettings.isPlayJwtControlEnabled()) {
                    tokenServiceTmp = this.getTokenService();
                    if (tokenServiceTmp != null) {
                        if (!tokenServiceTmp.checkJwtToken(tokenId, streamId, "play")) {
                            httpResponse.sendError(403, "Invalid JWT Token");
                            logger.warn("JWT token is not valid");
                            return;
                        }
                    } else {
                        httpResponse.sendError(403, NOT_INITIALIZED);
                        logger.warn("JWT Token service is not initialized. Server is getting started for stream id:{} from request: {}", (Object)streamId, (Object)clientIP);
                        return;
                    }
                }
            }
            chain.doFilter(request, response);
        } else {
            httpResponse.sendError(403, "Invalid Request Type");
            logger.warn("Invalid method type({}) for stream: {} and request uri: {}", new Object[]{method, streamId, httpRequest.getRequestURI()});
        }
    }

    private TokenGenerator getTokenGenerator() {
        TokenGenerator tokenGenerator = null;
        ConfigurableWebApplicationContext context = this.getAppContext();
        if (context != null && context.containsBean("tokenGenerator")) {
            tokenGenerator = (TokenGenerator)context.getBean("tokenGenerator");
        }
        return tokenGenerator;
    }

    public ITokenService getTokenService() {
        ConfigurableWebApplicationContext context;
        if (this.tokenService == null && (context = this.getAppContext()) != null) {
            this.tokenService = (ITokenService)context.getBean(ITokenService.BeanName.TOKEN_SERVICE.toString());
        }
        return this.tokenService;
    }

    public void setTokenService(ITokenService tokenService) {
        this.tokenService = tokenService;
    }

    public static String getStreamId(String requestURI) {
        requestURI = requestURI.replaceAll(REPLACE_CHARS_REGEX, "_");
        int startIndex = requestURI.indexOf(47);
        if (requestURI.contains("streams")) {
            requestURI = requestURI.split("streams")[1];
        } else if (requestURI.contains("chunked")) {
            requestURI = requestURI.split("chunked")[1];
            startIndex = requestURI.indexOf("/");
            int endIndex = requestURI.lastIndexOf("/");
            return requestURI.substring(startIndex + 1, endIndex);
        }
        int endIndex = requestURI.lastIndexOf("_adaptive.m3u8");
        if (endIndex != -1) {
            return requestURI.substring(startIndex + 1, endIndex);
        }
        String hlsRegex = "(.*)_[0-9]+p[0-9]+kbps.m3u8$";
        if (requestURI.matches(hlsRegex)) {
            endIndex = requestURI.lastIndexOf(95);
            return requestURI.substring(startIndex + 1, endIndex);
        }
        endIndex = requestURI.lastIndexOf(".m3u8");
        if (endIndex != -1) {
            return requestURI.substring(startIndex + 1, endIndex);
        }
        String tsRegex = "(.*)_[0-9]+p[0-9]+kbps+[0-9][0-9][0-9][0-9].ts$";
        if (requestURI.matches(tsRegex)) {
            endIndex = requestURI.lastIndexOf(95);
            return requestURI.substring(startIndex + 1, endIndex);
        }
        tsRegex = "(.*)_[0-9][0-9][0-9][0-9].ts$";
        if (requestURI.matches(tsRegex)) {
            endIndex = requestURI.lastIndexOf(95);
            return requestURI.substring(startIndex + 1, endIndex);
        }
        String mp4Regex1 = "(.*)+(-20)[0-9][0-9]+(-)+([0-9][0-9])+(.*).mp4$";
        if (requestURI.matches(mp4Regex1)) {
            endIndex = requestURI.lastIndexOf(95);
            String mp4resolutionRegex = "(.*)+_[0-9]+p+(.*)";
            if (requestURI.matches(mp4resolutionRegex)) {
                endIndex = requestURI.substring(startIndex, endIndex).lastIndexOf(46);
                endIndex -= "yyyy-MM-dd_HH-mm-ss.SSS".length() - 3;
            } else {
                endIndex -= "yyyy-MM-dd_HH-mm-ss.SSS".length() - 12;
            }
            return requestURI.substring(startIndex + 1, endIndex);
        }
        String mp4Regex2 = "(.*)+(_[0-9]+p+_[0-9]|_|_[0-9])+.mp4$";
        if (requestURI.matches(mp4Regex2)) {
            endIndex = requestURI.lastIndexOf(95);
            String mp4resolutionRegex = "(.*)+_[0-9]+p[0-9]+kbps$";
            if (requestURI.substring(startIndex + 1, endIndex).matches(mp4resolutionRegex)) {
                endIndex = requestURI.substring(startIndex, endIndex).lastIndexOf(95);
            }
            return requestURI.substring(startIndex + 1, endIndex);
        }
        endIndex = requestURI.lastIndexOf(".mp4");
        if (endIndex != -1) {
            return requestURI.substring(startIndex + 1, endIndex);
        }
        return null;
    }
}

