/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.filter;

import io.antmedia.AppSettings;
import io.antmedia.filter.AbstractFilter;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPFilter
extends AbstractFilter {
    protected static Logger log = LoggerFactory.getLogger(IPFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.isAllowed(request.getRemoteAddr())) {
            chain.doFilter(request, response);
            return;
        }
        if (((HttpServletRequest)request).getRequestURL().toString().contains("rest/v2/acm")) {
            chain.doFilter(request, response);
            return;
        }
        ((HttpServletResponse)response).sendError(403, "Not allowed IP");
    }

    public boolean isAllowed(String remoteIPAdrress) {
        AppSettings appSettings = this.getAppSettings();
        boolean result = false;
        if (appSettings != null) {
            result = appSettings.isIpFilterEnabled() ? this.checkCIDRList(appSettings.getAllowedCIDRList(), remoteIPAdrress) : true;
        }
        return result;
    }
}

