/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.console.rest;

import io.antmedia.console.datastore.AbstractConsoleDataStore;
import io.antmedia.console.datastore.ConsoleDataStoreFactory;
import io.antmedia.console.rest.CommonRestService;
import io.antmedia.filter.AbstractFilter;
import io.antmedia.rest.model.User;
import io.antmedia.rest.model.UserType;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.context.ConfigurableWebApplicationContext;

public class AuthenticationFilter
extends AbstractFilter {
    private AbstractConsoleDataStore getDataStore() {
        Object dataStoreFactory;
        AbstractConsoleDataStore dataStore = null;
        ConfigurableWebApplicationContext appContext = this.getWebApplicationContext();
        if (appContext != null && appContext.isRunning() && (dataStoreFactory = appContext.getBean("dataStoreFactory")) instanceof ConsoleDataStoreFactory) {
            AbstractConsoleDataStore dataStoreTemp = ((ConsoleDataStoreFactory)dataStoreFactory).getDataStore();
            if (dataStoreTemp.isAvailable()) {
                dataStore = dataStoreTemp;
            } else {
                logger.warn("DataStore is not available. It may be closed or not initialized");
            }
        }
        return dataStore;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String path = ((HttpServletRequest)request).getRequestURI();
        if (path.equals("/rest/isAuthenticated") || path.equals("/rest/authenticateUser") || path.equals("/rest/addInitialUser") || path.equals("/rest/isFirstLogin") || path.equals("/rest/v2/authentication-status") || path.equals("/rest/v2/users/initial") || path.equals("/rest/v2/first-login-status") || path.equals("/rest/v2/users/authenticate") || path.startsWith("/rest/v2/users") && path.endsWith("blocked")) {
            chain.doFilter(request, response);
        } else if (CommonRestService.isAuthenticated(((HttpServletRequest)request).getSession())) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            String method = httpRequest.getMethod();
            if ("GET".equals(method)) {
                chain.doFilter(request, response);
            } else {
                AbstractConsoleDataStore store = this.getDataStore();
                if (store != null) {
                    String userEmail = (String)httpRequest.getSession().getAttribute("user.email");
                    User currentUser = store.getUser(userEmail);
                    if (currentUser != null && UserType.ADMIN.equals((Object)currentUser.getUserType())) {
                        chain.doFilter(request, response);
                    } else {
                        logger.warn("User is  null or not admin. User e-mail:{} and user type:{}", (Object)userEmail, (Object)(currentUser != null ? currentUser.getUserType() : null));
                        HttpServletResponse resp = (HttpServletResponse)response;
                        resp.setStatus(403);
                    }
                } else {
                    HttpServletResponse resp = (HttpServletResponse)response;
                    resp.setStatus(403);
                }
            }
        } else {
            HttpServletResponse resp = (HttpServletResponse)response;
            resp.setStatus(403);
        }
    }

    @Override
    public void destroy() {
    }
}

