/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia;

import io.antmedia.AppSettings;
import io.antmedia.EncoderSettings;
import io.antmedia.cluster.IClusterNotifier;
import io.antmedia.datastore.db.DataStore;
import io.antmedia.datastore.db.DataStoreFactory;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.datastore.db.types.Endpoint;
import io.antmedia.datastore.db.types.SocialEndpointCredentials;
import io.antmedia.datastore.db.types.VoD;
import io.antmedia.datastore.preference.PreferenceStore;
import io.antmedia.filter.StreamAcceptFilter;
import io.antmedia.ipcamera.OnvifCamera;
import io.antmedia.muxer.IAntMediaStreamHandler;
import io.antmedia.muxer.MuxAdaptor;
import io.antmedia.plugin.api.IFrameListener;
import io.antmedia.plugin.api.IPacketListener;
import io.antmedia.plugin.api.IStreamListener;
import io.antmedia.rest.RestServiceBase;
import io.antmedia.rest.model.Result;
import io.antmedia.security.AcceptOnlyStreamsInDataStore;
import io.antmedia.settings.ServerSettings;
import io.antmedia.shutdown.AMSShutdownManager;
import io.antmedia.shutdown.IShutdownListener;
import io.antmedia.social.endpoint.VideoServiceEndpoint;
import io.antmedia.statistic.HlsViewerStats;
import io.antmedia.statistic.type.RTMPToWebRTCStats;
import io.antmedia.statistic.type.WebRTCAudioReceiveStats;
import io.antmedia.statistic.type.WebRTCAudioSendStats;
import io.antmedia.statistic.type.WebRTCVideoReceiveStats;
import io.antmedia.statistic.type.WebRTCVideoSendStats;
import io.antmedia.storage.StorageClient;
import io.antmedia.streamsource.StreamFetcher;
import io.antmedia.streamsource.StreamFetcherManager;
import io.antmedia.webrtc.api.IWebRTCAdaptor;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.dropwizard.MetricsService;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.red5.server.adapter.MultiThreadedApplicationAdapter;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.stream.IBroadcastStream;
import org.red5.server.api.stream.IClientBroadcastStream;
import org.red5.server.api.stream.IPlayItem;
import org.red5.server.api.stream.IStreamCapableConnection;
import org.red5.server.api.stream.IStreamPublishSecurity;
import org.red5.server.api.stream.ISubscriberStream;
import org.red5.server.stream.ClientBroadcastStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AntMediaApplicationAdapter
extends MultiThreadedApplicationAdapter
implements IAntMediaStreamHandler,
IShutdownListener {
    public static final String BEAN_NAME = "web.handler";
    public static final int BROADCAST_STATS_RESET = 0;
    public static final String HOOK_ACTION_END_LIVE_STREAM = "liveStreamEnded";
    public static final String HOOK_ACTION_START_LIVE_STREAM = "liveStreamStarted";
    public static final String HOOK_ACTION_VOD_READY = "vodReady";
    public static final String DEFAULT_LOCALHOST = "127.0.0.1";
    protected static Logger logger = LoggerFactory.getLogger(AntMediaApplicationAdapter.class);
    private ServerSettings serverSettings;
    public static final String VOD = "VoD";
    public static final String LIVE_STREAM = "liveStream";
    public static final String IP_CAMERA = "ipCamera";
    public static final String STREAM_SOURCE = "streamSource";
    public static final String PLAY_LIST = "playlist";
    protected static final int END_POINT_LIMIT = 20;
    public static final String FACEBOOK = "facebook";
    public static final String YOUTUBE = "youtube";
    public static final String FACEBOOK_ENDPOINT_CLASS = "io.antmedia.enterprise.social.endpoint.FacebookEndpoint";
    public static final String YOUTUBE_ENDPOINT_CLASS = "io.antmedia.enterprise.social.endpoint.YoutubeEndpoint";
    public static final String WEBAPPS_PATH = "webapps/";
    private Map<String, VideoServiceEndpoint> videoServiceEndpoints = new HashMap<String, VideoServiceEndpoint>();
    private List<VideoServiceEndpoint> videoServiceEndpointsHavingError = new ArrayList<VideoServiceEndpoint>();
    private List<IStreamPublishSecurity> streamPublishSecurityList;
    private HashMap<String, OnvifCamera> onvifCameraList = new HashMap();
    protected StreamFetcherManager streamFetcherManager;
    protected List<MuxAdaptor> muxAdaptors;
    private DataStore dataStore;
    private DataStoreFactory dataStoreFactory;
    private StreamAcceptFilter streamAcceptFilter;
    private AppSettings appSettings;
    private Vertx vertx;
    protected List<String> encoderBlockedStreams = new ArrayList<String>();
    private int numberOfEncoderNotOpenedErrors = 0;
    protected int publishTimeoutStreams = 0;
    private List<String> publishTimeoutStreamsList = new ArrayList<String>();
    private boolean shutdownProperly = true;
    protected WebRTCVideoReceiveStats webRTCVideoReceiveStats = new WebRTCVideoReceiveStats();
    protected WebRTCAudioReceiveStats webRTCAudioReceiveStats = new WebRTCAudioReceiveStats();
    protected WebRTCVideoSendStats webRTCVideoSendStats = new WebRTCVideoSendStats();
    protected WebRTCAudioSendStats webRTCAudioSendStats = new WebRTCAudioSendStats();
    private IClusterNotifier clusterNotifier;
    protected boolean serverShuttingDown = false;
    protected StorageClient storageClient;
    protected ArrayList<IStreamListener> streamListeners = new ArrayList();

    @Override
    public boolean appStart(IScope app) {
        this.setScope(app);
        for (IStreamPublishSecurity streamPublishSecurity : this.getStreamPublishSecurityList()) {
            this.registerStreamPublishSecurity(streamPublishSecurity);
        }
        this.getVertx();
        this.getDataStore();
        Result result = this.createInitializationProcess(app.getName());
        this.storageClient = (StorageClient)app.getContext().getBean("app.storageClient");
        if (!result.isSuccess()) {
            this.shutdownProperly = false;
            this.resetBroadcasts();
        }
        if (app.getContext().hasBean("tomcat.cluster")) {
            this.clusterNotifier = (IClusterNotifier)app.getContext().getBean("tomcat.cluster");
            logger.info("Registering settings listener to the cluster notifier for app: {}", (Object)app.getName());
            this.clusterNotifier.registerSettingUpdateListener(this.getAppSettings().getAppName(), settings -> this.updateSettings(settings, false, false));
            AppSettings storedSettings = this.clusterNotifier.getClusterStore().getSettings(app.getName());
            boolean updateClusterSettings = false;
            if (storedSettings == null) {
                logger.warn("There is a stored settings for the app:{} and it's status to be deleted. Probably, application with the same name is deleted/created again", (Object)app.getName());
                storedSettings = this.appSettings;
                updateClusterSettings = true;
            } else if (storedSettings.isToBeDeleted() && System.currentTimeMillis() - storedSettings.getUpdateTime() > 60000L) {
                logger.info("App:{} exists in datastore and re-creating because latest update time is older than 60 seconds", (Object)app.getName());
                storedSettings = this.appSettings;
                updateClusterSettings = true;
            }
            logger.info("Updating settings while app({}) is being started. AppSettings will be saved to Cluster db? Answer -> {}", (Object)app.getName(), (Object)(updateClusterSettings ? "yes" : "no"));
            this.updateSettings(storedSettings, updateClusterSettings, false);
        }
        this.vertx.setTimer(10L, l -> {
            this.getStreamFetcherManager();
            if (this.appSettings.isStartStreamFetcherAutomatically()) {
                List<Broadcast> streams = this.getDataStore().getExternalStreamsList();
                logger.info("Stream source size: {}", (Object)streams.size());
                this.streamFetcherManager.startStreams(streams);
            }
            List<SocialEndpointCredentials> socialEndpoints = this.getDataStore().getSocialEndpoints(0, 20);
            logger.info("socialEndpoints size: {}", (Object)socialEndpoints.size());
            for (SocialEndpointCredentials socialEndpointCredentials : socialEndpoints) {
                VideoServiceEndpoint endPointService = null;
                if (socialEndpointCredentials.getServiceName().equals(FACEBOOK)) {
                    endPointService = this.getEndpointService(FACEBOOK_ENDPOINT_CLASS, socialEndpointCredentials, this.appSettings.getFacebookClientId(), this.appSettings.getFacebookClientSecret());
                } else if (socialEndpointCredentials.getServiceName().equals(YOUTUBE)) {
                    endPointService = this.getEndpointService(YOUTUBE_ENDPOINT_CLASS, socialEndpointCredentials, this.appSettings.getYoutubeClientId(), this.appSettings.getYoutubeClientSecret());
                }
                if (endPointService == null) continue;
                endPointService.setCollectInteractivity(this.appSettings.isCollectSocialMediaActivity());
                this.videoServiceEndpoints.put(endPointService.getCredentials().getId(), endPointService);
            }
            this.synchUserVoDFolder(null, this.appSettings.getVodFolder());
        });
        AMSShutdownManager.getInstance().subscribe(this);
        if (app.getContext().hasBean("webrtc.adaptor")) {
            IWebRTCAdaptor webRTCAdaptor = (IWebRTCAdaptor)app.getContext().getBean("webrtc.adaptor");
            webRTCAdaptor.setExcessiveBandwidthValue(this.appSettings.getExcessiveBandwidthValue());
            webRTCAdaptor.setExcessiveBandwidthCallThreshold(this.appSettings.getExcessiveBandwidthCallThreshold());
            webRTCAdaptor.setTryCountBeforeSwitchback(this.appSettings.getExcessiveBandwithTryCountBeforeSwitchback());
            webRTCAdaptor.setExcessiveBandwidthAlgorithmEnabled(this.appSettings.isExcessiveBandwidthAlgorithmEnabled());
            webRTCAdaptor.setPacketLossDiffThresholdForSwitchback(this.appSettings.getPacketLossDiffThresholdForSwitchback());
            webRTCAdaptor.setRttMeasurementDiffThresholdForSwitchback(this.appSettings.getRttMeasurementDiffThresholdForSwitchback());
        }
        this.storageClient.setStorageName(this.appSettings.getS3BucketName());
        this.storageClient.setRegion(this.appSettings.getS3RegionName());
        this.storageClient.setAccessKey(this.appSettings.getS3AccessKey());
        this.storageClient.setSecretKey(this.appSettings.getS3SecretKey());
        this.storageClient.setEnabled(this.appSettings.isS3RecordingEnabled());
        this.storageClient.setEndpoint(this.appSettings.getS3Endpoint());
        this.storageClient.setPermission(this.appSettings.getS3Permission());
        logger.info("{} started", (Object)app.getName());
        return true;
    }

    public Result resetBroadcasts() {
        logger.info("Resetting streams viewer numbers because there is an unexpected stop happened in app: {}", (Object)(this.getScope() != null ? this.getScope().getName() : "[scope is null]"));
        int operationCount = this.getDataStore().resetBroadcasts(this.getServerSettings().getHostAddress());
        logger.info("Resetting subscriber connection status");
        this.getDataStore().resetSubscribersConnectedStatus();
        Result result = new Result(true);
        result.setMessage("Successfull operations: " + operationCount);
        return result;
    }

    public boolean synchUserVoDFolder(String oldFolderPath, String vodFolderPath) {
        boolean result = false;
        File streamsFolder = new File(WEBAPPS_PATH + this.getScope().getName() + "/streams");
        try {
            this.deleteOldFolderPath(oldFolderPath, streamsFolder);
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        File f = new File(vodFolderPath == null ? "" : vodFolderPath);
        try {
            String newLinkPath;
            File newLinkFile;
            if (!streamsFolder.exists()) {
                streamsFolder.mkdir();
            }
            if (f.exists() && f.isDirectory() && !(newLinkFile = new File(newLinkPath = streamsFolder.getAbsolutePath() + "/" + f.getName())).exists()) {
                Path target = f.toPath();
                Files.createSymbolicLink(newLinkFile.toPath(), target, new FileAttribute[0]);
            }
            this.getDataStore().fetchUserVodList(f);
            result = true;
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        return result;
    }

    public boolean deleteOldFolderPath(String oldFolderPath, File streamsFolder) throws IOException {
        boolean result = false;
        if (oldFolderPath != null && !oldFolderPath.isEmpty() && streamsFolder != null) {
            File f = new File(oldFolderPath);
            File linkFile = new File(streamsFolder.getAbsolutePath(), f.getName());
            if (linkFile.exists() && linkFile.isDirectory()) {
                Files.delete(linkFile.toPath());
                result = true;
            }
        }
        return result;
    }

    public void closeBroadcast(String streamName) {
        try {
            logger.info("Closing broadcast stream id: {}", (Object)streamName);
            this.getDataStore().updateStatus(streamName, "finished");
            Broadcast broadcast = this.getDataStore().get(streamName);
            if (broadcast != null) {
                String listenerHookURL = broadcast.getListenerHookURL();
                String streamId = broadcast.getStreamId();
                if (listenerHookURL != null && listenerHookURL.length() > 0) {
                    String name = broadcast.getName();
                    String category = broadcast.getCategory();
                    logger.info("Setting timer to call live stream ended hook for stream:{}", (Object)streamId);
                    this.vertx.runOnContext(e -> this.notifyHook(listenerHookURL, streamId, HOOK_ACTION_END_LIVE_STREAM, name, category, null, null));
                }
                this.stopPublishingSocialEndpoints(broadcast);
                if (broadcast.isZombi()) {
                    if (broadcast.getMainTrackStreamId() != null && !broadcast.getMainTrackStreamId().isEmpty()) {
                        this.updateMainBroadcast(broadcast);
                    }
                    this.getDataStore().delete(streamName);
                } else {
                    this.resetHLSStats(streamId);
                }
                for (IStreamListener listener : this.streamListeners) {
                    listener.streamFinished(broadcast.getStreamId());
                }
            }
        }
        catch (Exception e2) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e2));
        }
    }

    public void updateMainBroadcast(Broadcast broadcast) {
        Broadcast mainBroadcast = this.getDataStore().get(broadcast.getMainTrackStreamId());
        mainBroadcast.getSubTrackStreamIds().remove(broadcast.getStreamId());
        if (mainBroadcast.getSubTrackStreamIds().isEmpty() && mainBroadcast.isZombi()) {
            this.getDataStore().delete(mainBroadcast.getStreamId());
        } else {
            this.getDataStore().updateBroadcastFields(mainBroadcast.getStreamId(), mainBroadcast);
        }
    }

    public void resetHLSStats(String streamId) {
        HlsViewerStats hlsViewerStats;
        if (this.scope.getContext().getApplicationContext().containsBean("hls.viewerstats") && (hlsViewerStats = (HlsViewerStats)this.scope.getContext().getApplicationContext().getBean("hls.viewerstats")) != null) {
            hlsViewerStats.resetHLSViewerMap(streamId);
        }
    }

    public void stopPublishingSocialEndpoints(Broadcast broadcast) {
        List<Endpoint> endPointList = broadcast.getEndPointList();
        if (endPointList != null) {
            for (Endpoint endpoint : endPointList) {
                VideoServiceEndpoint videoServiceEndPoint = this.getVideoServiceEndPoint(endpoint.getEndpointServiceId());
                if (videoServiceEndPoint == null) continue;
                try {
                    videoServiceEndPoint.stopBroadcast(endpoint);
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
            this.recreateEndpointsForSocialMedia(broadcast, endPointList);
        }
    }

    public void recreateEndpointsForSocialMedia(Broadcast broadcast, List<Endpoint> endPointList) {
        ArrayList<Endpoint> removeList = new ArrayList<Endpoint>();
        ArrayList<Endpoint> addList = new ArrayList<Endpoint>();
        for (Endpoint endpoint : endPointList) {
            VideoServiceEndpoint videoServiceEndPoint;
            if ("".equals(endpoint.getType()) || (videoServiceEndPoint = this.getVideoServiceEndPoint(endpoint.getEndpointServiceId())) == null) continue;
            try {
                Endpoint newEndpoint = videoServiceEndPoint.createBroadcast(broadcast.getName(), broadcast.getDescription(), broadcast.getStreamId(), broadcast.isIs360(), broadcast.isPublicStream(), 2160, true);
                removeList.add(endpoint);
                addList.add(newEndpoint);
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        for (Endpoint endpoint : removeList) {
            this.getDataStore().removeEndpoint(broadcast.getStreamId(), endpoint, true);
        }
        for (Endpoint endpoint : addList) {
            this.getDataStore().addEndpoint(broadcast.getStreamId(), endpoint);
        }
    }

    public VideoServiceEndpoint getEndpointService(String className, SocialEndpointCredentials socialEndpointCredentials, String clientId, String clientSecret) {
        try {
            Class<?> endpointClass = Class.forName(className);
            VideoServiceEndpoint endPointService = (VideoServiceEndpoint)endpointClass.getConstructor(String.class, String.class, DataStore.class, SocialEndpointCredentials.class, Vertx.class).newInstance(clientId, clientSecret, this.getDataStore(), socialEndpointCredentials, this.vertx);
            endPointService.setCollectInteractivity(this.appSettings.isCollectSocialMediaActivity());
            return endPointService;
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    @Override
    public void streamPlayItemPlay(ISubscriberStream stream, IPlayItem item, boolean isLive) {
        this.vertx.setTimer(1L, l -> this.getDataStore().updateRtmpViewerCount(item.getName(), true));
    }

    @Override
    public void streamPlayItemStop(ISubscriberStream stream, IPlayItem item) {
        this.vertx.setTimer(1L, l -> this.getDataStore().updateRtmpViewerCount(item.getName(), false));
    }

    @Override
    public void streamSubscriberClose(ISubscriberStream stream) {
        this.vertx.setTimer(1L, l -> this.getDataStore().updateRtmpViewerCount(stream.getBroadcastStreamPublishName(), false));
    }

    @Override
    public void startPublish(String streamName, long absoluteStartTimeMs, String publishType) {
        this.vertx.executeBlocking(handler -> {
            try {
                Broadcast broadcast = this.updateBroadcastStatus(streamName, absoluteStartTimeMs, publishType, this.getDataStore().get(streamName));
                String listenerHookURL = broadcast.getListenerHookURL();
                String streamId = broadcast.getStreamId();
                if (listenerHookURL != null && !listenerHookURL.isEmpty()) {
                    String name = broadcast.getName();
                    String category = broadcast.getCategory();
                    logger.info("Setting timer to call live stream started hook for stream:{}", (Object)streamId);
                    this.vertx.setTimer(10L, e -> this.notifyHook(listenerHookURL, streamId, HOOK_ACTION_START_LIVE_STREAM, name, category, null, null));
                }
                int ingestingStreamLimit = this.appSettings.getIngestingStreamLimit();
                long activeBroadcastNumber = this.dataStore.getActiveBroadcastCount();
                if (ingestingStreamLimit != -1 && activeBroadcastNumber > (long)ingestingStreamLimit) {
                    logger.info("Active broadcast count({}) is more than ingesting stream limit:{} so stopping broadcast:{}", new Object[]{activeBroadcastNumber, ingestingStreamLimit, broadcast.getStreamId()});
                    this.stopStreaming(broadcast);
                } else {
                    this.publishSocialEndpoints(broadcast.getEndPointList());
                }
                for (IStreamListener listener : this.streamListeners) {
                    listener.streamStarted(broadcast.getStreamId());
                }
                handler.complete();
            }
            catch (Exception e2) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e2));
                handler.fail(ExceptionUtils.getStackTrace((Throwable)e2));
            }
        }, null);
        if (absoluteStartTimeMs == 0L) {
            this.vertx.setTimer(2000L, h -> {
                IBroadcastStream broadcastStream = this.getBroadcastStream(this.getScope(), streamName);
                if (broadcastStream instanceof ClientBroadcastStream) {
                    long absoluteStarTime = ((ClientBroadcastStream)broadcastStream).getAbsoluteStartTimeMs();
                    if (absoluteStarTime != 0L) {
                        Broadcast broadcast = this.getDataStore().get(streamName);
                        if (broadcast != null) {
                            broadcast.setAbsoluteStartTimeMs(absoluteStarTime);
                            this.getDataStore().save(broadcast);
                            logger.info("Updating broadcast absolute time {} ms for stream:{}", (Object)absoluteStarTime, (Object)streamName);
                        } else {
                            logger.info("Broadcast is not available in the database to update the absolute start time for stream:{}", (Object)streamName);
                        }
                    } else {
                        logger.info("Broadcast absolute time is not available for stream:{}", (Object)streamName);
                    }
                }
            });
        }
        logger.info("start publish leaved for stream:{}", (Object)streamName);
    }

    @Override
    public Broadcast updateBroadcastStatus(String streamId, long absoluteStartTimeMs, String publishType, Broadcast broadcast) {
        if (broadcast == null) {
            broadcast = AntMediaApplicationAdapter.saveUndefinedBroadcast(streamId, null, this, "broadcasting", absoluteStartTimeMs, publishType);
        } else {
            broadcast.setStatus("broadcasting");
            broadcast.setStartTime(System.currentTimeMillis());
            broadcast.setOriginAdress(this.getServerSettings().getHostAddress());
            broadcast.setWebRTCViewerCount(0);
            broadcast.setHlsViewerCount(0);
            broadcast.setPublishType(publishType);
            boolean result = this.getDataStore().updateBroadcastFields(broadcast.getStreamId(), broadcast);
            logger.info(" Status of stream {} is set to Broadcasting with result: {}", (Object)broadcast.getStreamId(), (Object)result);
        }
        return broadcast;
    }

    protected ServerSettings getServerSettings() {
        if (this.serverSettings == null) {
            this.serverSettings = (ServerSettings)this.scope.getContext().getApplicationContext().getBean("ant.media.server.settings");
        }
        return this.serverSettings;
    }

    public void publishSocialEndpoints(List<Endpoint> endPointList) {
        if (endPointList != null) {
            for (Endpoint endpoint : endPointList) {
                VideoServiceEndpoint videoServiceEndPoint = this.getVideoServiceEndPoint(endpoint.getEndpointServiceId());
                if (videoServiceEndPoint == null) continue;
                try {
                    videoServiceEndPoint.publishBroadcast(endpoint);
                    logger.info("publish broadcast called for {}", (Object)videoServiceEndPoint.getName());
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }
    }

    public static Broadcast saveUndefinedBroadcast(String streamId, String streamName, AntMediaApplicationAdapter appAdapter, String streamStatus, long absoluteStartTimeMs, String publishType) {
        return AntMediaApplicationAdapter.saveUndefinedBroadcast(streamId, streamName, appAdapter, streamStatus, absoluteStartTimeMs, publishType, "");
    }

    public static Broadcast saveUndefinedBroadcast(String streamId, String streamName, AntMediaApplicationAdapter appAdapter, String streamStatus, long absoluteStartTimeMs, String publishType, String mainTrackStreamId) {
        Broadcast newBroadcast = new Broadcast();
        long now = System.currentTimeMillis();
        newBroadcast.setDate(now);
        newBroadcast.setStartTime(now);
        newBroadcast.setZombi(true);
        newBroadcast.setName(streamName);
        newBroadcast.setMainTrackStreamId(mainTrackStreamId);
        try {
            newBroadcast.setStreamId(streamId);
            newBroadcast.setPublishType(publishType);
            String settingsListenerHookURL = null;
            settingsListenerHookURL = appAdapter.getAppSettings().getListenerHookURL();
            return RestServiceBase.saveBroadcast(newBroadcast, streamStatus, appAdapter.getScope().getName(), appAdapter.getDataStore(), settingsListenerHookURL, appAdapter.getServerSettings(), absoluteStartTimeMs);
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    public VideoServiceEndpoint getVideoServiceEndPoint(String id) {
        if (this.videoServiceEndpoints != null) {
            return this.videoServiceEndpoints.get(id);
        }
        return null;
    }

    @Override
    public void muxingFinished(String streamId, File file, long duration, int resolution) {
        String muxerFinishScript;
        int index;
        String vodName = file.getName();
        String filePath = file.getPath();
        long fileSize = file.length();
        long systemTime = System.currentTimeMillis();
        String relativePath = AntMediaApplicationAdapter.getRelativePath(filePath);
        String listenerHookURL = null;
        Object streamName = file.getName();
        Broadcast broadcast = this.getDataStore().get(streamId);
        if (broadcast != null && broadcast.getName() != null) {
            streamName = broadcast.getName();
            listenerHookURL = broadcast.getListenerHookURL();
            if (resolution != 0) {
                streamName = (String)streamName + " (" + resolution + "p)";
            }
        }
        if (listenerHookURL == null || listenerHookURL.isEmpty()) {
            listenerHookURL = this.appSettings.getListenerHookURL();
        }
        String vodId = RandomStringUtils.randomNumeric((int)24);
        VoD newVod = new VoD((String)streamName, streamId, relativePath, vodName, systemTime, duration, fileSize, "streamVod", vodId);
        if (this.getDataStore().addVod(newVod) == null) {
            logger.warn("Stream vod with stream id {} cannot be added to data store", (Object)streamId);
        }
        if (listenerHookURL != null && !listenerHookURL.isEmpty() && (index = vodName.lastIndexOf(".mp4")) != -1 || (index = vodName.lastIndexOf(".webm")) != -1) {
            String baseName = vodName.substring(0, index);
            String finalListenerHookURL = listenerHookURL;
            logger.info("Setting timer for calling vod ready hook for stream:{}", (Object)streamId);
            this.vertx.runOnContext(e -> this.notifyHook(finalListenerHookURL, streamId, HOOK_ACTION_VOD_READY, null, null, baseName, vodId));
        }
        if ((muxerFinishScript = this.appSettings.getMuxerFinishScript()) != null && !muxerFinishScript.isEmpty()) {
            this.runScript(muxerFinishScript + "  " + file.getAbsolutePath());
        }
    }

    public void runScript(String scriptFile) {
        this.vertx.executeBlocking(future -> {
            try {
                logger.info("running muxer finish script: {}", (Object)scriptFile);
                Process exec = Runtime.getRuntime().exec(scriptFile);
                int result = exec.waitFor();
                logger.info("completing script: {} with return value {}", (Object)scriptFile, (Object)result);
            }
            catch (IOException e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
            catch (InterruptedException e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                Thread.currentThread().interrupt();
            }
            future.complete();
        }, null);
    }

    public static String getRelativePath(String filePath) {
        StringBuilder relativePath = new StringBuilder();
        String[] subDirs = filePath.split("streams");
        if (subDirs.length == 2) {
            relativePath = new StringBuilder("streams" + subDirs[1]);
        } else {
            for (int i = 1; i < subDirs.length; ++i) {
                relativePath.append("streams").append(subDirs[i]);
            }
        }
        return relativePath.toString();
    }

    public void startDeviceAuthStatusPolling(VideoServiceEndpoint videoServiceEndpoint, VideoServiceEndpoint.DeviceAuthParameters askDeviceAuthParameters) {
        int timeDelta = askDeviceAuthParameters.interval * 1000;
        this.getVertx().setTimer((long)timeDelta, l -> new AuthCheckJob(0, timeDelta, videoServiceEndpoint, this).execute());
    }

    public Map<String, VideoServiceEndpoint> getVideoServiceEndpoints() {
        return this.videoServiceEndpoints;
    }

    public List<VideoServiceEndpoint> getVideoServiceEndpointsHavingError() {
        return this.videoServiceEndpointsHavingError;
    }

    public void setVideoServiceEndpoints(Map<String, VideoServiceEndpoint> videoServiceEndpoints) {
        this.videoServiceEndpoints = videoServiceEndpoints;
    }

    public StringBuilder notifyHook(String url, String id, String action, String streamName, String category, String vodName, String vodId) {
        StringBuilder response = null;
        logger.info("Running notify hook url:{} stream id: {} action:{} vod name:{} vod id:{}", new Object[]{url, id, action, vodName, vodId});
        if (url != null && url.length() > 0) {
            HashMap<String, String> variables = new HashMap<String, String>();
            variables.put("id", id);
            variables.put("action", action);
            if (streamName != null) {
                variables.put("streamName", streamName);
            }
            if (category != null) {
                variables.put("category", category);
            }
            if (vodName != null) {
                variables.put("vodName", vodName);
            }
            if (vodId != null) {
                variables.put("vodId", vodId);
            }
            try {
                response = this.sendPOST(url, variables);
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return response;
    }

    public StringBuilder sendPOST(String url, Map<String, String> variables) throws IOException {
        StringBuilder response = null;
        try (CloseableHttpClient httpClient = this.getHttpClient();){
            HttpPost httpPost = new HttpPost(url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(2000).setConnectionRequestTimeout(2000).setSocketTimeout(2000).build();
            httpPost.setConfig(requestConfig);
            ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>();
            Set<Map.Entry<String, String>> entrySet = variables.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                urlParameters.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            UrlEncodedFormEntity postParams = new UrlEncodedFormEntity(urlParameters);
            httpPost.setEntity((HttpEntity)postParams);
            try (CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);){
                logger.info("POST Response Status:: {}", (Object)httpResponse.getStatusLine().getStatusCode());
                HttpEntity entity = httpResponse.getEntity();
                if (entity != null) {
                    String inputLine;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(entity.getContent()));
                    response = new StringBuilder();
                    while ((inputLine = reader.readLine()) != null) {
                        response.append(inputLine);
                    }
                    reader.close();
                }
            }
        }
        return response;
    }

    public CloseableHttpClient getHttpClient() {
        return HttpClients.createDefault();
    }

    public List<IStreamPublishSecurity> getStreamPublishSecurityList() {
        return this.streamPublishSecurityList;
    }

    public void setStreamPublishSecurityList(List<IStreamPublishSecurity> streamPublishSecurityList) {
        this.streamPublishSecurityList = streamPublishSecurityList;
    }

    public AppSettings getAppSettings() {
        return this.appSettings;
    }

    public void setAppSettings(AppSettings appSettings) {
        this.appSettings = appSettings;
    }

    public StreamAcceptFilter getStreamAcceptFilter() {
        return this.streamAcceptFilter;
    }

    public void setStreamAcceptFilter(StreamAcceptFilter streamAcceptFilter) {
        this.streamAcceptFilter = streamAcceptFilter;
    }

    @Override
    public boolean isValidStreamParameters(int width, int height, int fps, int bitrate, String streamId) {
        return this.streamAcceptFilter.isValidStreamParameters(width, height, fps, bitrate, streamId);
    }

    public Result startStreaming(Broadcast broadcast) {
        Result result = new Result(false);
        if (broadcast.getType().equals(IP_CAMERA) || broadcast.getType().equals(STREAM_SOURCE) || broadcast.getType().equals(VOD)) {
            result = this.getStreamFetcherManager().startStreaming(broadcast);
        } else if (broadcast.getType().equals(PLAY_LIST)) {
            result = this.getStreamFetcherManager().startPlaylist(broadcast);
        }
        return result;
    }

    public Result stopStreaming(Broadcast broadcast) {
        IBroadcastStream broadcastStream;
        Result result = new Result(false);
        logger.info("stopStreaming is called for stream:{}", (Object)broadcast.getStreamId());
        if (broadcast.getType().equals(IP_CAMERA) || broadcast.getType().equals(STREAM_SOURCE) || broadcast.getType().equals(VOD)) {
            result = this.getStreamFetcherManager().stopStreaming(broadcast.getStreamId());
        } else if (broadcast.getType().equals(PLAY_LIST)) {
            result = this.getStreamFetcherManager().stopPlayList(broadcast.getStreamId());
        } else if (broadcast.getType().equals(LIVE_STREAM) && (broadcastStream = this.getBroadcastStream(this.getScope(), broadcast.getStreamId())) != null) {
            IStreamCapableConnection connection = ((IClientBroadcastStream)broadcastStream).getConnection();
            if (connection != null) {
                connection.close();
            } else {
                logger.warn("Connection is null. It should not happen for stream: {}. Analyze the logs", (Object)broadcast.getStreamId());
            }
            result.setSuccess(true);
        }
        return result;
    }

    public OnvifCamera getOnvifCamera(String id) {
        Broadcast camera;
        OnvifCamera onvifCamera = this.onvifCameraList.get(id);
        if (onvifCamera == null && (camera = this.getDataStore().get(id)) != null) {
            onvifCamera = new OnvifCamera();
            onvifCamera.connect(camera.getIpAddr(), camera.getUsername(), camera.getPassword());
            this.onvifCameraList.put(id, onvifCamera);
        }
        return onvifCamera;
    }

    public StreamFetcherManager getStreamFetcherManager() {
        if (this.streamFetcherManager == null) {
            this.streamFetcherManager = new StreamFetcherManager(this.vertx, this.getDataStore(), this.getScope());
        }
        return this.streamFetcherManager;
    }

    public void setStreamFetcherManager(StreamFetcherManager streamFetcherManager) {
        this.streamFetcherManager = streamFetcherManager;
    }

    @Override
    public void setQualityParameters(String id, String quality, double speed, int pendingPacketSize) {
        this.vertx.setTimer(500L, h -> {
            logger.debug("update source quality for stream: {} quality:{} speed:{}", new Object[]{id, quality, speed});
            this.getDataStore().updateSourceQualityParameters(id, quality, speed, pendingPacketSize);
        });
    }

    public DataStore getDataStore() {
        if (this.dataStore == null) {
            this.dataStore = this.dataStoreFactory.getDataStore();
        }
        return this.dataStore;
    }

    public void setDataStore(DataStore dataStore) {
        this.dataStore = dataStore;
    }

    public DataStoreFactory getDataStoreFactory() {
        return this.dataStoreFactory;
    }

    public void setDataStoreFactory(DataStoreFactory dataStoreFactory) {
        this.dataStoreFactory = dataStoreFactory;
    }

    public void setVertx(Vertx vertx) {
        this.vertx = vertx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeRTMPStreams() {
        List<MuxAdaptor> adaptors;
        List<MuxAdaptor> list = adaptors = this.getMuxAdaptors();
        synchronized (list) {
            for (MuxAdaptor adaptor : adaptors) {
                if (!adaptor.getBroadcast().getType().equals(LIVE_STREAM)) continue;
                ClientBroadcastStream broadcastStream = adaptor.getBroadcastStream();
                if (broadcastStream != null) {
                    broadcastStream.stop();
                }
                adaptor.stop(true);
            }
        }
    }

    public void closeStreamFetchers() {
        if (this.streamFetcherManager != null) {
            Queue<StreamFetcher> fetchers = this.streamFetcherManager.getStreamFetcherList();
            for (StreamFetcher streamFetcher : fetchers) {
                streamFetcher.stopStream();
                fetchers.remove(streamFetcher);
            }
        }
    }

    public void waitUntilLiveStreamsStopped() {
        int i = 0;
        int waitPeriod = 1000;
        while (this.getDataStore().getLocalLiveBroadcastCount(this.getServerSettings().getHostAddress()) > 0L) {
            try {
                if (i > 3) {
                    logger.warn("Waiting for active broadcasts number decrease to zero for app: {}total wait time: {}ms", (Object)this.getScope().getName(), (Object)(i * waitPeriod));
                }
                if (i > 10) {
                    logger.error("*********************************************************************************");
                    logger.error("Not all live streams're stopped. It's even breaking the loop to finish the server");
                    logger.error("*********************************************************************************");
                    break;
                }
                ++i;
                Thread.sleep(waitPeriod);
            }
            catch (InterruptedException e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                Thread.currentThread().interrupt();
            }
        }
    }

    public void waitUntilThreadsStop() {
        int i = 0;
        int waitPeriod = 1000;
        int activeVertxThreadCount = 0;
        while ((activeVertxThreadCount = this.getActiveVertxThreadCount()) > 0) {
            try {
                if (i > 3) {
                    logger.warn("Waiting for active vertx threads count({}) decrease to zero for app: {} total wait time: {}ms", new Object[]{activeVertxThreadCount, this.getScope().getName(), i * waitPeriod});
                }
                if (i > 10) {
                    logger.error("*********************************************************************");
                    logger.error("Not all active vertx threads are stopped. It's even breaking the loop");
                    logger.error("*********************************************************************");
                    break;
                }
                ++i;
                Thread.sleep(waitPeriod);
            }
            catch (InterruptedException e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                Thread.currentThread().interrupt();
            }
        }
    }

    private int getActiveVertxThreadCount() {
        int activeVertexThreadCount = 0;
        try {
            MetricsService metricsService = MetricsService.create((Vertx)this.vertx);
            String activeThreadKey = "vertx.pools.worker.vert.x-worker-thread.in-use";
            JsonObject metrics = metricsService.getMetricsSnapshot(activeThreadKey);
            if (metrics != null) {
                activeVertexThreadCount = metrics.getJsonObject(activeThreadKey).getInteger("count");
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return activeVertexThreadCount;
    }

    @Override
    public void serverShuttingdown() {
        logger.info("{} is closing streams", (Object)this.getScope().getName());
        this.serverShuttingDown = true;
        this.closeStreamFetchers();
        this.closeRTMPStreams();
        this.waitUntilLiveStreamsStopped();
        this.waitUntilThreadsStop();
        this.createShutdownFile(this.getScope().getName());
        this.getDataStore().close();
    }

    public Result createInitializationProcess(String appName) {
        Result result = new Result(false);
        String initializedFilePath = WEBAPPS_PATH + appName + "/.initialized";
        File initializedFile = new File(initializedFilePath);
        String closedFilePath = WEBAPPS_PATH + appName + "/.closed";
        File closedFile = new File(closedFilePath);
        try {
            if (!initializedFile.exists() && !closedFile.exists()) {
                this.createInitializationFile(appName, result, initializedFile);
            } else if (initializedFile.exists() && closedFile.exists()) {
                Files.delete(closedFile.toPath());
                if (!closedFile.exists()) {
                    result.setMessage("System works, deleted closed file in " + appName);
                    result.setSuccess(true);
                    logger.info("Delete the \".closed\" file in {}", (Object)appName);
                } else {
                    result.setMessage("Delete couldn't closed file in " + appName);
                    result.setSuccess(false);
                    logger.info("Not deleted the \".closed\" file in {}", (Object)appName);
                }
            } else if (initializedFile.exists() && !closedFile.exists()) {
                result.setMessage("Something wrong in " + appName);
                result.setSuccess(false);
                logger.error("Something wrong in {}", (Object)appName);
            } else {
                this.createInitializationFile(appName, result, initializedFile);
                Files.deleteIfExists(closedFile.toPath());
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        return result;
    }

    public void createInitializationFile(String appName, Result result, File initializedFile) throws IOException {
        if (initializedFile.createNewFile()) {
            result.setMessage("Initialized file created in " + appName);
            result.setSuccess(true);
            logger.info("Initialized file is created in {}", (Object)appName);
        } else {
            result.setMessage("Initialized file couldn't create in " + appName);
            result.setSuccess(false);
            logger.info("Initialized file couldn't be created in {}", (Object)appName);
        }
    }

    public void createShutdownFile(String appName) {
        String closedFilePath = WEBAPPS_PATH + appName + "/.closed";
        File closedFile = new File(closedFilePath);
        try {
            if (!closedFile.exists()) {
                if (closedFile.createNewFile()) {
                    logger.info("Closed file created in {}", (Object)appName);
                } else {
                    logger.error("Closed file couldn't create in {}", (Object)appName);
                }
            } else {
                logger.warn("Closed file already exists for app: {}", (Object)appName);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
    }

    public boolean isShutdownProperly() {
        return this.shutdownProperly;
    }

    public void setShutdownProperly(boolean shutdownProperly) {
        this.shutdownProperly = shutdownProperly;
    }

    @Override
    public void muxAdaptorAdded(MuxAdaptor muxAdaptor) {
        this.getMuxAdaptors().add(muxAdaptor);
    }

    @Override
    public void muxAdaptorRemoved(MuxAdaptor muxAdaptor) {
        this.getMuxAdaptors().remove(muxAdaptor);
    }

    public List<MuxAdaptor> getMuxAdaptors() {
        if (this.muxAdaptors == null) {
            this.muxAdaptors = Collections.synchronizedList(new ArrayList());
        }
        return this.muxAdaptors;
    }

    public int getNumberOfEncodersBlocked() {
        return this.encoderBlockedStreams.size();
    }

    public synchronized void encoderBlocked(String streamId, boolean blocked) {
        if (blocked) {
            this.encoderBlockedStreams.add(streamId);
        } else {
            this.encoderBlockedStreams.remove(streamId);
        }
    }

    public synchronized void incrementEncoderNotOpenedError() {
        ++this.numberOfEncoderNotOpenedErrors;
    }

    public int getNumberOfEncoderNotOpenedErrors() {
        return this.numberOfEncoderNotOpenedErrors;
    }

    public int getNumberOfPublishTimeoutError() {
        return this.publishTimeoutStreams;
    }

    public synchronized void publishTimeoutError(String streamId) {
        ++this.publishTimeoutStreams;
        this.publishTimeoutStreamsList.add(streamId);
    }

    public WebRTCAudioReceiveStats getWebRTCAudioReceiveStats() {
        return this.webRTCAudioReceiveStats;
    }

    public WebRTCVideoReceiveStats getWebRTCVideoReceiveStats() {
        return this.webRTCVideoReceiveStats;
    }

    public WebRTCAudioSendStats getWebRTCAudioSendStats() {
        return this.webRTCAudioSendStats;
    }

    public WebRTCVideoSendStats getWebRTCVideoSendStats() {
        return this.webRTCVideoSendStats;
    }

    public Vertx getVertx() {
        if (this.vertx == null) {
            this.vertx = (Vertx)this.getScope().getContext().getBean("vertxCore");
        }
        return this.vertx;
    }

    public synchronized boolean updateSettings(AppSettings newSettings, boolean notifyCluster, boolean checkUpdateTime) {
        boolean result = false;
        if (!this.isIncomingTimeValid(newSettings, checkUpdateTime)) {
            logger.warn("Not saving the settings because current appsettings update time({}) is later than incoming settings update time({}) ", (Object)this.appSettings.getUpdateTime(), (Object)newSettings.getUpdateTime());
            return result;
        }
        List<EncoderSettings> encoderSettingsList = newSettings.getEncoderSettings();
        if (!this.isEncoderSettingsValid(encoderSettingsList)) {
            return result;
        }
        newSettings.setEncoderSettings(encoderSettingsList);
        if (newSettings.getHlsListSize() == null || Integer.valueOf(newSettings.getHlsListSize()) < 5) {
            newSettings.setHlsListSize("5");
        }
        if (newSettings.getHlsTime() == null || Integer.valueOf(newSettings.getHlsTime()) < 1) {
            newSettings.setHlsTime("1");
        }
        if (AntMediaApplicationAdapter.updateAppSettingsFile(this.getScope().getName(), newSettings)) {
            AcceptOnlyStreamsInDataStore securityHandler = (AcceptOnlyStreamsInDataStore)this.getScope().getContext().getBean("acceptOnlyStreamsInDataStore");
            securityHandler.setEnabled(newSettings.isAcceptOnlyStreamsInDataStore());
            this.updateAppSettingsBean(this.appSettings, newSettings);
            if (notifyCluster && this.clusterNotifier != null) {
                this.appSettings.setToBeDeleted(newSettings.isToBeDeleted());
                boolean saveSettings = this.clusterNotifier.getClusterStore().saveSettings(this.appSettings);
                logger.info("Saving settings to cluster db -> {} for app: {}", (Object)saveSettings, (Object)this.getScope().getName());
            }
            result = true;
        } else {
            logger.warn("Settings cannot be saved for {}", (Object)this.getScope().getName());
        }
        return result;
    }

    private boolean isEncoderSettingsValid(List<EncoderSettings> encoderSettingsList) {
        if (encoderSettingsList != null) {
            for (EncoderSettings encoderSettings : encoderSettingsList) {
                if (encoderSettings.getHeight() > 0 && encoderSettings.getVideoBitrate() > 0 && encoderSettings.getAudioBitrate() > 0) continue;
                logger.error("Unexpected encoder parameter. None of the parameters(height:{}, video bitrate:{}, audio bitrate:{}) can be zero or less", new Object[]{encoderSettings.getHeight(), encoderSettings.getVideoBitrate(), encoderSettings.getAudioBitrate()});
                return false;
            }
        }
        return true;
    }

    public boolean isIncomingTimeValid(AppSettings newSettings, boolean checkUpdateTime) {
        return !checkUpdateTime || this.appSettings.getUpdateTime() == 0L || newSettings.getUpdateTime() == 0L || this.appSettings.getUpdateTime() <= newSettings.getUpdateTime();
    }

    public void setClusterNotifier(IClusterNotifier clusterNotifier) {
        this.clusterNotifier = clusterNotifier;
    }

    public static boolean updateAppSettingsFile(String appName, AppSettings newAppsettings) {
        PreferenceStore store = new PreferenceStore(WEBAPPS_PATH + appName + "/WEB-INF/red5-web.properties");
        store.put("settings.mp4MuxingEnabled", String.valueOf(newAppsettings.isMp4MuxingEnabled()));
        store.put("settings.webMMuxingEnabled", String.valueOf(newAppsettings.isWebMMuxingEnabled()));
        store.put("settings.addDateTimeToMp4FileName", String.valueOf(newAppsettings.isAddDateTimeToMp4FileName()));
        store.put("settings.hlsMuxingEnabled", String.valueOf(newAppsettings.isHlsMuxingEnabled()));
        store.put("settings.dashMuxingEnabled", String.valueOf(newAppsettings.isDashMuxingEnabled()));
        store.put("settings.deleteDASHFilesOnEnded", String.valueOf(newAppsettings.isDeleteDASHFilesOnEnded()));
        store.put("settings.dash.hlsEnabled", String.valueOf(newAppsettings.isHlsEnabledViaDash()));
        store.put("settings.dash.llHlsEnabled", String.valueOf(newAppsettings.islLHLSEnabled()));
        store.put("settings.dash.llEnabled", String.valueOf(newAppsettings.islLDashEnabled()));
        store.put("settings.rtspTimeoutDurationMs", String.valueOf(newAppsettings.getRtspTimeoutDurationMs()));
        store.put("settings.uploadExtensionsToS3", String.valueOf(newAppsettings.getUploadExtensionsToS3()));
        store.put("settings.acceptOnlyStreamsInDataStore", String.valueOf(newAppsettings.isAcceptOnlyStreamsInDataStore()));
        store.put("settings.objectDetectionEnabled", String.valueOf(newAppsettings.isObjectDetectionEnabled()));
        store.put("settings.publishTokenControlEnabled", String.valueOf(newAppsettings.isPublishTokenControlEnabled()));
        store.put("settings.playTokenControlEnabled", String.valueOf(newAppsettings.isPlayTokenControlEnabled()));
        store.put("settings.timeTokenSubscriberOnly", String.valueOf(newAppsettings.isTimeTokenSubscriberOnly()));
        store.put("settings.enableTimeTokenForPlay", String.valueOf(newAppsettings.isEnableTimeTokenForPlay()));
        store.put("settings.enableTimeTokenForPublish", String.valueOf(newAppsettings.isEnableTimeTokenForPublish()));
        store.put("settings.endpoint.healthCheckPeriodMs", String.valueOf(newAppsettings.getEndpointHealthCheckPeriodMs()));
        store.put("settings.endpoint.republishLimit", String.valueOf(newAppsettings.getEndpointRepublishLimit()));
        store.put("settings.publishJwtControlEnabled", String.valueOf(newAppsettings.isPublishJwtControlEnabled()));
        store.put("settings.playJwtControlEnabled", String.valueOf(newAppsettings.isPlayJwtControlEnabled()));
        store.put("settings.jwtStreamSecretKey", newAppsettings.getJwtStreamSecretKey() != null ? newAppsettings.getJwtStreamSecretKey() : "");
        store.put("settings.webRTCEnabled", String.valueOf(newAppsettings.isWebRTCEnabled()));
        store.put("settings.webRTCFrameRate", String.valueOf(newAppsettings.getWebRTCFrameRate()));
        store.put("settings.hashControlPublishEnabled", String.valueOf(newAppsettings.isHashControlPublishEnabled()));
        store.put("settings.hashControlPlayEnabled", String.valueOf(newAppsettings.isHashControlPlayEnabled()));
        store.put("settings.remoteAllowedCIDR", newAppsettings.getRemoteAllowedCIDR() != null ? newAppsettings.getRemoteAllowedCIDR() : DEFAULT_LOCALHOST);
        store.put("settings.vodFolder", newAppsettings.getVodFolder() != null ? newAppsettings.getVodFolder() : "");
        store.put("settings.hlsListSize", String.valueOf(newAppsettings.getHlsListSize()));
        store.put("settings.hlsTime", String.valueOf(newAppsettings.getHlsTime()));
        store.put("settings.hlsPlayListType", newAppsettings.getHlsPlayListType() != null ? newAppsettings.getHlsPlayListType() : "");
        store.put("settings.encoderSettingsString", AppSettings.encodersList2Str(newAppsettings.getEncoderSettings()));
        store.put("tokenHashSecret", newAppsettings.getTokenHashSecret() != null ? newAppsettings.getTokenHashSecret() : "");
        store.put("settings.previewOverwrite", String.valueOf(newAppsettings.isPreviewOverwrite()));
        store.put("settings.allowedPublisherCIDR", newAppsettings.getAllowedPublisherCIDR() != null ? String.valueOf(newAppsettings.getAllowedPublisherCIDR()) : "");
        store.put("settings.h264Enabled", String.valueOf(newAppsettings.isH264Enabled()));
        store.put("settings.vp8Enabled", String.valueOf(newAppsettings.isVp8Enabled()));
        store.put("settings.h265Enabled", String.valueOf(newAppsettings.isH265Enabled()));
        store.put("settings.dataChannelEnabled", String.valueOf(newAppsettings.isDataChannelEnabled()));
        store.put("settings.dataChannelPlayerDistrubution", String.valueOf(newAppsettings.getDataChannelPlayerDistribution()));
        store.put("settings.maxResolutionAccept", String.valueOf(newAppsettings.getMaxResolutionAccept()));
        store.put("settings.listenerHookURL", newAppsettings.getListenerHookURL() != null ? newAppsettings.getListenerHookURL() : "");
        store.put("settings.streamFetcherRestartPeriod", String.valueOf(newAppsettings.getRestartStreamFetcherPeriod()));
        store.put("settings.jwtControlEnabled", String.valueOf(newAppsettings.isJwtControlEnabled()));
        store.put("settings.jwtSecretKey", newAppsettings.getJwtSecretKey() != null ? newAppsettings.getJwtSecretKey() : "");
        store.put("settings.s3RecordingEnabled", String.valueOf(newAppsettings.isS3RecordingEnabled()));
        store.put("settings.s3AccessKey", newAppsettings.getS3AccessKey() != null ? newAppsettings.getS3AccessKey() : "");
        store.put("settings.s3SecretKey", newAppsettings.getS3SecretKey() != null ? newAppsettings.getS3SecretKey() : "");
        store.put("settings.s3RegionName", newAppsettings.getS3RegionName() != null ? newAppsettings.getS3RegionName() : "");
        store.put("settings.s3BucketName", newAppsettings.getS3BucketName() != null ? newAppsettings.getS3BucketName() : "");
        store.put("settings.s3Endpoint", newAppsettings.getS3Endpoint() != null ? newAppsettings.getS3Endpoint() : "");
        store.put("settings.s3Permission", newAppsettings.getS3Permission() != null ? newAppsettings.getS3Permission() : "");
        store.put("settings.ipFilterEnabled", String.valueOf(newAppsettings.isIpFilterEnabled()));
        store.put("settings.previewGenerate", String.valueOf(newAppsettings.isGeneratePreview()));
        store.put("settings.hlsEncryptionKeyInfoFile", newAppsettings.getHlsEncryptionKeyInfoFile() != null ? newAppsettings.getHlsEncryptionKeyInfoFile() : "");
        store.put("settings.webhookAuthenticateURL", newAppsettings.getWebhookAuthenticateURL() != null ? String.valueOf(newAppsettings.getWebhookAuthenticateURL()) : "");
        store.put("settings.forceAspectRationInTranscoding", String.valueOf(newAppsettings.isForceAspectRatioInTranscoding()));
        return store.save();
    }

    private void updateAppSettingsBean(AppSettings appSettings, AppSettings newSettings) {
        appSettings.setMp4MuxingEnabled(newSettings.isMp4MuxingEnabled());
        appSettings.setWebMMuxingEnabled(newSettings.isWebMMuxingEnabled());
        appSettings.setAddDateTimeToMp4FileName(newSettings.isAddDateTimeToMp4FileName());
        appSettings.setHlsMuxingEnabled(newSettings.isHlsMuxingEnabled());
        appSettings.setDashMuxingEnabled(newSettings.isDashMuxingEnabled());
        appSettings.setEndpointRepublishLimit(newSettings.getEndpointRepublishLimit());
        appSettings.setEndpointHealthCheckPeriodMs(newSettings.getEndpointHealthCheckPeriodMs());
        appSettings.setUploadExtensionsToS3(newSettings.getUploadExtensionsToS3());
        appSettings.setRtspTimeoutDurationMs(newSettings.getRtspTimeoutDurationMs());
        appSettings.setHlsEnabledViaDash(newSettings.isHlsEnabledViaDash());
        appSettings.setlLHLSEnabled(newSettings.islLHLSEnabled());
        appSettings.setlLDashEnabled(newSettings.islLDashEnabled());
        appSettings.setDeleteDASHFilesOnEnded(newSettings.isDeleteDASHFilesOnEnded());
        appSettings.setObjectDetectionEnabled(newSettings.isObjectDetectionEnabled());
        appSettings.setHlsListSize(String.valueOf(newSettings.getHlsListSize()));
        appSettings.setHlsTime(String.valueOf(newSettings.getHlsTime()));
        appSettings.setHlsPlayListType(newSettings.getHlsPlayListType());
        appSettings.setAcceptOnlyStreamsInDataStore(newSettings.isAcceptOnlyStreamsInDataStore());
        appSettings.setPublishTokenControlEnabled(newSettings.isPublishTokenControlEnabled());
        appSettings.setPlayTokenControlEnabled(newSettings.isPlayTokenControlEnabled());
        appSettings.setTimeTokenSubscriberOnly(newSettings.isTimeTokenSubscriberOnly());
        appSettings.setEnableTimeTokenForPublish(newSettings.isEnableTimeTokenForPublish());
        appSettings.setEnableTimeTokenForPlay(newSettings.isEnableTimeTokenForPlay());
        appSettings.setJwtStreamSecretKey(newSettings.getJwtStreamSecretKey());
        appSettings.setPlayJwtControlEnabled(newSettings.isPlayJwtControlEnabled());
        appSettings.setPublishJwtControlEnabled(newSettings.isPublishJwtControlEnabled());
        appSettings.setWebRTCEnabled(newSettings.isWebRTCEnabled());
        appSettings.setWebRTCFrameRate(newSettings.getWebRTCFrameRate());
        appSettings.setHashControlPublishEnabled(newSettings.isHashControlPublishEnabled());
        appSettings.setHashControlPlayEnabled(newSettings.isHashControlPlayEnabled());
        appSettings.setTokenHashSecret(newSettings.getTokenHashSecret());
        appSettings.setRemoteAllowedCIDR(newSettings.getRemoteAllowedCIDR());
        appSettings.setEncoderSettings(newSettings.getEncoderSettings());
        String oldVodFolder = appSettings.getVodFolder();
        appSettings.setAllowedPublisherCIDR(newSettings.getAllowedPublisherCIDR());
        appSettings.setVodFolder(newSettings.getVodFolder());
        appSettings.setPreviewOverwrite(newSettings.isPreviewOverwrite());
        this.synchUserVoDFolder(oldVodFolder, newSettings.getVodFolder());
        appSettings.setH264Enabled(newSettings.isH264Enabled());
        appSettings.setVp8Enabled(newSettings.isVp8Enabled());
        appSettings.setH265Enabled(newSettings.isH265Enabled());
        appSettings.setDataChannelEnabled(newSettings.isDataChannelEnabled());
        appSettings.setDataChannelPlayerDistribution(newSettings.getDataChannelPlayerDistribution());
        appSettings.setMaxResolutionAccept(newSettings.getMaxResolutionAccept());
        appSettings.setListenerHookURL(newSettings.getListenerHookURL());
        appSettings.setRestartStreamFetcherPeriod(newSettings.getRestartStreamFetcherPeriod());
        appSettings.setIpFilterEnabled(newSettings.isIpFilterEnabled());
        appSettings.setJwtControlEnabled(newSettings.isJwtControlEnabled());
        appSettings.setJwtSecretKey(newSettings.getJwtSecretKey());
        appSettings.setS3RecordingEnabled(newSettings.isS3RecordingEnabled());
        appSettings.setS3AccessKey(newSettings.getS3AccessKey());
        appSettings.setS3SecretKey(newSettings.getS3SecretKey());
        appSettings.setS3BucketName(newSettings.getS3BucketName());
        appSettings.setS3RegionName(newSettings.getS3RegionName());
        appSettings.setS3Endpoint(newSettings.getS3Endpoint());
        appSettings.setS3Permission(newSettings.getS3Permission());
        this.storageClient.setEndpoint(newSettings.getS3Endpoint());
        this.storageClient.setStorageName(newSettings.getS3BucketName());
        this.storageClient.setAccessKey(newSettings.getS3AccessKey());
        this.storageClient.setSecretKey(newSettings.getS3SecretKey());
        this.storageClient.setRegion(newSettings.getS3RegionName());
        this.storageClient.setEnabled(newSettings.isS3RecordingEnabled());
        this.storageClient.setPermission(newSettings.getS3Permission());
        this.storageClient.reset();
        appSettings.setForceAspectRatioInTranscoding(newSettings.isForceAspectRatioInTranscoding());
        appSettings.setGeneratePreview(newSettings.isGeneratePreview());
        appSettings.setHlsEncryptionKeyInfoFile(newSettings.getHlsEncryptionKeyInfoFile());
        appSettings.setJwksURL(newSettings.getJwksURL());
        appSettings.setWebhookAuthenticateURL(newSettings.getWebhookAuthenticateURL());
        appSettings.setUpdateTime(System.currentTimeMillis());
        logger.warn("app settings updated for {}", (Object)this.getScope().getName());
    }

    public void setServerSettings(ServerSettings serverSettings) {
        this.serverSettings = serverSettings;
    }

    public RTMPToWebRTCStats getRTMPToWebRTCStats(String streamId) {
        return new RTMPToWebRTCStats(streamId);
    }

    public boolean isDataChannelEnabled() {
        return false;
    }

    public boolean isDataChannelMessagingSupported() {
        return false;
    }

    public boolean sendDataChannelMessage(String streamId, String message) {
        return false;
    }

    public boolean doesWebRTCStreamExist(String streamId) {
        return false;
    }

    public void addPacketListener(String streamId, IPacketListener listener) {
        List<MuxAdaptor> muxAdaptors = this.getMuxAdaptors();
        for (MuxAdaptor muxAdaptor : muxAdaptors) {
            if (!streamId.equals(muxAdaptor.getStreamId())) continue;
            muxAdaptor.addPacketListener(listener);
            break;
        }
    }

    public void removePacketListener(String streamId, IPacketListener listener) {
        for (MuxAdaptor muxAdaptor : this.getMuxAdaptors()) {
            if (!streamId.equals(muxAdaptor.getStreamId())) continue;
            muxAdaptor.removePacketListener(listener);
            break;
        }
    }

    public void addFrameListener(String streamId, IFrameListener listener) {
    }

    public IFrameListener createCustomBroadcast(String streamId) {
        throw new IllegalStateException("This method is not implemented in Community Edition");
    }

    public void stopCustomBroadcast(String streamId) {
    }

    public void removeFrameListener(String streamId, IFrameListener listener) {
    }

    @Override
    public boolean isServerShuttingDown() {
        return this.serverShuttingDown;
    }

    public void setStorageClient(StorageClient storageClient) {
        this.storageClient = storageClient;
    }

    public void addStreamListener(IStreamListener listener) {
        this.streamListeners.add(listener);
    }

    public void removeStreamListener(IStreamListener listener) {
        this.streamListeners.remove(listener);
    }

    public void deleteDBInSeconds() {
        this.vertx.setTimer(5000L, l -> this.getDataStore().delete());
    }

    public boolean stopPlaying(String viewerId) {
        return false;
    }

    @Override
    public void stopPublish(String streamId) {
        this.vertx.executeBlocking(handler -> this.closeBroadcast(streamId), null);
    }

    private static class AuthCheckJob {
        private int count;
        private VideoServiceEndpoint videoServiceEndpoint;
        private int interval;
        private AntMediaApplicationAdapter appAdapter;

        public AuthCheckJob(int count, int interval, VideoServiceEndpoint videoServiceEndpoint, AntMediaApplicationAdapter adapter) {
            this.count = count;
            this.videoServiceEndpoint = videoServiceEndpoint;
            this.interval = interval;
            this.appAdapter = adapter;
        }

        public void execute() {
            try {
                if (!this.videoServiceEndpoint.askIfDeviceAuthenticated()) {
                    ++this.count;
                    if (this.count < 10) {
                        if (this.videoServiceEndpoint.getError() == null) {
                            this.appAdapter.getVertx().setTimer((long)this.interval, l -> new AuthCheckJob(this.count, this.interval, this.videoServiceEndpoint, this.appAdapter).execute());
                            logger.info("Asking authetnication for {}", (Object)this.videoServiceEndpoint.getName());
                        } else {
                            this.appAdapter.getVideoServiceEndpointsHavingError().add(this.videoServiceEndpoint);
                        }
                    } else {
                        this.videoServiceEndpoint.setError("AUTHENTICATION_TIMEOUT");
                        this.appAdapter.getVideoServiceEndpointsHavingError().add(this.videoServiceEndpoint);
                        logger.info("Not authenticated for {} and will not try again", (Object)this.videoServiceEndpoint.getName());
                    }
                } else {
                    logger.info("Authenticated, adding video service endpoint type: {} with id: {} to the app", (Object)this.videoServiceEndpoint.getName(), (Object)this.videoServiceEndpoint.getCredentials().getId());
                    this.appAdapter.getVideoServiceEndpoints().put(this.videoServiceEndpoint.getCredentials().getId(), this.videoServiceEndpoint);
                }
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }
}

