/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class UrlUtils {
    private UrlUtils() {
    }

    public static String urlEncode(String string) {
        if (string == null) {
            return null;
        }
        try {
            return URLEncoder.encode(string, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Platform doesn't support " + StandardCharsets.UTF_8.name(), e);
        }
    }

    public static String urlDecode(String string) {
        if (string == null) {
            return null;
        }
        try {
            return URLDecoder.decode(string, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Platform doesn't support " + StandardCharsets.UTF_8.name(), e);
        }
    }

    public static Map<String, List<String>> extractParametersFromQueryString(String queryString) {
        if (queryString == null) {
            return Collections.emptyMap();
        }
        return UrlUtils.extractParametersFromUrl(String.format("restfb://url%s", queryString.startsWith("?") ? queryString : "?" + queryString));
    }

    public static Map<String, List<String>> extractParametersFromUrl(String url) {
        if (url == null) {
            return Collections.emptyMap();
        }
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        String[] urlParts = url.split("\\?");
        if (urlParts.length > 1) {
            String query = urlParts[1];
            for (String param : query.split("&")) {
                String[] pair = param.split("=");
                String key = UrlUtils.urlDecode(pair[0]);
                String value = "";
                if (pair.length > 1) {
                    value = UrlUtils.urlDecode(pair[1]);
                }
                parameters.computeIfAbsent(key, k -> new ArrayList()).add(value);
            }
        }
        return parameters;
    }

    public static String replaceOrAddQueryParameter(String url, String key, String value) {
        String[] urlParts = url.split("\\?");
        String qParameter = key + "=" + value;
        if (urlParts.length == 2) {
            Map<String, List<String>> paramMap = UrlUtils.extractParametersFromQueryString(urlParts[1]);
            if (paramMap.containsKey(key)) {
                String queryValue = paramMap.get(key).get(0);
                return url.replace(key + "=" + queryValue, qParameter);
            }
            return url + "&" + qParameter;
        }
        return url + "?" + qParameter;
    }

    public static String removeQueryParameter(String url, String key) {
        Map<String, List<String>> paramMap;
        String[] urlParts = url.split("\\?");
        if (urlParts.length == 2 && (paramMap = UrlUtils.extractParametersFromQueryString(urlParts[1])).containsKey(key)) {
            String queryValue = paramMap.get(key).get(0);
            String result = url.replace(key + "=" + queryValue, "");
            if ((result = result.replace("?&", "?").replace("&&", "&")).endsWith("&")) {
                return result.substring(0, result.length() - 1);
            }
            return result;
        }
        return url;
    }
}

