/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.util;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class EncodingUtils {
    private EncodingUtils() {
    }

    public static byte[] decodeBase64(String base64) {
        return Base64.getDecoder().decode(Optional.ofNullable(base64).map(EncodingUtils::padBase64).orElseThrow(() -> new NullPointerException("Parameter 'base64' cannot be null.")));
    }

    private static String padBase64(String base64) {
        String padding = "";
        int remainder = base64.length() % 4;
        if (remainder == 1) {
            padding = "===";
        } else if (remainder == 2) {
            padding = "==";
        } else if (remainder == 3) {
            padding = "=";
        }
        return base64 + padding;
    }

    public static byte[] encodeHex(byte[] data) {
        if (data == null) {
            throw new NullPointerException("Parameter 'data' cannot be null.");
        }
        char[] toDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = toDigits[(0xF0 & data[i]) >>> 4];
            out[j++] = toDigits[0xF & data[i]];
        }
        return new String(out).getBytes(StandardCharsets.UTF_8);
    }

    public static String encodeAppSecretProof(String appSecret, String accessToken) {
        try {
            byte[] key = appSecret.getBytes(StandardCharsets.UTF_8);
            SecretKeySpec signingKey = new SecretKeySpec(key, "HmacSHA256");
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(signingKey);
            byte[] raw = mac.doFinal(accessToken.getBytes());
            byte[] hex = EncodingUtils.encodeHex(raw);
            return new String(hex, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new IllegalStateException("Creation of appsecret_proof has failed", e);
        }
    }
}

