/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.util;

import com.restfb.logging.RestFBLogger;
import com.restfb.util.DateFormatStrategy;
import com.restfb.util.SimpleDateFormatStrategy;
import java.text.ParseException;
import java.util.Date;

public final class DateUtils {
    public static final String FACEBOOK_LONG_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    public static final String FACEBOOK_LONG_DATE_FORMAT_WITHOUT_TIMEZONE = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String FACEBOOK_LONG_DATE_FORMAT_WITHOUT_TIMEZONE_OR_SECONDS = "yyyy-MM-dd'T'HH:mm";
    public static final String FACEBOOK_SHORT_DATE_FORMAT = "MM/dd/yyyy";
    public static final String FACEBOOK_ALTERNATE_SHORT_DATE_FORMAT = "yyyy-MM-dd";
    public static final String FACEBOOK_MONTH_YEAR_DATE_FORMAT = "yyyy-MM";
    private static DateFormatStrategy strategy = new SimpleDateFormatStrategy();

    private DateUtils() {
    }

    public static Date toDateFromLongFormat(String date) {
        if (date == null) {
            return null;
        }
        if (date.trim().matches("\\d+")) {
            return new Date(Long.parseLong(date) * 1000L);
        }
        Date parsedDate = DateUtils.toDateWithFormatString(date, FACEBOOK_LONG_DATE_FORMAT);
        if (parsedDate == null) {
            parsedDate = DateUtils.toDateWithFormatString(date, FACEBOOK_LONG_DATE_FORMAT_WITHOUT_TIMEZONE);
        }
        if (parsedDate == null) {
            parsedDate = DateUtils.toDateWithFormatString(date, FACEBOOK_LONG_DATE_FORMAT_WITHOUT_TIMEZONE_OR_SECONDS);
        }
        return parsedDate;
    }

    public static Date toDateFromShortFormat(String date) {
        if (date == null) {
            return null;
        }
        Date parsedDate = DateUtils.toDateWithFormatString(date, FACEBOOK_SHORT_DATE_FORMAT);
        if (parsedDate == null) {
            parsedDate = DateUtils.toDateWithFormatString(date, FACEBOOK_ALTERNATE_SHORT_DATE_FORMAT);
        }
        return parsedDate;
    }

    public static Date toDateFromMonthYearFormat(String date) {
        if (date == null) {
            return null;
        }
        if ("0000-00".equals(date)) {
            return null;
        }
        return DateUtils.toDateWithFormatString(date, FACEBOOK_MONTH_YEAR_DATE_FORMAT);
    }

    public static String toLongFormatFromDate(Date date) {
        if (date == null) {
            return null;
        }
        return strategy.formatFor(FACEBOOK_LONG_DATE_FORMAT_WITHOUT_TIMEZONE).format(date);
    }

    public static String toShortFormatFromDate(Date date) {
        if (date == null) {
            return null;
        }
        return strategy.formatFor(FACEBOOK_ALTERNATE_SHORT_DATE_FORMAT).format(date);
    }

    private static Date toDateWithFormatString(String date, String format) {
        if (date == null) {
            return null;
        }
        try {
            return strategy.formatFor(format).parse(date);
        }
        catch (ParseException e) {
            RestFBLogger.UTILS_LOGGER.trace("Unable to parse date '{}' using format string '{}': {}", date, format, e);
            return null;
        }
    }

    public static DateFormatStrategy getDateFormatStrategy() {
        return strategy;
    }

    public static void setDateFormatStrategy(DateFormatStrategy dateFormatStrategy) {
        strategy = dateFormatStrategy;
    }
}

