/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.util;

import com.restfb.util.DateFormatStrategy;
import java.lang.ref.SoftReference;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.TimeZone;

public class CachedDateFormatStrategy
implements DateFormatStrategy {
    @Override
    public DateFormat formatFor(String format) {
        return SimpleDateFormatHolder.formatFor(format);
    }

    public void clearThreadLocal() {
        SimpleDateFormatHolder.clearThreadLocal();
    }

    private static final class SimpleDateFormatHolder {
        private static final ThreadLocal<SoftReference> THREADLOCAL_FORMATTER_MAP = ThreadLocal.withInitial(() -> new SoftReference(new HashMap()));

        private SimpleDateFormatHolder() {
        }

        private static SimpleDateFormat formatFor(String pattern) {
            SoftReference ref = THREADLOCAL_FORMATTER_MAP.get();
            HashMap<String, SimpleDateFormat> formatterMap = (HashMap<String, SimpleDateFormat>)ref.get();
            if (formatterMap == null) {
                formatterMap = new HashMap<String, SimpleDateFormat>();
                THREADLOCAL_FORMATTER_MAP.set(new SoftReference(formatterMap));
            }
            return formatterMap.computeIfAbsent(pattern, key -> SimpleDateFormatHolder.createSDF(key));
        }

        private static SimpleDateFormat createSDF(String pattern) {
            SimpleDateFormat sdf = new SimpleDateFormat(pattern);
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            return sdf;
        }

        private static void clearThreadLocal() {
            THREADLOCAL_FORMATTER_MAP.remove();
        }
    }
}

