/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.types.webhook.messaging;

import com.restfb.Facebook;
import com.restfb.JsonMapper;
import com.restfb.types.webhook.messaging.MessagingPayload;

public class MessagingAttachment {
    public static final String AUDIO = "audio";
    public static final String FALLBACK = "fallback";
    public static final String FILE = "file";
    public static final String IMAGE = "image";
    public static final String LOCATION = "location";
    public static final String VIDEO = "video";
    @Facebook
    private String type;
    @Facebook
    private String title;
    @Facebook
    private String url;
    @Facebook(value="payload")
    private String fallbackPayload;
    @Facebook
    private MessagingPayload payload;

    @JsonMapper.JsonMappingCompleted
    private void selectPayload() {
        if (this.payload == null) {
            this.payload = new MessagingPayload();
            this.payload.setFallback(this.fallbackPayload);
        }
    }

    public boolean isAudio() {
        return AUDIO.equals(this.type);
    }

    public boolean isFallback() {
        return FALLBACK.equals(this.type);
    }

    public boolean isFile() {
        return FILE.equals(this.type);
    }

    public boolean isImage() {
        return IMAGE.equals(this.type);
    }

    public boolean isLocation() {
        return LOCATION.equals(this.type);
    }

    public boolean isVideo() {
        return VIDEO.equals(this.type);
    }

    public String toString() {
        return "MessagingAttachment(type=" + this.getType() + ", title=" + this.getTitle() + ", url=" + this.getUrl() + ", fallbackPayload=" + this.fallbackPayload + ", payload=" + this.getPayload() + ")";
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public MessagingPayload getPayload() {
        return this.payload;
    }

    public void setPayload(MessagingPayload payload) {
        this.payload = payload;
    }
}

