/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.types.send.media;

import com.restfb.Facebook;
import com.restfb.types.AbstractFacebookType;
import com.restfb.types.send.MediaAttachment;
import com.restfb.types.send.WebButton;
import java.util.ArrayList;
import java.util.List;

public class MediaTemplateUrlElement
extends AbstractFacebookType
implements MediaAttachment.MediaTemplateElement {
    @Facebook(value="media_type")
    private String mediaType;
    @Facebook
    private String url;
    @Facebook
    private List<WebButton> buttons;

    public MediaTemplateUrlElement(String url) {
        if (!this.validUrl(url)) {
            throw new IllegalArgumentException("The given URL is not valid");
        }
        this.url = url;
        this.mediaType = url.contains("/videos/") ? MediaAttachment.MediaType.VIDEO.name().toLowerCase() : MediaAttachment.MediaType.IMAGE.name().toLowerCase();
    }

    @Override
    public void addButton(WebButton button) {
        if (this.buttons == null) {
            this.buttons = new ArrayList<WebButton>();
        }
        this.buttons.add(button);
    }

    private boolean validUrl(String url) {
        if (url == null) {
            throw new IllegalArgumentException("The media URL may not be null");
        }
        if (url.startsWith("https://business.facebook.com/")) {
            return true;
        }
        return url.startsWith("https://www.facebook.com/");
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public String getUrl() {
        return this.url;
    }

    public List<WebButton> getButtons() {
        return this.buttons;
    }
}

