/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.types.send;

import com.restfb.Facebook;
import com.restfb.types.send.ReceiptAddress;
import com.restfb.types.send.ReceiptAdjustment;
import com.restfb.types.send.ReceiptElement;
import com.restfb.types.send.ReceiptSummary;
import com.restfb.types.send.SharableTemplatePayload;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ReceiptTemplatePayload
extends SharableTemplatePayload {
    @Facebook(value="recipient_name")
    private String recipientName;
    @Facebook(value="order_number")
    private String orderNumber;
    @Facebook
    private String currency;
    @Facebook(value="merchant_name")
    private String merchantName;
    @Facebook(value="payment_method")
    private String paymentMethod;
    @Facebook(value="order_url")
    private String orderUrl;
    @Facebook
    private Long timestamp;
    @Facebook
    private List<ReceiptElement> elements;
    @Facebook
    private ReceiptAddress address;
    @Facebook
    private ReceiptSummary summary;
    @Facebook
    private List<ReceiptAdjustment> adjustments;

    public ReceiptTemplatePayload(String recipientName, String orderNumber, String currency, String paymentMethod, ReceiptSummary summary) {
        this.recipientName = recipientName;
        this.orderNumber = orderNumber;
        this.currency = currency;
        this.paymentMethod = paymentMethod;
        this.summary = summary;
        this.setTemplateType("receipt");
    }

    public boolean addElement(ReceiptElement element) {
        if (this.elements == null) {
            this.elements = new ArrayList<ReceiptElement>();
        }
        return this.elements.add(element);
    }

    public boolean addAdjustment(ReceiptAdjustment adjustment) {
        if (this.adjustments == null) {
            this.adjustments = new ArrayList<ReceiptAdjustment>();
        }
        return this.adjustments.add(adjustment);
    }

    public List<ReceiptElement> getElements() {
        return Collections.unmodifiableList(this.elements);
    }

    public List<ReceiptAdjustment> getAdjustments() {
        return Collections.unmodifiableList(this.adjustments);
    }

    public String getRecipientName() {
        return this.recipientName;
    }

    public String getOrderNumber() {
        return this.orderNumber;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getMerchantName() {
        return this.merchantName;
    }

    public void setMerchantName(String merchantName) {
        this.merchantName = merchantName;
    }

    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    public String getOrderUrl() {
        return this.orderUrl;
    }

    public void setOrderUrl(String orderUrl) {
        this.orderUrl = orderUrl;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public ReceiptAddress getAddress() {
        return this.address;
    }

    public void setAddress(ReceiptAddress address) {
        this.address = address;
    }

    public ReceiptSummary getSummary() {
        return this.summary;
    }
}

