/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.types.send;

import com.restfb.Facebook;
import com.restfb.types.AbstractFacebookType;
import com.restfb.types.send.MessageAttachment;
import com.restfb.types.send.WebButton;
import java.io.Serializable;
import java.util.List;

public class MediaAttachment
extends MessageAttachment {
    @Facebook
    private MediaAttachmentPayload payload;

    public MediaAttachment(Type type, String imageUrl) {
        this.setType(type.toString().toLowerCase());
        this.payload = imageUrl.matches("^\\d+$") ? new ReuseIdPayload(imageUrl) : new UrlPayload(imageUrl);
    }

    public MediaAttachment(List<MediaTemplateElement> elements) {
        this.setType(Type.TEMPLATE.toString().toLowerCase());
        this.payload = new MediaTemplatePayload(elements);
    }

    public void setIsReusable(boolean isReusable) {
        this.payload.setIsReusable(isReusable);
    }

    public MediaAttachmentPayload getPayload() {
        return this.payload;
    }

    public static enum MediaType {
        IMAGE,
        VIDEO;

    }

    public static enum Type {
        IMAGE,
        VIDEO,
        AUDIO,
        FILE,
        TEMPLATE;

    }

    public static interface MediaTemplateElement
    extends Serializable {
        public void addButton(WebButton var1);
    }

    private static interface MediaAttachmentPayload
    extends Serializable {
        public void setIsReusable(boolean var1);
    }

    private static class MediaTemplatePayload
    extends AbstractFacebookType
    implements MediaAttachmentPayload {
        @Facebook(value="template_type")
        private String templateType = "media";
        @Facebook
        private List<MediaTemplateElement> elements;

        public MediaTemplatePayload(List<MediaTemplateElement> elements) {
            this.elements = elements;
        }

        @Override
        public void setIsReusable(boolean isReusable) {
        }

        public String getTemplateType() {
            return this.templateType;
        }
    }

    private static class ReuseIdPayload
    extends AbstractFacebookType
    implements MediaAttachmentPayload {
        @Facebook(value="attachment_id")
        private String attachmentId;

        public ReuseIdPayload(String urlString) {
            this.attachmentId = urlString;
        }

        @Override
        public void setIsReusable(boolean isReusable) {
        }

        public String getAttachmentId() {
            return this.attachmentId;
        }
    }

    private static class UrlPayload
    extends AbstractFacebookType
    implements MediaAttachmentPayload {
        @Facebook
        private String url;
        @Facebook(value="is_reusable")
        private Boolean isReusable;

        public UrlPayload(String urlString) {
            this.url = urlString;
        }

        @Override
        public void setIsReusable(boolean isReusable) {
            this.isReusable = isReusable;
        }

        public String getUrl() {
            return this.url;
        }

        public Boolean getIsReusable() {
            return this.isReusable;
        }
    }
}

