/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.types.send;

import com.restfb.Facebook;
import com.restfb.annotation.GraphAPI;
import com.restfb.exception.FacebookPreconditionException;
import com.restfb.types.send.AbstractButton;
import com.restfb.types.send.IsBroadcastPayload;
import com.restfb.types.send.ListViewElement;
import com.restfb.types.send.SharableTemplatePayload;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Deprecated
@GraphAPI(until="4.0")
public class ListTemplatePayload
extends SharableTemplatePayload
implements IsBroadcastPayload {
    @Facebook
    private List<ListViewElement> elements;
    @Facebook(value="top_element_style")
    private TopElementStyleEnum topElementStyle;
    @Facebook
    private List<AbstractButton> buttons;

    public ListTemplatePayload(List<ListViewElement> listViewElements) {
        this.setTemplateType("list");
        if (listViewElements == null) {
            throw new FacebookPreconditionException("List of elements may not be 'null'");
        }
        if (listViewElements.isEmpty() || listViewElements.size() < 2) {
            throw new FacebookPreconditionException("List of elements needs to contain a minimum of 2");
        }
        if (listViewElements.size() > 4) {
            throw new FacebookPreconditionException("List of elements can contain a maximum of 4 elements");
        }
        this.elements = Collections.unmodifiableList(listViewElements);
    }

    public boolean addButton(AbstractButton button) {
        if (this.buttons == null) {
            this.buttons = new ArrayList<AbstractButton>();
        }
        if (this.buttons.size() == 1) {
            throw new FacebookPreconditionException("maximum of associated buttons is 1");
        }
        return this.buttons.add(button);
    }

    public List<AbstractButton> getButtons() {
        return Collections.unmodifiableList(this.buttons);
    }

    public List<ListViewElement> getElements() {
        return Collections.unmodifiableList(this.elements);
    }

    public TopElementStyleEnum getTopElementStyle() {
        return this.topElementStyle;
    }

    public void setTopElementStyle(TopElementStyleEnum topElementStyle) {
        this.topElementStyle = topElementStyle;
    }

    public static enum TopElementStyleEnum {
        large,
        compact;

    }
}

