/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.types;

import com.restfb.Facebook;
import com.restfb.JsonMapper;
import com.restfb.annotation.GraphAPI;
import com.restfb.types.AbstractFacebookType;
import com.restfb.types.CoverPhoto;
import com.restfb.types.FacebookType;
import com.restfb.types.Likes;
import com.restfb.types.NamedFacebookType;
import com.restfb.types.PageLabel;
import com.restfb.types.ProfilePictureSource;
import com.restfb.types.UserIDForApp;
import com.restfb.types.UserIDForPage;
import com.restfb.types.UserInvitableFriend;
import com.restfb.types.WorkExperience;
import com.restfb.util.DateUtils;
import com.restfb.util.MappingUtils;
import com.restfb.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class User
extends NamedFacebookType {
    @Facebook
    private FacebookType context;
    @Facebook(value="first_name")
    private String firstName;
    @Facebook(value="middle_name")
    private String middleName;
    @Facebook(value="name_format")
    private String nameFormat;
    @Facebook(value="payment_pricepoints")
    private PaymentPricepoints paymentPricepoints;
    @Facebook(value="last_name")
    private String lastName;
    @Facebook(value="short_name")
    @GraphAPI(since="2.9")
    private String shortName;
    @Facebook
    private CoverPhoto cover;
    @Facebook
    private String link;
    @Facebook
    @GraphAPI(until="2.7")
    private String bio;
    @Facebook
    private String quotes;
    @Facebook
    @Deprecated
    private String about;
    @Facebook(value="relationship_status")
    @Deprecated
    private String relationshipStatus;
    @Facebook
    @Deprecated
    private String religion;
    @Facebook(value="age_range")
    private AgeRange ageRange;
    @Facebook
    @Deprecated
    private String website;
    @Facebook
    private String birthday;
    @Facebook
    private String email;
    @Facebook
    private Double timezone;
    @Facebook
    private Boolean verified;
    @Facebook(value="video_upload_limits")
    private VideoUploadLimits videoUploadLimits;
    @Facebook(value="viewer_can_send_gift")
    private Boolean viewerCanSendGift;
    @Facebook
    private String gender;
    @Facebook
    @Deprecated
    private String political;
    @Facebook
    private String locale;
    @Deprecated
    @Facebook
    private String username;
    @Facebook(value="public_key")
    private String publicKey;
    @Facebook
    private Likes likes;
    @Facebook(value="picture")
    private transient String rawPicture;
    private ProfilePictureSource picture;
    @Facebook
    private NamedFacebookType hometown;
    @Facebook(value="hometown")
    private String hometownAsString;
    @Facebook
    private NamedFacebookType location;
    @Facebook(value="security_settings")
    private SecuritySettings securitySettings;
    @Facebook(value="shared_login_upgrade_required_by")
    private Date sharedLoginUpgradeRequiredBy;
    @Facebook(value="significant_other")
    private NamedFacebookType significantOther;
    @Facebook(value="test_group")
    private Long testGroup;
    @Facebook(value="updated_time")
    private Date updatedTime;
    @Facebook(value="third_party_id")
    private String thirdPartyId;
    @Facebook
    private Currency currency;
    @Facebook(value="token_for_business")
    private String tokenForBusiness;
    @Facebook(value="install_type")
    private String installType;
    @Facebook
    private Boolean installed;
    @Facebook(value="is_shared_login")
    private Boolean isSharedLogin;
    @Facebook(value="is_verified")
    private Boolean isVerified;
    @Deprecated
    @Facebook(value="interested_in")
    private List<String> interestedIn = new ArrayList<String>();
    @Facebook(value="meeting_for")
    private List<String> meetingFor = new ArrayList<String>();
    @Facebook
    private List<UserDevice> devices = new ArrayList<UserDevice>();
    @Facebook
    @Deprecated
    private List<WorkExperience> work = new ArrayList<WorkExperience>();
    @Facebook
    @Deprecated
    private List<Education> education = new ArrayList<Education>();
    @Facebook
    private List<Sport> sports = new ArrayList<Sport>();
    @Facebook(value="favorite_teams")
    private List<Experience> favoriteTeams = new ArrayList<Experience>();
    @Facebook(value="favorite_athletes")
    private List<Experience> favoriteAthletes = new ArrayList<Experience>();
    @Facebook(value="inspirational_people")
    private List<Experience> inspirationalPeople = new ArrayList<Experience>();
    @Facebook
    private List<Experience> languages = new ArrayList<Experience>();
    @Facebook
    private List<PageLabel> labels = new ArrayList<PageLabel>();
    @Facebook(value="ids_for_apps")
    private List<UserIDForApp> idsForApps = new ArrayList<UserIDForApp>();
    @Facebook(value="ids_for_business")
    private List<UserIDForApp> idsForBusiness = new ArrayList<UserIDForApp>();
    @Facebook(value="ids_for_pages")
    private List<UserIDForPage> idsForPages = new ArrayList<UserIDForPage>();
    @Facebook(value="invitable_friends")
    private List<UserInvitableFriend> invitableFriends = new ArrayList<UserInvitableFriend>();
    private static final long serialVersionUID = 1L;

    public Date getBirthdayAsDate() {
        if (StringUtils.isBlank(this.getBirthday()) || this.getBirthday().split("/").length < 2) {
            return null;
        }
        return DateUtils.toDateFromShortFormat(this.birthday);
    }

    @JsonMapper.JsonMappingCompleted
    protected void jsonMappingCompleted(JsonMapper jsonMapper) {
        MappingUtils mappingUtils = new MappingUtils(jsonMapper);
        this.picture = mappingUtils.convertPicture(this.rawPicture);
    }

    public String getHometownName() {
        if (this.getHometown() != null) {
            return this.getHometown().getName();
        }
        return this.hometownAsString;
    }

    public List<UserIDForApp> getIdsForApps() {
        return Collections.unmodifiableList(this.idsForApps);
    }

    public boolean addIdsForApps(UserIDForApp userId) {
        return this.idsForApps.add(userId);
    }

    public boolean removeIdsForApps(UserIDForApp userId) {
        return this.idsForApps.remove(userId);
    }

    public List<UserIDForApp> getIdsForBusiness() {
        return Collections.unmodifiableList(this.idsForBusiness);
    }

    public boolean addIdsForBusiness(UserIDForApp userId) {
        return this.idsForBusiness.add(userId);
    }

    public boolean removeIdsForBusiness(UserIDForApp userId) {
        return this.idsForBusiness.remove(userId);
    }

    public List<UserIDForPage> getIdsForPages() {
        return Collections.unmodifiableList(this.idsForPages);
    }

    public boolean addIdsForPages(UserIDForPage userId) {
        return this.idsForPages.add(userId);
    }

    public boolean removeIdsForPages(UserIDForPage userId) {
        return this.idsForPages.remove(userId);
    }

    @Deprecated
    public List<String> getInterestedIn() {
        return Collections.unmodifiableList(this.interestedIn);
    }

    @Deprecated
    public boolean addInterestedIn(String gender) {
        return this.interestedIn.add(gender);
    }

    @Deprecated
    public boolean removeInterestedIn(String gender) {
        return this.interestedIn.remove(gender);
    }

    public List<String> getMeetingFor() {
        return Collections.unmodifiableList(this.meetingFor);
    }

    public boolean addMeetingFor(String gender) {
        return this.meetingFor.add(gender);
    }

    public boolean removeMeetingFor(String gender) {
        return this.meetingFor.remove(gender);
    }

    @Deprecated
    public List<WorkExperience> getWork() {
        return Collections.unmodifiableList(this.work);
    }

    @Deprecated
    public boolean addWork(WorkExperience workHistoryItem) {
        return this.work.add(workHistoryItem);
    }

    @Deprecated
    public boolean removeWork(WorkExperience workHistoryItem) {
        return this.work.remove(workHistoryItem);
    }

    public List<UserDevice> getDevices() {
        return Collections.unmodifiableList(this.devices);
    }

    public boolean addDevice(UserDevice device) {
        return this.devices.add(device);
    }

    public boolean removeDevice(UserDevice device) {
        return this.devices.remove(device);
    }

    @Deprecated
    public List<Education> getEducation() {
        return Collections.unmodifiableList(this.education);
    }

    @Deprecated
    public boolean addEducation(Education educationHistoryItem) {
        return this.education.add(educationHistoryItem);
    }

    @Deprecated
    public boolean removeEducation(Education educationHistoryItem) {
        return this.education.remove(educationHistoryItem);
    }

    public List<Sport> getSports() {
        return Collections.unmodifiableList(this.sports);
    }

    public boolean addSport(Sport sportItem) {
        return this.sports.add(sportItem);
    }

    public boolean removeSport(Sport sportItem) {
        return this.sports.remove(sportItem);
    }

    public List<Experience> getFavoriteTeams() {
        return Collections.unmodifiableList(this.favoriteTeams);
    }

    public boolean addFavoriteTeam(Experience team) {
        return this.favoriteTeams.add(team);
    }

    public boolean removeFavoriteTeam(Experience team) {
        return this.favoriteTeams.remove(team);
    }

    public List<Experience> getFavoriteAthletes() {
        return Collections.unmodifiableList(this.favoriteAthletes);
    }

    public boolean addFavoriteAthlete(Experience athlet) {
        return this.favoriteAthletes.add(athlet);
    }

    public boolean removeFavoriteAthlete(Experience athlet) {
        return this.favoriteAthletes.remove(athlet);
    }

    public List<Experience> getInspirationalPeople() {
        return Collections.unmodifiableList(this.inspirationalPeople);
    }

    public boolean addInspirationalPeople(Experience person) {
        return this.inspirationalPeople.add(person);
    }

    public boolean removeInspirationalPeople(Experience person) {
        return this.inspirationalPeople.remove(person);
    }

    public List<Experience> getLanguages() {
        return Collections.unmodifiableList(this.languages);
    }

    public boolean addLanguage(Experience language) {
        return this.languages.add(language);
    }

    public boolean removeLanguage(Experience language) {
        return this.languages.remove(language);
    }

    @GraphAPI(since="2.6")
    public List<PageLabel> getLabels() {
        return Collections.unmodifiableList(this.labels);
    }

    public boolean addLabel(PageLabel label) {
        return this.labels.add(label);
    }

    public boolean removeLabels(PageLabel label) {
        return this.labels.remove(label);
    }

    public List<UserInvitableFriend> getInvitableFriends() {
        return Collections.unmodifiableList(this.invitableFriends);
    }

    public boolean addInvitableFriend(UserInvitableFriend friend) {
        return this.invitableFriends.add(friend);
    }

    public boolean removeInvitableFriend(UserInvitableFriend friend) {
        return this.invitableFriends.remove(friend);
    }

    public FacebookType getContext() {
        return this.context;
    }

    public void setContext(FacebookType context) {
        this.context = context;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public String getNameFormat() {
        return this.nameFormat;
    }

    public void setNameFormat(String nameFormat) {
        this.nameFormat = nameFormat;
    }

    public PaymentPricepoints getPaymentPricepoints() {
        return this.paymentPricepoints;
    }

    public void setPaymentPricepoints(PaymentPricepoints paymentPricepoints) {
        this.paymentPricepoints = paymentPricepoints;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @GraphAPI(since="2.9")
    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public CoverPhoto getCover() {
        return this.cover;
    }

    public void setCover(CoverPhoto cover) {
        this.cover = cover;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    @GraphAPI(until="2.7")
    public String getBio() {
        return this.bio;
    }

    public void setBio(String bio) {
        this.bio = bio;
    }

    public String getQuotes() {
        return this.quotes;
    }

    public void setQuotes(String quotes) {
        this.quotes = quotes;
    }

    @Deprecated
    public String getAbout() {
        return this.about;
    }

    @Deprecated
    public void setAbout(String about) {
        this.about = about;
    }

    @Deprecated
    public String getRelationshipStatus() {
        return this.relationshipStatus;
    }

    @Deprecated
    public void setRelationshipStatus(String relationshipStatus) {
        this.relationshipStatus = relationshipStatus;
    }

    @Deprecated
    public String getReligion() {
        return this.religion;
    }

    @Deprecated
    public void setReligion(String religion) {
        this.religion = religion;
    }

    public AgeRange getAgeRange() {
        return this.ageRange;
    }

    public void setAgeRange(AgeRange ageRange) {
        this.ageRange = ageRange;
    }

    @Deprecated
    public String getWebsite() {
        return this.website;
    }

    @Deprecated
    public void setWebsite(String website) {
        this.website = website;
    }

    public String getBirthday() {
        return this.birthday;
    }

    public void setBirthday(String birthday) {
        this.birthday = birthday;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Double getTimezone() {
        return this.timezone;
    }

    public void setTimezone(Double timezone) {
        this.timezone = timezone;
    }

    public Boolean getVerified() {
        return this.verified;
    }

    public void setVerified(Boolean verified) {
        this.verified = verified;
    }

    public VideoUploadLimits getVideoUploadLimits() {
        return this.videoUploadLimits;
    }

    public void setVideoUploadLimits(VideoUploadLimits videoUploadLimits) {
        this.videoUploadLimits = videoUploadLimits;
    }

    public Boolean getViewerCanSendGift() {
        return this.viewerCanSendGift;
    }

    public void setViewerCanSendGift(Boolean viewerCanSendGift) {
        this.viewerCanSendGift = viewerCanSendGift;
    }

    public String getGender() {
        return this.gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    @Deprecated
    public String getPolitical() {
        return this.political;
    }

    @Deprecated
    public void setPolitical(String political) {
        this.political = political;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    @Deprecated
    public String getUsername() {
        return this.username;
    }

    @Deprecated
    public void setUsername(String username) {
        this.username = username;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public Likes getLikes() {
        return this.likes;
    }

    public void setLikes(Likes likes) {
        this.likes = likes;
    }

    public ProfilePictureSource getPicture() {
        return this.picture;
    }

    public void setPicture(ProfilePictureSource picture) {
        this.picture = picture;
    }

    public NamedFacebookType getHometown() {
        return this.hometown;
    }

    public void setHometown(NamedFacebookType hometown) {
        this.hometown = hometown;
    }

    public NamedFacebookType getLocation() {
        return this.location;
    }

    public void setLocation(NamedFacebookType location) {
        this.location = location;
    }

    public SecuritySettings getSecuritySettings() {
        return this.securitySettings;
    }

    public void setSecuritySettings(SecuritySettings securitySettings) {
        this.securitySettings = securitySettings;
    }

    public Date getSharedLoginUpgradeRequiredBy() {
        return this.sharedLoginUpgradeRequiredBy;
    }

    public void setSharedLoginUpgradeRequiredBy(Date sharedLoginUpgradeRequiredBy) {
        this.sharedLoginUpgradeRequiredBy = sharedLoginUpgradeRequiredBy;
    }

    public NamedFacebookType getSignificantOther() {
        return this.significantOther;
    }

    public void setSignificantOther(NamedFacebookType significantOther) {
        this.significantOther = significantOther;
    }

    public Long getTestGroup() {
        return this.testGroup;
    }

    public void setTestGroup(Long testGroup) {
        this.testGroup = testGroup;
    }

    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    public void setUpdatedTime(Date updatedTime) {
        this.updatedTime = updatedTime;
    }

    public String getThirdPartyId() {
        return this.thirdPartyId;
    }

    public void setThirdPartyId(String thirdPartyId) {
        this.thirdPartyId = thirdPartyId;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public String getTokenForBusiness() {
        return this.tokenForBusiness;
    }

    public void setTokenForBusiness(String tokenForBusiness) {
        this.tokenForBusiness = tokenForBusiness;
    }

    public String getInstallType() {
        return this.installType;
    }

    public void setInstallType(String installType) {
        this.installType = installType;
    }

    public Boolean getInstalled() {
        return this.installed;
    }

    public void setInstalled(Boolean installed) {
        this.installed = installed;
    }

    public Boolean getIsSharedLogin() {
        return this.isSharedLogin;
    }

    public void setIsSharedLogin(Boolean isSharedLogin) {
        this.isSharedLogin = isSharedLogin;
    }

    public Boolean getIsVerified() {
        return this.isVerified;
    }

    public void setIsVerified(Boolean isVerified) {
        this.isVerified = isVerified;
    }

    public static class Experience
    extends NamedFacebookType {
        @Facebook
        private String description;
        @Facebook
        private User from;
        @Facebook
        private List<User> with = new ArrayList<User>();

        public List<User> getWith() {
            return Collections.unmodifiableList(this.with);
        }

        public boolean addWith(User with) {
            return this.with.add(with);
        }

        public boolean removeWith(User with) {
            return this.with.remove(with);
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public User getFrom() {
            return this.from;
        }

        public void setFrom(User from) {
            this.from = from;
        }
    }

    public static class VideoUploadLimits
    extends AbstractFacebookType {
        @Facebook
        private Long length;
        @Facebook
        private Long size;

        public Long getLength() {
            return this.length;
        }

        public void setLength(Long length) {
            this.length = length;
        }

        public Long getSize() {
            return this.size;
        }

        public void setSize(Long size) {
            this.size = size;
        }
    }

    public static class PaymentPricepoint
    extends AbstractFacebookType {
        @Facebook
        private Double credits;
        @Facebook(value="local_currency")
        private String localCurrency;
        @Facebook(value="user_price")
        private String userPrice;

        public Double getCredits() {
            return this.credits;
        }

        public void setCredits(Double credits) {
            this.credits = credits;
        }

        public String getLocalCurrency() {
            return this.localCurrency;
        }

        public void setLocalCurrency(String localCurrency) {
            this.localCurrency = localCurrency;
        }

        public String getUserPrice() {
            return this.userPrice;
        }

        public void setUserPrice(String userPrice) {
            this.userPrice = userPrice;
        }
    }

    public static class PaymentPricepoints
    extends AbstractFacebookType {
        @Facebook
        private List<PaymentPricepoint> mobile = new ArrayList<PaymentPricepoint>();

        public List<PaymentPricepoint> getMobile() {
            return Collections.unmodifiableList(this.mobile);
        }

        public boolean addMobile(PaymentPricepoint language) {
            return this.mobile.add(language);
        }

        public boolean removeMobile(PaymentPricepoint language) {
            return this.mobile.remove(language);
        }
    }

    public static class SecureBrowsing
    extends AbstractFacebookType {
        @Facebook
        private Boolean enabled;

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }
    }

    public static class SecuritySettings
    extends AbstractFacebookType {
        @Facebook(value="secure_browsing")
        private SecureBrowsing secureBrowsing;

        public SecureBrowsing getSecureBrowsing() {
            return this.secureBrowsing;
        }

        public void setSecureBrowsing(SecureBrowsing secureBrowsing) {
            this.secureBrowsing = secureBrowsing;
        }
    }

    public static class AgeRange
    extends AbstractFacebookType {
        private static final long serialVersionUID = 1L;
        @Facebook
        private Integer min;
        @Facebook
        private Integer max;

        public Integer getMin() {
            return this.min;
        }

        public void setMin(Integer min) {
            this.min = min;
        }

        public Integer getMax() {
            return this.max;
        }

        public void setMax(Integer max) {
            this.max = max;
        }
    }

    public static class UserDevice
    extends AbstractFacebookType {
        private static final long serialVersionUID = 1L;
        @Facebook
        private String hardware;
        @Facebook
        private String os;

        public String getHardware() {
            return this.hardware;
        }

        public void setHardware(String hardware) {
            this.hardware = hardware;
        }

        public String getOs() {
            return this.os;
        }

        public void setOs(String os) {
            this.os = os;
        }
    }

    public static class Currency
    extends AbstractFacebookType {
        @Facebook(value="user_currency")
        private String userCurrency;
        @Facebook(value="currency_exchange")
        private BigDecimal currencyExchange;
        @Facebook(value="currency_exchange_inverse")
        private BigDecimal currencyExchangeInverse;
        @Facebook(value="currency_offset")
        private BigDecimal currencyOffset;
        private static final long serialVersionUID = 1L;

        public String getUserCurrency() {
            return this.userCurrency;
        }

        public void setUserCurrency(String userCurrency) {
            this.userCurrency = userCurrency;
        }

        public BigDecimal getCurrencyExchange() {
            return this.currencyExchange;
        }

        public void setCurrencyExchange(BigDecimal currencyExchange) {
            this.currencyExchange = currencyExchange;
        }

        public BigDecimal getCurrencyExchangeInverse() {
            return this.currencyExchangeInverse;
        }

        public void setCurrencyExchangeInverse(BigDecimal currencyExchangeInverse) {
            this.currencyExchangeInverse = currencyExchangeInverse;
        }

        public BigDecimal getCurrencyOffset() {
            return this.currencyOffset;
        }

        public void setCurrencyOffset(BigDecimal currencyOffset) {
            this.currencyOffset = currencyOffset;
        }
    }

    public static class Sport
    extends NamedFacebookType {
        @Facebook
        private List<NamedFacebookType> with = new ArrayList<NamedFacebookType>();
        private static final long serialVersionUID = 1L;

        public List<NamedFacebookType> getWith() {
            return Collections.unmodifiableList(this.with);
        }

        public boolean addWith(NamedFacebookType withSport) {
            return this.with.add(withSport);
        }

        public boolean removeWith(NamedFacebookType withSport) {
            return this.with.remove(withSport);
        }
    }

    public static class EducationClass
    extends NamedFacebookType {
        @Facebook
        private List<NamedFacebookType> with = new ArrayList<NamedFacebookType>();
        @Facebook
        private String description;
        private static final long serialVersionUID = 1L;

        public List<NamedFacebookType> getWith() {
            return Collections.unmodifiableList(this.with);
        }

        public boolean addWith(NamedFacebookType friend) {
            return this.with.add(friend);
        }

        public boolean removeWith(NamedFacebookType friend) {
            return this.with.remove(friend);
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }

    @Deprecated
    public static class Education
    extends AbstractFacebookType {
        @Facebook
        private NamedFacebookType school;
        @Facebook
        private NamedFacebookType year;
        @Facebook(value="year")
        private String yearAsString;
        @Facebook
        private NamedFacebookType degree;
        @Facebook
        private String type;
        @Facebook
        private List<NamedFacebookType> concentration = new ArrayList<NamedFacebookType>();
        @Facebook
        private List<NamedFacebookType> with = new ArrayList<NamedFacebookType>();
        @Facebook
        private List<EducationClass> classes = new ArrayList<EducationClass>();
        private static final long serialVersionUID = 2L;

        public List<NamedFacebookType> getConcentration() {
            return Collections.unmodifiableList(this.concentration);
        }

        public boolean addConcentration(NamedFacebookType minor) {
            return this.concentration.add(minor);
        }

        public boolean removeConcentration(NamedFacebookType minor) {
            return this.concentration.remove(minor);
        }

        public List<NamedFacebookType> getWith() {
            return Collections.unmodifiableList(this.with);
        }

        public boolean addWith(NamedFacebookType friend) {
            return this.with.add(friend);
        }

        public boolean removeWith(NamedFacebookType friend) {
            return this.with.remove(friend);
        }

        public List<EducationClass> getClasses() {
            return Collections.unmodifiableList(this.classes);
        }

        public boolean addClasses(EducationClass eduClass) {
            return this.classes.add(eduClass);
        }

        public boolean removeClasses(EducationClass eduClass) {
            return this.classes.remove(eduClass);
        }

        public NamedFacebookType getSchool() {
            return this.school;
        }

        public void setSchool(NamedFacebookType school) {
            this.school = school;
        }

        public NamedFacebookType getYear() {
            return this.year;
        }

        public void setYear(NamedFacebookType year) {
            this.year = year;
        }

        public String getYearAsString() {
            return this.yearAsString;
        }

        public void setYearAsString(String yearAsString) {
            this.yearAsString = yearAsString;
        }

        public NamedFacebookType getDegree() {
            return this.degree;
        }

        public void setDegree(NamedFacebookType degree) {
            this.degree = degree;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }
}

