/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.types;

import com.restfb.Facebook;
import com.restfb.JsonMapper;
import com.restfb.json.Json;
import com.restfb.json.JsonObject;
import com.restfb.types.AbstractFacebookType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Reactions
extends AbstractFacebookType {
    @Facebook
    private Long totalCount = 0L;
    private String viewerReaction;
    @Facebook
    private String summary;
    @Facebook
    private List<ReactionItem> data = new ArrayList<ReactionItem>();
    private static final long serialVersionUID = 1L;

    public List<ReactionItem> getData() {
        return Collections.unmodifiableList(this.data);
    }

    public boolean addData(ReactionItem reaction) {
        return this.data.add(reaction);
    }

    public boolean removeData(ReactionItem reaction) {
        return this.data.remove(reaction);
    }

    @JsonMapper.JsonMappingCompleted
    private void fillFields() {
        JsonObject summaryObject = null;
        if (this.summary != null) {
            summaryObject = Json.parse(this.summary).asObject();
        }
        this.fillViewerReaction(summaryObject);
        this.fillTotalCount(summaryObject);
    }

    private void fillViewerReaction(JsonObject summary) {
        if (summary != null && summary.get("viewer_reaction") != null) {
            this.viewerReaction = summary.get("viewer_reaction").asString();
        }
    }

    private void fillTotalCount(JsonObject summary) {
        if (this.totalCount == 0L && summary != null && summary.get("total_count") != null) {
            this.totalCount = summary.getLong("total_count", this.totalCount);
        }
    }

    public Long getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(Long totalCount) {
        this.totalCount = totalCount;
    }

    public String getViewerReaction() {
        return this.viewerReaction;
    }

    public void setViewerReaction(String viewerReaction) {
        this.viewerReaction = viewerReaction;
    }

    public static class ReactionItem
    extends AbstractFacebookType {
        @Facebook
        private String name;
        @Facebook
        private String id;
        @Facebook
        private String type;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }
}

