/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.types;

import com.restfb.Facebook;
import com.restfb.JsonMapper;
import com.restfb.annotation.GraphAPI;
import com.restfb.exception.FacebookJsonMappingException;
import com.restfb.json.Json;
import com.restfb.json.JsonObject;
import com.restfb.json.JsonValue;
import com.restfb.types.AbstractFacebookType;
import com.restfb.types.CategorizedFacebookType;
import com.restfb.types.Comments;
import com.restfb.types.FacebookType;
import com.restfb.types.Likes;
import com.restfb.types.MessageTag;
import com.restfb.types.NamedFacebookType;
import com.restfb.types.Place;
import com.restfb.types.PostCallToAction;
import com.restfb.types.Privacy;
import com.restfb.types.Reactions;
import com.restfb.types.StoryAttachment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class Post
extends FacebookType {
    @Facebook
    private CategorizedFacebookType from;
    @Facebook(value="allowed_advertising_objects")
    private String allowedAdvertisingObjects;
    @Facebook(value="allowed_advertising_objectives")
    private List<String> allowedAdvertisingObjectives = new ArrayList<String>();
    @Facebook(value="call_to_action")
    private PostCallToAction callToAction;
    @Facebook(value="child_attachments")
    private List<Post> childAttachments = new ArrayList<Post>();
    @Facebook(value="comments_mirroring_domain")
    private String commentsMirroringDomain;
    @Facebook
    private String message;
    @Facebook(value="parent_id")
    private String parentId;
    @Facebook(value="permalink_url")
    private String permalinkUrl;
    @Facebook
    private String picture;
    @Facebook
    @GraphAPI(until="3.2")
    private String link;
    @Facebook
    @GraphAPI(until="3.2")
    private String name;
    @Facebook
    @GraphAPI(until="3.2")
    private String caption;
    @Facebook
    @GraphAPI(until="3.2")
    private String description;
    @Facebook
    @GraphAPI(until="3.2")
    private String source;
    @Facebook
    private NamedFacebookType application;
    @Facebook
    private String icon;
    @Facebook
    private Privacy privacy;
    @Facebook(value="promotion_status")
    private String promotionStatus;
    @Facebook(value="feed_targeting")
    private FeedTargeting feedTargeting;
    @Facebook(value="can_reply_privately")
    @GraphAPI(since="2.5")
    private Boolean canReplyPrivately;
    @Facebook
    @GraphAPI(since="2.5")
    private NamedFacebookType target;
    @Facebook
    private Targeting targeting;
    @Facebook(value="timeline_visibility")
    private String timelineVisibility;
    @Facebook(value="likes")
    private Long likesCount = 0L;
    @Facebook
    private Likes likes;
    @Facebook(value="created_time")
    private Date createdTime;
    @Facebook(value="updated_time")
    private Date updatedTime;
    @Facebook(value="object_id")
    @GraphAPI(until="3.2")
    private String objectId;
    @Facebook(value="status_type")
    private String statusType;
    @Facebook
    private String story;
    @Facebook
    private Comments comments;
    @Facebook
    private Reactions reactions;
    @Facebook
    private Place place;
    @Facebook
    private List<NamedFacebookType> to = new ArrayList<NamedFacebookType>();
    @Facebook
    private List<Action> actions = new ArrayList<Action>();
    @Facebook
    private List<Property> properties = new ArrayList<Property>();
    @Facebook(value="with_tags")
    private List<NamedFacebookType> withTags = new ArrayList<NamedFacebookType>();
    @Facebook(value="message_tags")
    private transient String rawMessageTags;
    private List<MessageTag> messageTags = new ArrayList<MessageTag>();
    @Facebook(value="story_tags")
    private transient String rawStoryTags;
    private List<MessageTag> storyTags = new ArrayList<MessageTag>();
    @Facebook(value="sponsor_tags")
    private List<NamedFacebookType> sponsorTags = new ArrayList<NamedFacebookType>();
    @Facebook(value="scheduled_publish_time")
    private Date scheduledPublishTime;
    @Facebook
    private Shares shares;
    @Facebook(value="admin_creator")
    private NamedFacebookType adminCreator;
    @Facebook(value="instagram_eligibility")
    private String instagramEligibility;
    @Facebook(value="is_app_share")
    private Boolean isAppShare;
    @Facebook(value="is_eligible_for_promotion")
    private Boolean isEligibleForPromotion;
    @Facebook(value="is_expired")
    private Boolean isExpired;
    @Facebook(value="is_hidden")
    private Boolean isHidden;
    @Facebook(value="is_instagram_eligible")
    private Boolean isInstagramEligible;
    @Facebook(value="is_popular")
    private Boolean isPopular;
    @Facebook(value="is_published")
    private Boolean isPublished;
    @Facebook(value="is_spherical")
    private Boolean isSpherical;
    @Facebook(value="multi_share_end_card")
    private Boolean multiShareEndCard;
    @Facebook(value="multi_share_optimized")
    private Boolean multiShareOptimized;
    @Facebook
    private Attachments attachments;
    @Facebook(value="full_picture")
    private String fullPicture;
    @Facebook
    private String via;
    private static final long serialVersionUID = 3L;

    @Override
    @GraphAPI(until="3.2")
    public String getType() {
        return super.getType();
    }

    @JsonMapper.JsonMappingCompleted
    protected void jsonMappingCompleted(JsonMapper jsonMapper) {
        if (this.rawMessageTags != null) {
            this.messageTags = this.createTags(this.rawMessageTags, jsonMapper);
        }
        if (this.rawStoryTags != null) {
            this.storyTags = this.createTags(this.rawStoryTags, jsonMapper);
        }
    }

    private List<MessageTag> createTags(String rawTags, JsonMapper jsonMapper) {
        try {
            return jsonMapper.toJavaList(rawTags, MessageTag.class);
        }
        catch (FacebookJsonMappingException facebookJsonMappingException) {
            try {
                ArrayList<MessageTag> resultList = new ArrayList<MessageTag>();
                JsonObject rawMessageTagsObject = jsonMapper.toJavaObject(rawTags, JsonObject.class);
                for (String key : rawMessageTagsObject.names()) {
                    String tagArrayString = rawMessageTagsObject.get(key).toString();
                    resultList.addAll(jsonMapper.toJavaList(tagArrayString, MessageTag.class));
                }
                return resultList;
            }
            catch (FacebookJsonMappingException je) {
                return new ArrayList<MessageTag>();
            }
        }
    }

    public Long getLikesCount() {
        if (this.getLikes() != null) {
            return this.getLikes().getTotalCount();
        }
        return this.likesCount;
    }

    public Long getReactionsCount() {
        if (this.getReactions() != null) {
            return this.getReactions().getTotalCount();
        }
        return 0L;
    }

    public Long getSharesCount() {
        if (this.shares != null) {
            return this.shares.getCount();
        }
        return 0L;
    }

    public Long getCommentsCount() {
        if (this.comments != null) {
            return this.comments.getTotalCount();
        }
        return 0L;
    }

    public List<NamedFacebookType> getTo() {
        return Collections.unmodifiableList(this.to);
    }

    public boolean addTo(NamedFacebookType profile) {
        return this.to.add(profile);
    }

    public boolean removeTo(NamedFacebookType profile) {
        return this.to.remove(profile);
    }

    public List<Action> getActions() {
        return Collections.unmodifiableList(this.actions);
    }

    public boolean addAction(Action action) {
        return this.actions.add(action);
    }

    public boolean removeAction(Action action) {
        return this.actions.remove(action);
    }

    public List<Property> getProperties() {
        return Collections.unmodifiableList(this.properties);
    }

    public boolean addProperty(Property property) {
        return this.properties.add(property);
    }

    public boolean removeProperty(Property property) {
        return this.properties.remove(property);
    }

    @GraphAPI(until="3.2")
    @Deprecated
    public List<NamedFacebookType> getWithTags() {
        return Collections.unmodifiableList(this.withTags);
    }

    @GraphAPI(until="3.2")
    @Deprecated
    public boolean addWithTag(NamedFacebookType withTag) {
        return this.withTags.add(withTag);
    }

    @GraphAPI(until="3.2")
    @Deprecated
    public boolean removeWithTag(NamedFacebookType withTag) {
        return this.withTags.remove(withTag);
    }

    public List<MessageTag> getMessageTags() {
        return Collections.unmodifiableList(this.messageTags);
    }

    public void addMessageTag(MessageTag messageTag) {
        this.messageTags.add(messageTag);
    }

    public void removeMessageTag(MessageTag messageTag) {
        this.messageTags.remove(messageTag);
    }

    public List<MessageTag> getStoryTags() {
        return Collections.unmodifiableList(this.storyTags);
    }

    public void addStoryTag(MessageTag messageTag) {
        this.storyTags.add(messageTag);
    }

    public void removeStoryTag(MessageTag messageTag) {
        this.storyTags.remove(messageTag);
    }

    public List<Post> getChildAttachments() {
        return Collections.unmodifiableList(this.childAttachments);
    }

    public void addChildAttachment(Post childAttachment) {
        this.childAttachments.add(childAttachment);
    }

    public void removeChildAttachment(Post childAttachment) {
        this.childAttachments.remove(childAttachment);
    }

    public List<NamedFacebookType> getSponsorTags() {
        return Collections.unmodifiableList(this.sponsorTags);
    }

    public boolean addSponsorTag(NamedFacebookType sponsorTag) {
        return this.sponsorTags.add(sponsorTag);
    }

    public boolean removeSponsorTag(NamedFacebookType sponsorTag) {
        return this.sponsorTags.remove(sponsorTag);
    }

    public CategorizedFacebookType getFrom() {
        return this.from;
    }

    public void setFrom(CategorizedFacebookType from) {
        this.from = from;
    }

    public String getAllowedAdvertisingObjects() {
        return this.allowedAdvertisingObjects;
    }

    public void setAllowedAdvertisingObjects(String allowedAdvertisingObjects) {
        this.allowedAdvertisingObjects = allowedAdvertisingObjects;
    }

    public List<String> getAllowedAdvertisingObjectives() {
        return this.allowedAdvertisingObjectives;
    }

    public void setAllowedAdvertisingObjectives(List<String> allowedAdvertisingObjectives) {
        this.allowedAdvertisingObjectives = allowedAdvertisingObjectives;
    }

    public PostCallToAction getCallToAction() {
        return this.callToAction;
    }

    public void setCallToAction(PostCallToAction callToAction) {
        this.callToAction = callToAction;
    }

    public String getCommentsMirroringDomain() {
        return this.commentsMirroringDomain;
    }

    public void setCommentsMirroringDomain(String commentsMirroringDomain) {
        this.commentsMirroringDomain = commentsMirroringDomain;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getPermalinkUrl() {
        return this.permalinkUrl;
    }

    public void setPermalinkUrl(String permalinkUrl) {
        this.permalinkUrl = permalinkUrl;
    }

    public String getPicture() {
        return this.picture;
    }

    public void setPicture(String picture) {
        this.picture = picture;
    }

    @GraphAPI(until="3.2")
    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    @GraphAPI(until="3.2")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @GraphAPI(until="3.2")
    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    @GraphAPI(until="3.2")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @GraphAPI(until="3.2")
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public NamedFacebookType getApplication() {
        return this.application;
    }

    public void setApplication(NamedFacebookType application) {
        this.application = application;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public Privacy getPrivacy() {
        return this.privacy;
    }

    public void setPrivacy(Privacy privacy) {
        this.privacy = privacy;
    }

    public String getPromotionStatus() {
        return this.promotionStatus;
    }

    public void setPromotionStatus(String promotionStatus) {
        this.promotionStatus = promotionStatus;
    }

    public FeedTargeting getFeedTargeting() {
        return this.feedTargeting;
    }

    public void setFeedTargeting(FeedTargeting feedTargeting) {
        this.feedTargeting = feedTargeting;
    }

    @GraphAPI(since="2.5")
    public Boolean getCanReplyPrivately() {
        return this.canReplyPrivately;
    }

    public void setCanReplyPrivately(Boolean canReplyPrivately) {
        this.canReplyPrivately = canReplyPrivately;
    }

    @GraphAPI(since="2.5")
    public NamedFacebookType getTarget() {
        return this.target;
    }

    public void setTarget(NamedFacebookType target) {
        this.target = target;
    }

    public Targeting getTargeting() {
        return this.targeting;
    }

    public void setTargeting(Targeting targeting) {
        this.targeting = targeting;
    }

    public String getTimelineVisibility() {
        return this.timelineVisibility;
    }

    public void setTimelineVisibility(String timelineVisibility) {
        this.timelineVisibility = timelineVisibility;
    }

    public Likes getLikes() {
        return this.likes;
    }

    public void setLikes(Likes likes) {
        this.likes = likes;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    public void setUpdatedTime(Date updatedTime) {
        this.updatedTime = updatedTime;
    }

    @GraphAPI(until="3.2")
    public String getObjectId() {
        return this.objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public String getStatusType() {
        return this.statusType;
    }

    public void setStatusType(String statusType) {
        this.statusType = statusType;
    }

    public String getStory() {
        return this.story;
    }

    public void setStory(String story) {
        this.story = story;
    }

    public Comments getComments() {
        return this.comments;
    }

    public void setComments(Comments comments) {
        this.comments = comments;
    }

    public Reactions getReactions() {
        return this.reactions;
    }

    public void setReactions(Reactions reactions) {
        this.reactions = reactions;
    }

    public Place getPlace() {
        return this.place;
    }

    public void setPlace(Place place) {
        this.place = place;
    }

    public Date getScheduledPublishTime() {
        return this.scheduledPublishTime;
    }

    public void setScheduledPublishTime(Date scheduledPublishTime) {
        this.scheduledPublishTime = scheduledPublishTime;
    }

    public Shares getShares() {
        return this.shares;
    }

    public void setShares(Shares shares) {
        this.shares = shares;
    }

    public NamedFacebookType getAdminCreator() {
        return this.adminCreator;
    }

    public void setAdminCreator(NamedFacebookType adminCreator) {
        this.adminCreator = adminCreator;
    }

    public String getInstagramEligibility() {
        return this.instagramEligibility;
    }

    public void setInstagramEligibility(String instagramEligibility) {
        this.instagramEligibility = instagramEligibility;
    }

    public Boolean getIsAppShare() {
        return this.isAppShare;
    }

    public void setIsAppShare(Boolean isAppShare) {
        this.isAppShare = isAppShare;
    }

    public Boolean getIsEligibleForPromotion() {
        return this.isEligibleForPromotion;
    }

    public void setIsEligibleForPromotion(Boolean isEligibleForPromotion) {
        this.isEligibleForPromotion = isEligibleForPromotion;
    }

    public Boolean getIsExpired() {
        return this.isExpired;
    }

    public void setIsExpired(Boolean isExpired) {
        this.isExpired = isExpired;
    }

    public Boolean getIsHidden() {
        return this.isHidden;
    }

    public void setIsHidden(Boolean isHidden) {
        this.isHidden = isHidden;
    }

    public Boolean getIsInstagramEligible() {
        return this.isInstagramEligible;
    }

    public void setIsInstagramEligible(Boolean isInstagramEligible) {
        this.isInstagramEligible = isInstagramEligible;
    }

    public Boolean getIsPopular() {
        return this.isPopular;
    }

    public void setIsPopular(Boolean isPopular) {
        this.isPopular = isPopular;
    }

    public Boolean getIsPublished() {
        return this.isPublished;
    }

    public void setIsPublished(Boolean isPublished) {
        this.isPublished = isPublished;
    }

    public Boolean getIsSpherical() {
        return this.isSpherical;
    }

    public void setIsSpherical(Boolean isSpherical) {
        this.isSpherical = isSpherical;
    }

    public Boolean getMultiShareEndCard() {
        return this.multiShareEndCard;
    }

    public void setMultiShareEndCard(Boolean multiShareEndCard) {
        this.multiShareEndCard = multiShareEndCard;
    }

    public Boolean getMultiShareOptimized() {
        return this.multiShareOptimized;
    }

    public void setMultiShareOptimized(Boolean multiShareOptimized) {
        this.multiShareOptimized = multiShareOptimized;
    }

    public Attachments getAttachments() {
        return this.attachments;
    }

    public void setAttachments(Attachments attachments) {
        this.attachments = attachments;
    }

    public String getFullPicture() {
        return this.fullPicture;
    }

    public void setFullPicture(String fullPicture) {
        this.fullPicture = fullPicture;
    }

    public String getVia() {
        return this.via;
    }

    public void setVia(String via) {
        this.via = via;
    }

    public static class Attachments
    extends AbstractFacebookType {
        @Facebook
        private List<StoryAttachment> data = new ArrayList<StoryAttachment>();
        private static final long serialVersionUID = 1L;

        public List<StoryAttachment> getData() {
            return Collections.unmodifiableList(this.data);
        }

        public boolean addData(StoryAttachment attachment) {
            return this.data.add(attachment);
        }

        public boolean removeData(StoryAttachment attachment) {
            return this.data.remove(attachment);
        }
    }

    public static class Shares
    extends AbstractFacebookType {
        @Facebook
        private Long count = 0L;
        private static final long serialVersionUID = 1L;

        public Long getCount() {
            return this.count;
        }

        public void setCount(Long count) {
            this.count = count;
        }
    }

    public static class FeedTargeting
    extends Targeting {
        private static final long serialVersionUID = 1L;
        @Facebook(value="age_max")
        private Integer ageMax;
        @Facebook(value="age_min")
        private Integer ageMin;
        @Facebook(value="relevant_until_ts")
        private Date relevantUntilTs;
        @Facebook(value="college_majors")
        private List<String> collegeMajors = new ArrayList<String>();
        @Facebook(value="college_networks")
        private List<FacebookType> collegeNetworks = new ArrayList<FacebookType>();
        @Facebook(value="college_years")
        private List<Integer> collegeYears = new ArrayList<Integer>();
        @Facebook(value="education_statuses")
        private List<Integer> educationStatuses = new ArrayList<Integer>();
        @Facebook(value="fan_of")
        private List<String> fanOf = new ArrayList<String>();
        @Facebook
        private List<Integer> genders = new ArrayList<Integer>();
        @Facebook(value="interested_in")
        private List<Integer> interestedIn = new ArrayList<Integer>();
        @Facebook
        private List<String> interests = new ArrayList<String>();
        @Facebook(value="relationship_statuses")
        private List<Integer> relationshipStatuses = new ArrayList<Integer>();
        @Facebook(value="work_networks")
        private List<NamedFacebookType> workNetworks = new ArrayList<NamedFacebookType>();

        public List<String> getCollegeMajors() {
            return Collections.unmodifiableList(this.collegeMajors);
        }

        public boolean addCollegeMajor(String collegeMajor) {
            return this.collegeMajors.add(collegeMajor);
        }

        public boolean removeCollegeMajor(String collegeMajor) {
            return this.collegeMajors.remove(collegeMajor);
        }

        public List<FacebookType> getCollegeNetworks() {
            return Collections.unmodifiableList(this.collegeNetworks);
        }

        public boolean addCollegeNetwork(FacebookType collegeNetwork) {
            return this.collegeNetworks.add(collegeNetwork);
        }

        public boolean removeCollegeNetwork(FacebookType collegeNetwork) {
            return this.collegeNetworks.remove(collegeNetwork);
        }

        public List<Integer> getCollegeYears() {
            return Collections.unmodifiableList(this.collegeYears);
        }

        public boolean addCollegeYear(Integer collegeYear) {
            return this.collegeYears.add(collegeYear);
        }

        public boolean removeCollegeYear(Integer collegeYear) {
            return this.collegeYears.remove(collegeYear);
        }

        public List<Integer> getEducationStatuses() {
            return Collections.unmodifiableList(this.educationStatuses);
        }

        public boolean addEducationStatus(Integer educationStatus) {
            return this.educationStatuses.add(educationStatus);
        }

        public boolean removeEducationStatus(Integer educationStatus) {
            return this.educationStatuses.remove(educationStatus);
        }

        public List<String> getFanOf() {
            return Collections.unmodifiableList(this.fanOf);
        }

        public boolean addFanOf(String interestId) {
            return this.fanOf.add(interestId);
        }

        public boolean removeFanOf(String interestId) {
            return this.fanOf.remove(interestId);
        }

        public List<Integer> getGenders() {
            return Collections.unmodifiableList(this.genders);
        }

        public boolean addGender(Integer gender) {
            return this.genders.add(gender);
        }

        public boolean removeGender(Integer gender) {
            return this.genders.remove(gender);
        }

        public List<Integer> getInterestedIn() {
            return Collections.unmodifiableList(this.interestedIn);
        }

        public boolean addInterestedIn(Integer interest) {
            return this.interestedIn.add(interest);
        }

        public boolean removeInterestedIn(Integer interest) {
            return this.interestedIn.remove(interest);
        }

        public List<String> getInterests() {
            return Collections.unmodifiableList(this.interests);
        }

        public boolean addInterests(String interest) {
            return this.interests.add(interest);
        }

        public boolean removeInterests(String interest) {
            return this.interests.remove(interest);
        }

        public List<Integer> getRelationshipStatuses() {
            return Collections.unmodifiableList(this.relationshipStatuses);
        }

        public boolean addRelationshipStatus(Integer relationshipStatus) {
            return this.relationshipStatuses.add(relationshipStatus);
        }

        public boolean removeRelationshipStatus(Integer relationshipStatus) {
            return this.relationshipStatuses.remove(relationshipStatus);
        }

        public List<NamedFacebookType> getWorkNetworks() {
            return Collections.unmodifiableList(this.workNetworks);
        }

        public boolean addWorkNetwork(NamedFacebookType workNetwork) {
            return this.workNetworks.add(workNetwork);
        }

        public boolean removeWorkNetwork(NamedFacebookType workNetwork) {
            return this.workNetworks.remove(workNetwork);
        }

        public Integer getAgeMax() {
            return this.ageMax;
        }

        public void setAgeMax(Integer ageMax) {
            this.ageMax = ageMax;
        }

        public Integer getAgeMin() {
            return this.ageMin;
        }

        public void setAgeMin(Integer ageMin) {
            this.ageMin = ageMin;
        }

        public Date getRelevantUntilTs() {
            return this.relevantUntilTs;
        }

        public void setRelevantUntilTs(Date relevantUntilTs) {
            this.relevantUntilTs = relevantUntilTs;
        }
    }

    public static class Targeting
    extends AbstractFacebookType {
        private static final long serialVersionUID = 1L;
        @Facebook(value="geo_locations")
        @GraphAPI(since="2.8")
        FeedTargeting geoLocations;
        @Facebook
        protected List<KeyedType> cities = new ArrayList<KeyedType>();
        @Facebook
        protected List<String> countries = new ArrayList<String>();
        @Facebook
        protected List<KeyedType> regions = new ArrayList<KeyedType>();
        @Facebook(value="regions")
        private transient String rawRegionsString;
        @Facebook
        protected List<Integer> locales = new ArrayList<Integer>();

        @JsonMapper.JsonMappingCompleted
        private void convertList(JsonMapper mapper) {
            JsonValue jsonValue;
            if (this.rawRegionsString != null && (jsonValue = Json.parse(this.rawRegionsString)).isObject()) {
                JsonObject rawRegions = jsonValue.asObject();
                for (String key : rawRegions.names()) {
                    String region = rawRegions.get(key).toString();
                    this.regions.add(mapper.toJavaObject(region, KeyedType.class));
                }
            }
        }

        public boolean addCity(KeyedType city) {
            if (this.geoLocations != null) {
                return this.geoLocations.addCity(city);
            }
            return this.cities.add(city);
        }

        public boolean addCountry(String country) {
            if (this.geoLocations != null) {
                return this.geoLocations.addCountry(country);
            }
            return this.countries.add(country);
        }

        public boolean addLocale(Integer locale) {
            if (this.geoLocations != null) {
                return this.geoLocations.addLocale(locale);
            }
            return this.locales.add(locale);
        }

        public boolean addRegion(KeyedType region) {
            if (this.geoLocations != null) {
                return this.geoLocations.addRegion(region);
            }
            return this.regions.add(region);
        }

        public List<KeyedType> getCities() {
            if (this.geoLocations != null) {
                return this.geoLocations.getCities();
            }
            return Collections.unmodifiableList(this.cities);
        }

        public List<String> getCountries() {
            if (this.geoLocations != null) {
                return this.geoLocations.getCountries();
            }
            return Collections.unmodifiableList(this.countries);
        }

        public List<Integer> getLocales() {
            if (this.geoLocations != null && !this.geoLocations.getLocales().isEmpty()) {
                return this.geoLocations.getLocales();
            }
            return Collections.unmodifiableList(this.locales);
        }

        public List<KeyedType> getRegions() {
            if (this.geoLocations != null) {
                return this.geoLocations.getRegions();
            }
            return Collections.unmodifiableList(this.regions);
        }

        public boolean removeCity(NamedFacebookType city) {
            if (this.geoLocations != null) {
                return this.geoLocations.removeCity(city);
            }
            return this.cities.remove(city);
        }

        public boolean removeCountry(String country) {
            if (this.geoLocations != null) {
                return this.geoLocations.removeCountry(country);
            }
            return this.countries.remove(country);
        }

        public boolean removeLocale(Integer locale) {
            if (this.geoLocations != null) {
                return this.geoLocations.removeLocale(locale);
            }
            return this.locales.remove(locale);
        }

        public boolean removeRegion(NamedFacebookType region) {
            if (this.geoLocations != null) {
                return this.geoLocations.removeRegion(region);
            }
            return this.regions.remove(region);
        }

        @GraphAPI(since="2.8")
        public FeedTargeting getGeoLocations() {
            return this.geoLocations;
        }

        public void setGeoLocations(FeedTargeting geoLocations) {
            this.geoLocations = geoLocations;
        }
    }

    public static class KeyedType
    extends NamedFacebookType {
        private static final long serialVersionUID = 1L;
        @Facebook
        private String key;

        @JsonMapper.JsonMappingCompleted
        private void replaceId() {
            if (this.getId() == null && this.key != null) {
                this.setId(this.key);
            }
            if (this.key == null && this.getId() != null) {
                this.setKey(this.getId());
            }
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }
    }

    public static class Action
    extends AbstractFacebookType {
        @Facebook
        private String name;
        @Facebook
        private String link;
        private static final long serialVersionUID = 1L;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getLink() {
            return this.link;
        }

        public void setLink(String link) {
            this.link = link;
        }
    }

    public static class Property
    extends AbstractFacebookType {
        @Facebook
        private String name;
        @Facebook
        private String text;
        @Facebook
        private String href;
        private static final long serialVersionUID = 1L;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public String getHref() {
            return this.href;
        }

        public void setHref(String href) {
            this.href = href;
        }
    }
}

