/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.types;

import com.restfb.Facebook;
import com.restfb.JsonMapper;
import com.restfb.annotation.GraphAPI;
import com.restfb.json.Json;
import com.restfb.json.JsonObject;
import com.restfb.json.JsonValue;
import com.restfb.types.AbstractFacebookType;
import com.restfb.types.CategorizedFacebookType;
import com.restfb.types.Category;
import com.restfb.types.Hours;
import com.restfb.types.InstagramUser;
import com.restfb.types.Likes;
import com.restfb.types.Location;
import com.restfb.types.PageAdminNote;
import com.restfb.types.PageLabel;
import com.restfb.types.ProfilePictureSource;
import com.restfb.types.Video;
import com.restfb.types.ads.Business;
import com.restfb.types.instagram.IgUser;
import com.restfb.util.MappingUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Page
extends CategorizedFacebookType {
    @Facebook(value="picture")
    private transient String rawPicture;
    private ProfilePictureSource picture;
    @Facebook(value="admin_notes")
    private List<PageAdminNote> adminNotes = new ArrayList<PageAdminNote>();
    @Facebook
    private String affiliation;
    @Facebook(value="app_id")
    private String appId;
    @Facebook(value="artists_we_like")
    private String artistsWeLike;
    @Facebook(value="asset_score")
    private Double assetScore;
    @Facebook
    private String attire;
    @Facebook
    private String awards;
    @Facebook(value="band_interests")
    private String bandInterests;
    @Facebook(value="band_members")
    private String bandMembers;
    @Facebook(value="best_page")
    private Page bestPage;
    @Facebook(value="contact_address")
    private MailingAddress contactAddress;
    @Facebook(value="country_page_likes")
    private Integer countryPageLikes;
    @Facebook
    private String category;
    @Facebook
    private String bio;
    @Facebook
    private String birthday;
    @Facebook
    private String built;
    @Facebook
    private Business business;
    @Facebook(value="culinary_team")
    private String culinaryTeam;
    @Facebook(value="current_location")
    private String currentLocation;
    @Facebook
    private String features;
    @Facebook(value="global_brand_page_name")
    private String globalBrandPageName;
    @Facebook(value="global_brand_root_id")
    private String globalBrandRootId;
    @Facebook(value="global_brand_parent_page")
    private Page globalBrandParentPage;
    @Facebook(value="has_added_app")
    private Boolean hasAddedApp;
    @Facebook(value="has_whatsapp_number")
    private Boolean hasWhatsappNumber;
    @Facebook(value="has_whatsapp_business_number")
    private Boolean hasWhatsappBusinessNumber;
    @Facebook
    private String hometown;
    @Facebook(value="hours")
    private List<JsonObject> rawHours = new ArrayList<JsonObject>();
    @Facebook(value="hours")
    private Map<String, String> rawHoursMap = new HashMap<String, String>();
    private Hours hours;
    @Facebook
    private String impressum;
    @Facebook
    private String influences;
    @Facebook(value="is_permanently_closed")
    private Boolean isPermanentlyClosed;
    private List<PageLabel> labels = new ArrayList<PageLabel>();
    @Facebook(value="owner_business")
    private Business ownerBusiness;
    @Facebook(value="overall_star_rating")
    private Double overallStarRating;
    @Facebook(value="rating_count")
    private Integer ratingCount;
    @Facebook
    private String recipient;
    @Facebook(value="labels")
    private transient String rawLabels;
    @Facebook(value="personal_info")
    private String personalInfo;
    @Facebook(value="payment_options")
    private PagePaymentOptions paymentOptions;
    @Facebook(value="personal_interests")
    private String personalInterests;
    @Facebook(value="pharma_safety_info")
    private String pharmaSafetyInfo;
    @Facebook(value="place_type")
    private String placeType;
    @Facebook(value="plot_outline")
    private String plotOutline;
    @Facebook(value="price_range")
    private String priceRange;
    @Facebook(value="produced_by")
    private String producedBy;
    @Facebook(value="promotion_eligible")
    private Boolean promotionEligible;
    @Facebook(value="promotion_ineligible_reason")
    private String promotionIneligibleReason;
    @Facebook(value="public_transit")
    private String publicTransit;
    @Facebook(value="record_label")
    private String recordLabel;
    @Facebook(value="release_date")
    private String releaseDate;
    @Facebook(value="restaurant_services")
    private PageRestaurantServices restaurantServices;
    @Facebook(value="restaurant_specialties")
    private PageRestaurantSpecialties restaurantSpecialties;
    @Facebook(value="store_code")
    private String storeCode;
    @Facebook(value="store_location_descriptor")
    @GraphAPI(since="2.5")
    private String storeLocationDescriptor;
    @Facebook
    private String genre;
    @Facebook
    private String mpg;
    @Facebook
    private String network;
    @Facebook(value="new_like_count")
    private Long newLikeCount;
    @Facebook(value="offer_eligible")
    private Boolean offerEligible;
    @Facebook
    private String schedule;
    @Facebook(value="screenplay_by")
    private String screenplayBy;
    @Facebook
    private String season;
    @Facebook(value="single_line_address")
    private String singleLineAddress;
    @Facebook
    private String starring;
    @Facebook(value="start_info")
    private PageStartInfo startInfo;
    @Facebook(value="store_number")
    private String storeNumber;
    @Facebook
    private String studio;
    @Facebook
    private Engagement engagement;
    @Facebook(value="unread_message_count")
    private Long unreadMessageCount;
    @Facebook(value="unread_notif_count")
    private Long unreadNotifCount;
    @Facebook(value="unseen_message_count")
    private Long unseenMessageCount;
    @Facebook
    private String members;
    @Facebook(value="were_here_count")
    private Long wereHereCount;
    @Facebook(value="featured_video")
    private Video featuredVideo;
    @Facebook(value="verification_status")
    private String verificationStatus;
    @Facebook(value="voip_info")
    private VoipInfo voipInfo;
    @Facebook(value="written_by")
    private String writtenBy;
    @Facebook(value="whatsapp_number")
    private String whatsappNumber;
    @Facebook
    private String link;
    @Facebook
    private String username;
    @Facebook
    private String founded;
    @Facebook(value="company_overview")
    private String companyOverview;
    @Facebook
    private String mission;
    @Facebook
    private String products;
    @Facebook(value="page_token")
    private String pageToken;
    @Facebook(value="parent_page")
    private Page parentPage;
    @Facebook(value="leadgen_tos_accepted")
    private Boolean leadgenTosAccepted;
    @Facebook(value="likes")
    @GraphAPI(until="2.5")
    private Long likesCount;
    @Facebook
    @GraphAPI(since="2.6")
    private Likes likes;
    @Facebook(value="fan_count")
    @GraphAPI(since="2.6")
    private Long fanCount;
    @Facebook(value="is_always_open")
    private Boolean isAlwaysOpen;
    @Facebook(value="is_chain")
    private Boolean isChain;
    @Facebook(value="is_community_page")
    private Boolean isCommunityPage;
    @Facebook(value="is_eligible_for_branded_content")
    private Boolean isEligibleForBrandedContent;
    @Facebook(value="is_messenger_bot_get_started_enabled")
    private Boolean isMessengerBotGetStartedEnabled;
    @Facebook(value="is_messenger_platform_bot")
    private Boolean isMessengerPlatformBot;
    @Facebook(value="is_owned")
    private Boolean isOwned;
    @Facebook
    private String description;
    @Facebook(value="description_html")
    private String descriptionHtml;
    @Facebook
    private Integer checkins;
    @Facebook
    private String phone;
    @Facebook
    private PageParking parking;
    @Facebook(value="access_token")
    private String accessToken;
    @Facebook
    private String about;
    @Facebook(value="talking_about_count")
    private Long talkingAboutCount;
    @Facebook(value="can_checkin")
    private Boolean canCheckin;
    @Facebook(value="can_post")
    private Boolean canPost;
    @Facebook(value="is_published")
    private Boolean isPublished;
    @Facebook(value="is_unclaimed")
    private Boolean isUnclaimed;
    @Deprecated
    @Facebook(value="is_verified")
    private Boolean isVerified;
    @Facebook(value="is_webhooks_subscribed")
    @GraphAPI(since="2.7")
    private Boolean isWebhooksSubscribed;
    @Facebook(value="directed_by")
    private String directedBy;
    @Facebook(value="display_subtext")
    private String displaySubtext;
    @Facebook(value="displayed_message_response_time")
    private String displayedMessageResponseTime;
    @Facebook(value="general_manager")
    private String generalManager;
    @Facebook(value="general_info")
    private String generalInfo;
    @Facebook
    private Location location;
    @Facebook(value="merchant_id")
    private String merchantId;
    @Facebook
    private Cover cover;
    @Facebook
    private String website;
    @Facebook(value="name_with_location_descriptor")
    private String nameWithLocationDescriptor;
    @Facebook(value="booking_agent")
    private String bookingAgent;
    @Facebook(value="press_contact")
    private String pressContact;
    @Facebook(value="connected_instagram_account")
    private IgUser connectedInstagramAccount;
    @Facebook(value="instagram_business_account")
    private IgUser instagramBusinessAccount;
    @Facebook(value="instagram_accounts")
    private List<InstagramUser> instagramAccounts = new ArrayList<InstagramUser>();
    @Facebook(value="instant_articles_review_status")
    private String instantArticlesReviewStatus;
    @Facebook(value="last_used_time")
    private Date lastUsedTime;
    @Facebook(value="category_list")
    private List<Category> categoryList = new ArrayList<Category>();
    @Facebook
    private List<String> emails = new ArrayList<String>();
    @Facebook(value="food_styles")
    private List<String> foodStyles = new ArrayList<String>();
    @Facebook(value="screennames")
    private List<ScreenName> screenNames = new ArrayList<ScreenName>();
    private static final long serialVersionUID = 2L;

    public List<ScreenName> getScreenNames() {
        return Collections.unmodifiableList(this.screenNames);
    }

    public boolean addScreenName(ScreenName screenName) {
        return this.screenNames.add(screenName);
    }

    public boolean removeScreenName(ScreenName screenName) {
        return this.screenNames.remove(screenName);
    }

    public List<Category> getCategoryList() {
        return Collections.unmodifiableList(this.categoryList);
    }

    public boolean addCategory(Category category) {
        return this.categoryList.add(category);
    }

    public boolean removeCategory(Category category) {
        return this.categoryList.remove(category);
    }

    public List<String> getEmails() {
        return Collections.unmodifiableList(this.emails);
    }

    public boolean addEmail(String email) {
        return this.emails.add(email);
    }

    public boolean removeEmail(String email) {
        return this.emails.remove(email);
    }

    public List<String> getFoodStyles() {
        return Collections.unmodifiableList(this.foodStyles);
    }

    public boolean addFoodStyle(String foodStyle) {
        return this.foodStyles.add(foodStyle);
    }

    public boolean removeFoodStyle(String foodStyle) {
        return this.foodStyles.remove(foodStyle);
    }

    @GraphAPI(since="2.6")
    public List<PageAdminNote> getAdminNotes() {
        return Collections.unmodifiableList(this.adminNotes);
    }

    public boolean addAdminNote(PageAdminNote adminNote) {
        return this.adminNotes.add(adminNote);
    }

    public boolean removeAdminNote(PageAdminNote adminNote) {
        return this.adminNotes.remove(adminNote);
    }

    @GraphAPI(since="2.6")
    public List<PageLabel> getLabels() {
        return Collections.unmodifiableList(this.labels);
    }

    public boolean addLabel(PageLabel label) {
        return this.labels.add(label);
    }

    public boolean removeLabels(PageLabel label) {
        return this.labels.remove(label);
    }

    public List<InstagramUser> getInstagramAccounts() {
        return Collections.unmodifiableList(this.instagramAccounts);
    }

    public boolean addInstagramAccount(InstagramUser igUser) {
        return this.instagramAccounts.add(igUser);
    }

    public boolean removeInstagramAccount(InstagramUser igUser) {
        return this.instagramAccounts.remove(igUser);
    }

    @JsonMapper.JsonMappingCompleted
    protected void convertLabels(JsonMapper jsonMapper) {
        JsonValue jsonValue;
        JsonObject rawLabels = null;
        if (this.rawLabels != null && (jsonValue = Json.parse(this.rawLabels)).isObject()) {
            rawLabels = jsonValue.asObject();
        }
        if (rawLabels != null && rawLabels.isObject()) {
            String innerLabelsString = rawLabels.get("data").toString();
            this.labels = jsonMapper.toJavaList(innerLabelsString, PageLabel.class);
        }
    }

    @JsonMapper.JsonMappingCompleted
    protected void fillProfilePicture(JsonMapper jsonMapper) {
        MappingUtils mappingUtils = new MappingUtils(jsonMapper);
        this.picture = mappingUtils.convertPicture(this.rawPicture);
    }

    @JsonMapper.JsonMappingCompleted
    protected void graphApi26LikesFallback() {
        if (this.getFanCount() != null && this.getLikesCount() == null) {
            this.likesCount = this.fanCount;
        }
        if (this.getFanCount() == null && this.getLikesCount() != null) {
            this.fanCount = this.likesCount;
        }
    }

    @JsonMapper.JsonMappingCompleted
    protected void convertHours() {
        Hours hoursObj;
        if (this.rawHours != null && !this.rawHours.isEmpty()) {
            hoursObj = new Hours();
            for (JsonObject jsonObject : this.rawHours) {
                hoursObj.addHour(jsonObject.getString("key", ""), jsonObject.getString("value", ""));
            }
            this.hours = hoursObj;
        }
        if (this.rawHoursMap != null && !this.rawHoursMap.isEmpty()) {
            hoursObj = new Hours();
            for (Map.Entry entry : this.rawHoursMap.entrySet()) {
                hoursObj.addHour((String)entry.getKey(), (String)entry.getValue());
            }
            this.hours = hoursObj;
        }
    }

    public ProfilePictureSource getPicture() {
        return this.picture;
    }

    public void setPicture(ProfilePictureSource picture) {
        this.picture = picture;
    }

    public String getAffiliation() {
        return this.affiliation;
    }

    public void setAffiliation(String affiliation) {
        this.affiliation = affiliation;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getArtistsWeLike() {
        return this.artistsWeLike;
    }

    public void setArtistsWeLike(String artistsWeLike) {
        this.artistsWeLike = artistsWeLike;
    }

    public Double getAssetScore() {
        return this.assetScore;
    }

    public void setAssetScore(Double assetScore) {
        this.assetScore = assetScore;
    }

    public String getAttire() {
        return this.attire;
    }

    public void setAttire(String attire) {
        this.attire = attire;
    }

    public String getAwards() {
        return this.awards;
    }

    public void setAwards(String awards) {
        this.awards = awards;
    }

    public String getBandInterests() {
        return this.bandInterests;
    }

    public void setBandInterests(String bandInterests) {
        this.bandInterests = bandInterests;
    }

    public String getBandMembers() {
        return this.bandMembers;
    }

    public void setBandMembers(String bandMembers) {
        this.bandMembers = bandMembers;
    }

    public Page getBestPage() {
        return this.bestPage;
    }

    public void setBestPage(Page bestPage) {
        this.bestPage = bestPage;
    }

    public MailingAddress getContactAddress() {
        return this.contactAddress;
    }

    public void setContactAddress(MailingAddress contactAddress) {
        this.contactAddress = contactAddress;
    }

    public Integer getCountryPageLikes() {
        return this.countryPageLikes;
    }

    public void setCountryPageLikes(Integer countryPageLikes) {
        this.countryPageLikes = countryPageLikes;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public void setCategory(String category) {
        this.category = category;
    }

    public String getBio() {
        return this.bio;
    }

    public void setBio(String bio) {
        this.bio = bio;
    }

    public String getBirthday() {
        return this.birthday;
    }

    public void setBirthday(String birthday) {
        this.birthday = birthday;
    }

    public String getBuilt() {
        return this.built;
    }

    public void setBuilt(String built) {
        this.built = built;
    }

    public Business getBusiness() {
        return this.business;
    }

    public void setBusiness(Business business) {
        this.business = business;
    }

    public String getCulinaryTeam() {
        return this.culinaryTeam;
    }

    public void setCulinaryTeam(String culinaryTeam) {
        this.culinaryTeam = culinaryTeam;
    }

    public String getCurrentLocation() {
        return this.currentLocation;
    }

    public void setCurrentLocation(String currentLocation) {
        this.currentLocation = currentLocation;
    }

    public String getFeatures() {
        return this.features;
    }

    public void setFeatures(String features) {
        this.features = features;
    }

    public String getGlobalBrandPageName() {
        return this.globalBrandPageName;
    }

    public void setGlobalBrandPageName(String globalBrandPageName) {
        this.globalBrandPageName = globalBrandPageName;
    }

    public String getGlobalBrandRootId() {
        return this.globalBrandRootId;
    }

    public void setGlobalBrandRootId(String globalBrandRootId) {
        this.globalBrandRootId = globalBrandRootId;
    }

    public Page getGlobalBrandParentPage() {
        return this.globalBrandParentPage;
    }

    public void setGlobalBrandParentPage(Page globalBrandParentPage) {
        this.globalBrandParentPage = globalBrandParentPage;
    }

    public Boolean getHasAddedApp() {
        return this.hasAddedApp;
    }

    public void setHasAddedApp(Boolean hasAddedApp) {
        this.hasAddedApp = hasAddedApp;
    }

    public Boolean getHasWhatsappNumber() {
        return this.hasWhatsappNumber;
    }

    public void setHasWhatsappNumber(Boolean hasWhatsappNumber) {
        this.hasWhatsappNumber = hasWhatsappNumber;
    }

    public Boolean getHasWhatsappBusinessNumber() {
        return this.hasWhatsappBusinessNumber;
    }

    public void setHasWhatsappBusinessNumber(Boolean hasWhatsappBusinessNumber) {
        this.hasWhatsappBusinessNumber = hasWhatsappBusinessNumber;
    }

    public String getHometown() {
        return this.hometown;
    }

    public void setHometown(String hometown) {
        this.hometown = hometown;
    }

    public Hours getHours() {
        return this.hours;
    }

    public void setHours(Hours hours) {
        this.hours = hours;
    }

    public String getImpressum() {
        return this.impressum;
    }

    public void setImpressum(String impressum) {
        this.impressum = impressum;
    }

    public String getInfluences() {
        return this.influences;
    }

    public void setInfluences(String influences) {
        this.influences = influences;
    }

    public Boolean getIsPermanentlyClosed() {
        return this.isPermanentlyClosed;
    }

    public void setIsPermanentlyClosed(Boolean isPermanentlyClosed) {
        this.isPermanentlyClosed = isPermanentlyClosed;
    }

    public Business getOwnerBusiness() {
        return this.ownerBusiness;
    }

    public void setOwnerBusiness(Business ownerBusiness) {
        this.ownerBusiness = ownerBusiness;
    }

    public Double getOverallStarRating() {
        return this.overallStarRating;
    }

    public void setOverallStarRating(Double overallStarRating) {
        this.overallStarRating = overallStarRating;
    }

    public Integer getRatingCount() {
        return this.ratingCount;
    }

    public void setRatingCount(Integer ratingCount) {
        this.ratingCount = ratingCount;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public String getPersonalInfo() {
        return this.personalInfo;
    }

    public void setPersonalInfo(String personalInfo) {
        this.personalInfo = personalInfo;
    }

    public PagePaymentOptions getPaymentOptions() {
        return this.paymentOptions;
    }

    public void setPaymentOptions(PagePaymentOptions paymentOptions) {
        this.paymentOptions = paymentOptions;
    }

    public String getPersonalInterests() {
        return this.personalInterests;
    }

    public void setPersonalInterests(String personalInterests) {
        this.personalInterests = personalInterests;
    }

    public String getPharmaSafetyInfo() {
        return this.pharmaSafetyInfo;
    }

    public void setPharmaSafetyInfo(String pharmaSafetyInfo) {
        this.pharmaSafetyInfo = pharmaSafetyInfo;
    }

    public String getPlaceType() {
        return this.placeType;
    }

    public void setPlaceType(String placeType) {
        this.placeType = placeType;
    }

    public String getPlotOutline() {
        return this.plotOutline;
    }

    public void setPlotOutline(String plotOutline) {
        this.plotOutline = plotOutline;
    }

    public String getPriceRange() {
        return this.priceRange;
    }

    public void setPriceRange(String priceRange) {
        this.priceRange = priceRange;
    }

    public String getProducedBy() {
        return this.producedBy;
    }

    public void setProducedBy(String producedBy) {
        this.producedBy = producedBy;
    }

    public Boolean getPromotionEligible() {
        return this.promotionEligible;
    }

    public void setPromotionEligible(Boolean promotionEligible) {
        this.promotionEligible = promotionEligible;
    }

    public String getPromotionIneligibleReason() {
        return this.promotionIneligibleReason;
    }

    public void setPromotionIneligibleReason(String promotionIneligibleReason) {
        this.promotionIneligibleReason = promotionIneligibleReason;
    }

    public String getPublicTransit() {
        return this.publicTransit;
    }

    public void setPublicTransit(String publicTransit) {
        this.publicTransit = publicTransit;
    }

    public String getRecordLabel() {
        return this.recordLabel;
    }

    public void setRecordLabel(String recordLabel) {
        this.recordLabel = recordLabel;
    }

    public String getReleaseDate() {
        return this.releaseDate;
    }

    public void setReleaseDate(String releaseDate) {
        this.releaseDate = releaseDate;
    }

    public PageRestaurantServices getRestaurantServices() {
        return this.restaurantServices;
    }

    public void setRestaurantServices(PageRestaurantServices restaurantServices) {
        this.restaurantServices = restaurantServices;
    }

    public PageRestaurantSpecialties getRestaurantSpecialties() {
        return this.restaurantSpecialties;
    }

    public void setRestaurantSpecialties(PageRestaurantSpecialties restaurantSpecialties) {
        this.restaurantSpecialties = restaurantSpecialties;
    }

    public String getStoreCode() {
        return this.storeCode;
    }

    public void setStoreCode(String storeCode) {
        this.storeCode = storeCode;
    }

    public String getStoreLocationDescriptor() {
        return this.storeLocationDescriptor;
    }

    public void setStoreLocationDescriptor(String storeLocationDescriptor) {
        this.storeLocationDescriptor = storeLocationDescriptor;
    }

    public String getGenre() {
        return this.genre;
    }

    public void setGenre(String genre) {
        this.genre = genre;
    }

    public String getMpg() {
        return this.mpg;
    }

    public void setMpg(String mpg) {
        this.mpg = mpg;
    }

    public String getNetwork() {
        return this.network;
    }

    public void setNetwork(String network) {
        this.network = network;
    }

    public Long getNewLikeCount() {
        return this.newLikeCount;
    }

    public void setNewLikeCount(Long newLikeCount) {
        this.newLikeCount = newLikeCount;
    }

    public Boolean getOfferEligible() {
        return this.offerEligible;
    }

    public void setOfferEligible(Boolean offerEligible) {
        this.offerEligible = offerEligible;
    }

    public String getSchedule() {
        return this.schedule;
    }

    public void setSchedule(String schedule) {
        this.schedule = schedule;
    }

    public String getScreenplayBy() {
        return this.screenplayBy;
    }

    public void setScreenplayBy(String screenplayBy) {
        this.screenplayBy = screenplayBy;
    }

    public String getSeason() {
        return this.season;
    }

    public void setSeason(String season) {
        this.season = season;
    }

    public String getSingleLineAddress() {
        return this.singleLineAddress;
    }

    public void setSingleLineAddress(String singleLineAddress) {
        this.singleLineAddress = singleLineAddress;
    }

    public String getStarring() {
        return this.starring;
    }

    public void setStarring(String starring) {
        this.starring = starring;
    }

    public PageStartInfo getStartInfo() {
        return this.startInfo;
    }

    public void setStartInfo(PageStartInfo startInfo) {
        this.startInfo = startInfo;
    }

    public String getStoreNumber() {
        return this.storeNumber;
    }

    public void setStoreNumber(String storeNumber) {
        this.storeNumber = storeNumber;
    }

    public String getStudio() {
        return this.studio;
    }

    public void setStudio(String studio) {
        this.studio = studio;
    }

    public Engagement getEngagement() {
        return this.engagement;
    }

    public void setEngagement(Engagement engagement) {
        this.engagement = engagement;
    }

    public Long getUnreadMessageCount() {
        return this.unreadMessageCount;
    }

    public void setUnreadMessageCount(Long unreadMessageCount) {
        this.unreadMessageCount = unreadMessageCount;
    }

    public Long getUnreadNotifCount() {
        return this.unreadNotifCount;
    }

    public void setUnreadNotifCount(Long unreadNotifCount) {
        this.unreadNotifCount = unreadNotifCount;
    }

    public Long getUnseenMessageCount() {
        return this.unseenMessageCount;
    }

    public void setUnseenMessageCount(Long unseenMessageCount) {
        this.unseenMessageCount = unseenMessageCount;
    }

    public String getMembers() {
        return this.members;
    }

    public void setMembers(String members) {
        this.members = members;
    }

    public Long getWereHereCount() {
        return this.wereHereCount;
    }

    public void setWereHereCount(Long wereHereCount) {
        this.wereHereCount = wereHereCount;
    }

    public Video getFeaturedVideo() {
        return this.featuredVideo;
    }

    public void setFeaturedVideo(Video featuredVideo) {
        this.featuredVideo = featuredVideo;
    }

    public String getVerificationStatus() {
        return this.verificationStatus;
    }

    public void setVerificationStatus(String verificationStatus) {
        this.verificationStatus = verificationStatus;
    }

    public VoipInfo getVoipInfo() {
        return this.voipInfo;
    }

    public void setVoipInfo(VoipInfo voipInfo) {
        this.voipInfo = voipInfo;
    }

    public String getWrittenBy() {
        return this.writtenBy;
    }

    public void setWrittenBy(String writtenBy) {
        this.writtenBy = writtenBy;
    }

    public String getWhatsappNumber() {
        return this.whatsappNumber;
    }

    public void setWhatsappNumber(String whatsappNumber) {
        this.whatsappNumber = whatsappNumber;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getFounded() {
        return this.founded;
    }

    public void setFounded(String founded) {
        this.founded = founded;
    }

    public String getCompanyOverview() {
        return this.companyOverview;
    }

    public void setCompanyOverview(String companyOverview) {
        this.companyOverview = companyOverview;
    }

    public String getMission() {
        return this.mission;
    }

    public void setMission(String mission) {
        this.mission = mission;
    }

    public String getProducts() {
        return this.products;
    }

    public void setProducts(String products) {
        this.products = products;
    }

    public String getPageToken() {
        return this.pageToken;
    }

    public void setPageToken(String pageToken) {
        this.pageToken = pageToken;
    }

    public Page getParentPage() {
        return this.parentPage;
    }

    public void setParentPage(Page parentPage) {
        this.parentPage = parentPage;
    }

    public Boolean getLeadgenTosAccepted() {
        return this.leadgenTosAccepted;
    }

    public void setLeadgenTosAccepted(Boolean leadgenTosAccepted) {
        this.leadgenTosAccepted = leadgenTosAccepted;
    }

    @GraphAPI(until="2.5")
    public Long getLikesCount() {
        return this.likesCount;
    }

    public void setLikesCount(Long likesCount) {
        this.likesCount = likesCount;
    }

    @GraphAPI(since="2.6")
    public Likes getLikes() {
        return this.likes;
    }

    public void setLikes(Likes likes) {
        this.likes = likes;
    }

    @GraphAPI(since="2.6")
    public Long getFanCount() {
        return this.fanCount;
    }

    public void setFanCount(Long fanCount) {
        this.fanCount = fanCount;
    }

    public Boolean getIsAlwaysOpen() {
        return this.isAlwaysOpen;
    }

    public void setIsAlwaysOpen(Boolean isAlwaysOpen) {
        this.isAlwaysOpen = isAlwaysOpen;
    }

    public Boolean getIsChain() {
        return this.isChain;
    }

    public void setIsChain(Boolean isChain) {
        this.isChain = isChain;
    }

    public Boolean getIsCommunityPage() {
        return this.isCommunityPage;
    }

    public void setIsCommunityPage(Boolean isCommunityPage) {
        this.isCommunityPage = isCommunityPage;
    }

    public Boolean getIsEligibleForBrandedContent() {
        return this.isEligibleForBrandedContent;
    }

    public void setIsEligibleForBrandedContent(Boolean isEligibleForBrandedContent) {
        this.isEligibleForBrandedContent = isEligibleForBrandedContent;
    }

    public Boolean getIsMessengerBotGetStartedEnabled() {
        return this.isMessengerBotGetStartedEnabled;
    }

    public void setIsMessengerBotGetStartedEnabled(Boolean isMessengerBotGetStartedEnabled) {
        this.isMessengerBotGetStartedEnabled = isMessengerBotGetStartedEnabled;
    }

    public Boolean getIsMessengerPlatformBot() {
        return this.isMessengerPlatformBot;
    }

    public void setIsMessengerPlatformBot(Boolean isMessengerPlatformBot) {
        this.isMessengerPlatformBot = isMessengerPlatformBot;
    }

    public Boolean getIsOwned() {
        return this.isOwned;
    }

    public void setIsOwned(Boolean isOwned) {
        this.isOwned = isOwned;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescriptionHtml() {
        return this.descriptionHtml;
    }

    public void setDescriptionHtml(String descriptionHtml) {
        this.descriptionHtml = descriptionHtml;
    }

    public Integer getCheckins() {
        return this.checkins;
    }

    public void setCheckins(Integer checkins) {
        this.checkins = checkins;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public PageParking getParking() {
        return this.parking;
    }

    public void setParking(PageParking parking) {
        this.parking = parking;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getAbout() {
        return this.about;
    }

    public void setAbout(String about) {
        this.about = about;
    }

    public Long getTalkingAboutCount() {
        return this.talkingAboutCount;
    }

    public void setTalkingAboutCount(Long talkingAboutCount) {
        this.talkingAboutCount = talkingAboutCount;
    }

    public Boolean getCanCheckin() {
        return this.canCheckin;
    }

    public void setCanCheckin(Boolean canCheckin) {
        this.canCheckin = canCheckin;
    }

    public Boolean getCanPost() {
        return this.canPost;
    }

    public void setCanPost(Boolean canPost) {
        this.canPost = canPost;
    }

    public Boolean getIsPublished() {
        return this.isPublished;
    }

    public void setIsPublished(Boolean isPublished) {
        this.isPublished = isPublished;
    }

    public Boolean getIsUnclaimed() {
        return this.isUnclaimed;
    }

    public void setIsUnclaimed(Boolean isUnclaimed) {
        this.isUnclaimed = isUnclaimed;
    }

    @Deprecated
    public Boolean getIsVerified() {
        return this.isVerified;
    }

    @Deprecated
    public void setIsVerified(Boolean isVerified) {
        this.isVerified = isVerified;
    }

    @GraphAPI(since="2.7")
    public Boolean getIsWebhooksSubscribed() {
        return this.isWebhooksSubscribed;
    }

    public void setIsWebhooksSubscribed(Boolean isWebhooksSubscribed) {
        this.isWebhooksSubscribed = isWebhooksSubscribed;
    }

    public String getDirectedBy() {
        return this.directedBy;
    }

    public void setDirectedBy(String directedBy) {
        this.directedBy = directedBy;
    }

    public String getDisplaySubtext() {
        return this.displaySubtext;
    }

    public void setDisplaySubtext(String displaySubtext) {
        this.displaySubtext = displaySubtext;
    }

    public String getDisplayedMessageResponseTime() {
        return this.displayedMessageResponseTime;
    }

    public void setDisplayedMessageResponseTime(String displayedMessageResponseTime) {
        this.displayedMessageResponseTime = displayedMessageResponseTime;
    }

    public String getGeneralManager() {
        return this.generalManager;
    }

    public void setGeneralManager(String generalManager) {
        this.generalManager = generalManager;
    }

    public String getGeneralInfo() {
        return this.generalInfo;
    }

    public void setGeneralInfo(String generalInfo) {
        this.generalInfo = generalInfo;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public Cover getCover() {
        return this.cover;
    }

    public void setCover(Cover cover) {
        this.cover = cover;
    }

    public String getWebsite() {
        return this.website;
    }

    public void setWebsite(String website) {
        this.website = website;
    }

    public String getNameWithLocationDescriptor() {
        return this.nameWithLocationDescriptor;
    }

    public void setNameWithLocationDescriptor(String nameWithLocationDescriptor) {
        this.nameWithLocationDescriptor = nameWithLocationDescriptor;
    }

    public String getBookingAgent() {
        return this.bookingAgent;
    }

    public void setBookingAgent(String bookingAgent) {
        this.bookingAgent = bookingAgent;
    }

    public String getPressContact() {
        return this.pressContact;
    }

    public void setPressContact(String pressContact) {
        this.pressContact = pressContact;
    }

    public IgUser getConnectedInstagramAccount() {
        return this.connectedInstagramAccount;
    }

    public void setConnectedInstagramAccount(IgUser connectedInstagramAccount) {
        this.connectedInstagramAccount = connectedInstagramAccount;
    }

    public IgUser getInstagramBusinessAccount() {
        return this.instagramBusinessAccount;
    }

    public void setInstagramBusinessAccount(IgUser instagramBusinessAccount) {
        this.instagramBusinessAccount = instagramBusinessAccount;
    }

    public String getInstantArticlesReviewStatus() {
        return this.instantArticlesReviewStatus;
    }

    public void setInstantArticlesReviewStatus(String instantArticlesReviewStatus) {
        this.instantArticlesReviewStatus = instantArticlesReviewStatus;
    }

    public Date getLastUsedTime() {
        return this.lastUsedTime;
    }

    public void setLastUsedTime(Date lastUsedTime) {
        this.lastUsedTime = lastUsedTime;
    }

    public static class Settings
    extends AbstractFacebookType {
        private static final long serialVersionUID = 1L;
        @Facebook
        private String setting;
        @Facebook
        private String value;

        public boolean getValueAsBoolean() {
            return Boolean.parseBoolean(this.value);
        }

        public JsonObject getValueAsJsonObject() {
            return Json.parse(this.value).asObject();
        }

        public String getSetting() {
            return this.setting;
        }

        public void setSetting(String setting) {
            this.setting = setting;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class PageParking
    extends AbstractFacebookType {
        private static final long serialVersionUID = 1L;
        @Facebook
        private Boolean lot;
        @Facebook
        private Boolean street;
        @Facebook
        private Boolean valet;

        public Boolean getLot() {
            return this.lot;
        }

        public void setLot(Boolean lot) {
            this.lot = lot;
        }

        public Boolean getStreet() {
            return this.street;
        }

        public void setStreet(Boolean street) {
            this.street = street;
        }

        public Boolean getValet() {
            return this.valet;
        }

        public void setValet(Boolean valet) {
            this.valet = valet;
        }
    }

    public static class PageRestaurantSpecialties
    extends AbstractFacebookType {
        private static final long serialVersionUID = 1L;
        @Facebook
        private Boolean breakfast;
        @Facebook
        private Boolean coffee;
        @Facebook
        private Boolean dinner;
        @Facebook
        private Boolean drinks;
        @Facebook
        private Boolean lunch;

        public Boolean getBreakfast() {
            return this.breakfast;
        }

        public void setBreakfast(Boolean breakfast) {
            this.breakfast = breakfast;
        }

        public Boolean getCoffee() {
            return this.coffee;
        }

        public void setCoffee(Boolean coffee) {
            this.coffee = coffee;
        }

        public Boolean getDinner() {
            return this.dinner;
        }

        public void setDinner(Boolean dinner) {
            this.dinner = dinner;
        }

        public Boolean getDrinks() {
            return this.drinks;
        }

        public void setDrinks(Boolean drinks) {
            this.drinks = drinks;
        }

        public Boolean getLunch() {
            return this.lunch;
        }

        public void setLunch(Boolean lunch) {
            this.lunch = lunch;
        }
    }

    public static class PageRestaurantServices
    extends AbstractFacebookType {
        private static final long serialVersionUID = 1L;
        @Facebook
        private Boolean catering;
        @Facebook
        private Boolean delivery;
        @Facebook
        private Boolean groups;
        @Facebook
        private Boolean kids;
        @Facebook
        private Boolean outdoor;
        @Facebook
        private Boolean reserve;
        @Facebook
        private Boolean takeout;
        @Facebook
        private Boolean waiter;
        @Facebook
        private Boolean walkins;

        public Boolean getCatering() {
            return this.catering;
        }

        public void setCatering(Boolean catering) {
            this.catering = catering;
        }

        public Boolean getDelivery() {
            return this.delivery;
        }

        public void setDelivery(Boolean delivery) {
            this.delivery = delivery;
        }

        public Boolean getGroups() {
            return this.groups;
        }

        public void setGroups(Boolean groups) {
            this.groups = groups;
        }

        public Boolean getKids() {
            return this.kids;
        }

        public void setKids(Boolean kids) {
            this.kids = kids;
        }

        public Boolean getOutdoor() {
            return this.outdoor;
        }

        public void setOutdoor(Boolean outdoor) {
            this.outdoor = outdoor;
        }

        public Boolean getReserve() {
            return this.reserve;
        }

        public void setReserve(Boolean reserve) {
            this.reserve = reserve;
        }

        public Boolean getTakeout() {
            return this.takeout;
        }

        public void setTakeout(Boolean takeout) {
            this.takeout = takeout;
        }

        public Boolean getWaiter() {
            return this.waiter;
        }

        public void setWaiter(Boolean waiter) {
            this.waiter = waiter;
        }

        public Boolean getWalkins() {
            return this.walkins;
        }

        public void setWalkins(Boolean walkins) {
            this.walkins = walkins;
        }
    }

    public static class PagePaymentOptions
    extends AbstractFacebookType {
        private static final long serialVersionUID = 1L;
        @Facebook
        private Boolean amex;
        @Facebook(value="cash_only")
        private Boolean cashOnly;
        @Facebook
        private Boolean discover;
        @Facebook
        private Boolean mastercard;
        @Facebook
        private Boolean visa;

        public Boolean getAmex() {
            return this.amex;
        }

        public void setAmex(Boolean amex) {
            this.amex = amex;
        }

        public Boolean getCashOnly() {
            return this.cashOnly;
        }

        public void setCashOnly(Boolean cashOnly) {
            this.cashOnly = cashOnly;
        }

        public Boolean getDiscover() {
            return this.discover;
        }

        public void setDiscover(Boolean discover) {
            this.discover = discover;
        }

        public Boolean getMastercard() {
            return this.mastercard;
        }

        public void setMastercard(Boolean mastercard) {
            this.mastercard = mastercard;
        }

        public Boolean getVisa() {
            return this.visa;
        }

        public void setVisa(Boolean visa) {
            this.visa = visa;
        }
    }

    public static class PageStartDate
    extends AbstractFacebookType {
        private static final long serialVersionUID = 1L;
        @Facebook
        private Integer year;
        @Facebook
        private Integer month;
        @Facebook
        private Integer day;

        public Integer getYear() {
            return this.year;
        }

        public void setYear(Integer year) {
            this.year = year;
        }

        public Integer getMonth() {
            return this.month;
        }

        public void setMonth(Integer month) {
            this.month = month;
        }

        public Integer getDay() {
            return this.day;
        }

        public void setDay(Integer day) {
            this.day = day;
        }
    }

    public static class PageStartInfo
    extends AbstractFacebookType {
        private static final long serialVersionUID = 1L;
        @Facebook
        private String type;
        @Facebook
        private PageStartDate date;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public PageStartDate getDate() {
            return this.date;
        }

        public void setDate(PageStartDate date) {
            this.date = date;
        }
    }

    public static class VoipInfo
    extends AbstractFacebookType {
        private static final long serialVersionUID = 1L;
        @Facebook(value="has_permission")
        private Boolean hasPermission;
        @Facebook(value="has_mobile_app")
        private Boolean hasMobileApp;
        @Facebook(value="is_pushable")
        private Boolean isPushable;
        @Facebook(value="is_callable")
        private Boolean isCallable;
        @Facebook(value="is_callable_webrtc")
        private Boolean isCallableWebrtc;
        @Facebook(value="reason_code")
        private Long reasonCode;
        @Facebook(value="reason_description")
        private String reasonDescription;

        public Boolean getHasPermission() {
            return this.hasPermission;
        }

        public void setHasPermission(Boolean hasPermission) {
            this.hasPermission = hasPermission;
        }

        public Boolean getHasMobileApp() {
            return this.hasMobileApp;
        }

        public void setHasMobileApp(Boolean hasMobileApp) {
            this.hasMobileApp = hasMobileApp;
        }

        public Boolean getIsPushable() {
            return this.isPushable;
        }

        public void setIsPushable(Boolean isPushable) {
            this.isPushable = isPushable;
        }

        public Boolean getIsCallable() {
            return this.isCallable;
        }

        public void setIsCallable(Boolean isCallable) {
            this.isCallable = isCallable;
        }

        public Boolean getIsCallableWebrtc() {
            return this.isCallableWebrtc;
        }

        public void setIsCallableWebrtc(Boolean isCallableWebrtc) {
            this.isCallableWebrtc = isCallableWebrtc;
        }

        public Long getReasonCode() {
            return this.reasonCode;
        }

        public void setReasonCode(Long reasonCode) {
            this.reasonCode = reasonCode;
        }

        public String getReasonDescription() {
            return this.reasonDescription;
        }

        public void setReasonDescription(String reasonDescription) {
            this.reasonDescription = reasonDescription;
        }
    }

    public static class Engagement
    extends AbstractFacebookType {
        private static final long serialVersionUID = 1L;
        @Facebook
        private Long count;
        @Facebook(value="count_string")
        private String countString;
        @Facebook(value="count_string_with_like")
        private String countStringWithLike;
        @Facebook(value="count_string_without_like")
        private String countStringWithoutLike;
        @Facebook(value="social_sentence")
        private String socialSentence;
        @Facebook(value="social_sentence_with_like")
        private String socialSentenceWithLike;
        @Facebook(value="social_sentence_without_like")
        private String socialSentenceWithoutLike;

        public Long getCount() {
            return this.count;
        }

        public void setCount(Long count) {
            this.count = count;
        }

        public String getCountString() {
            return this.countString;
        }

        public void setCountString(String countString) {
            this.countString = countString;
        }

        public String getCountStringWithLike() {
            return this.countStringWithLike;
        }

        public void setCountStringWithLike(String countStringWithLike) {
            this.countStringWithLike = countStringWithLike;
        }

        public String getCountStringWithoutLike() {
            return this.countStringWithoutLike;
        }

        public void setCountStringWithoutLike(String countStringWithoutLike) {
            this.countStringWithoutLike = countStringWithoutLike;
        }

        public String getSocialSentence() {
            return this.socialSentence;
        }

        public void setSocialSentence(String socialSentence) {
            this.socialSentence = socialSentence;
        }

        public String getSocialSentenceWithLike() {
            return this.socialSentenceWithLike;
        }

        public void setSocialSentenceWithLike(String socialSentenceWithLike) {
            this.socialSentenceWithLike = socialSentenceWithLike;
        }

        public String getSocialSentenceWithoutLike() {
            return this.socialSentenceWithoutLike;
        }

        public void setSocialSentenceWithoutLike(String socialSentenceWithoutLike) {
            this.socialSentenceWithoutLike = socialSentenceWithoutLike;
        }
    }

    public static class MailingAddress
    extends AbstractFacebookType {
        private static final long serialVersionUID = 1L;
        @Facebook
        private String id;
        @Facebook
        private String city;
        @Facebook(value="city_page")
        private Page cityPage;
        @Facebook
        private String country;
        @Facebook
        private String street1;
        @Facebook
        private String street2;
        @Facebook
        private String region;
        @Facebook(value="postal_code")
        private String postalCode;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getCity() {
            return this.city;
        }

        public void setCity(String city) {
            this.city = city;
        }

        public Page getCityPage() {
            return this.cityPage;
        }

        public void setCityPage(Page cityPage) {
            this.cityPage = cityPage;
        }

        public String getCountry() {
            return this.country;
        }

        public void setCountry(String country) {
            this.country = country;
        }

        public String getStreet1() {
            return this.street1;
        }

        public void setStreet1(String street1) {
            this.street1 = street1;
        }

        public String getStreet2() {
            return this.street2;
        }

        public void setStreet2(String street2) {
            this.street2 = street2;
        }

        public String getRegion() {
            return this.region;
        }

        public void setRegion(String region) {
            this.region = region;
        }

        public String getPostalCode() {
            return this.postalCode;
        }

        public void setPostalCode(String postalCode) {
            this.postalCode = postalCode;
        }
    }

    public static class Cover
    extends AbstractFacebookType {
        @Facebook(value="cover_id")
        private String coverId;
        @Facebook
        private String source;
        @Facebook(value="offset_y")
        private Integer offsetY;
        private static final long serialVersionUID = 1L;

        public String getCoverId() {
            return this.coverId;
        }

        public void setCoverId(String coverId) {
            this.coverId = coverId;
        }

        public String getSource() {
            return this.source;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public Integer getOffsetY() {
            return this.offsetY;
        }

        public void setOffsetY(Integer offsetY) {
            this.offsetY = offsetY;
        }
    }

    public static class ScreenName
    extends AbstractFacebookType {
        private static final long serialVersionUID = 1L;
        @Facebook(value="service_name")
        private String serviceName;
        @Facebook
        private String value;

        public String getServiceName() {
            return this.serviceName;
        }

        public void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

