/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.types;

import com.restfb.Facebook;
import com.restfb.JsonMapper;
import com.restfb.json.Json;
import com.restfb.json.JsonValue;
import com.restfb.types.AbstractFacebookType;
import com.restfb.types.FacebookType;
import com.restfb.types.NamedFacebookType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class Message
extends FacebookType {
    @Facebook(value="created_time")
    private Date createdTime;
    @Facebook
    private String subject;
    @Facebook
    private NamedFacebookType from;
    @Facebook
    private List<NamedFacebookType> to = new ArrayList<NamedFacebookType>();
    @Facebook
    private String message;
    @Facebook
    private String sticker;
    @Facebook
    private List<Attachment> attachments = new ArrayList<Attachment>();
    @Facebook
    private List<Share> shares = new ArrayList<Share>();
    @Facebook(value="updated_time")
    private Date updatedTime;
    @Facebook
    private Integer unread;
    @Facebook
    private Boolean unseen;
    @Facebook(value="tags")
    private transient String rawTags;
    private List<String> tags = new ArrayList<String>();
    private static final long serialVersionUID = 1L;

    @JsonMapper.JsonMappingCompleted
    void convertTags() {
        JsonValue parsedObject;
        if (this.rawTags != null && (parsedObject = Json.parse(this.rawTags)).isObject() && parsedObject.asObject().get("data").isArray()) {
            for (JsonValue tagObject : parsedObject.asObject().get("data").asArray()) {
                this.tags.add(tagObject.asObject().get("name").asString());
            }
        }
    }

    public List<Attachment> getAttachments() {
        return this.attachments != null ? Collections.unmodifiableList(this.attachments) : null;
    }

    public boolean addAttachment(Attachment attachment) {
        return this.attachments.add(attachment);
    }

    public boolean removeAttachment(Attachment attachment) {
        return this.attachments.remove(attachment);
    }

    public List<Share> getShares() {
        return this.shares != null ? Collections.unmodifiableList(this.shares) : null;
    }

    public boolean addShare(Share share) {
        return this.shares.add(share);
    }

    public boolean removeShare(Share share) {
        return this.shares.remove(share);
    }

    public List<NamedFacebookType> getTo() {
        return Collections.unmodifiableList(this.to);
    }

    public boolean addTo(NamedFacebookType receiver) {
        return this.to.add(receiver);
    }

    public boolean removeTo(NamedFacebookType receiver) {
        return this.to.remove(receiver);
    }

    public List<String> getTags() {
        return Collections.unmodifiableList(this.tags);
    }

    public boolean addTag(String tag) {
        return this.tags.add(tag);
    }

    public boolean removeTag(String tag) {
        return this.tags.remove(tag);
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public NamedFacebookType getFrom() {
        return this.from;
    }

    public void setFrom(NamedFacebookType from) {
        this.from = from;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getSticker() {
        return this.sticker;
    }

    public void setSticker(String sticker) {
        this.sticker = sticker;
    }

    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    public void setUpdatedTime(Date updatedTime) {
        this.updatedTime = updatedTime;
    }

    public Integer getUnread() {
        return this.unread;
    }

    public void setUnread(Integer unread) {
        this.unread = unread;
    }

    public Boolean getUnseen() {
        return this.unseen;
    }

    public void setUnseen(Boolean unseen) {
        this.unseen = unseen;
    }

    public static abstract class AttachmentData
    extends AbstractFacebookType {
        private static final long serialVersionUID = 1L;
        @Facebook
        private int width;
        @Facebook
        private int height;
        @Facebook
        private String url;
        @Facebook(value="preview_url")
        private String previewUrl;

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getPreviewUrl() {
            return this.previewUrl;
        }

        public void setPreviewUrl(String previewUrl) {
            this.previewUrl = previewUrl;
        }
    }

    public static class VideoData
    extends AttachmentData {
        private static final long serialVersionUID = 1L;
        @Facebook
        private int length;
        @Facebook(value="video_type")
        private int videoType;
        @Facebook
        private int rotation;

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public int getVideoType() {
            return this.videoType;
        }

        public void setVideoType(int videoType) {
            this.videoType = videoType;
        }

        public int getRotation() {
            return this.rotation;
        }

        public void setRotation(int rotation) {
            this.rotation = rotation;
        }
    }

    public static class ImageData
    extends AttachmentData {
        private static final long serialVersionUID = 1L;
        @Facebook(value="max_width")
        private int maxWidth;
        @Facebook(value="max_height")
        private int maxHeight;
        @Facebook(value="render_as_sticker")
        private Boolean renderAsSticker;
        @Facebook(value="image_type")
        private int imageType;
        @Facebook(value="raw_gif_image")
        private String rawGifImage;
        @Facebook(value="raw_webp_image")
        private String rawWebpImage;
        @Facebook(value="animated_gif_url")
        private String animatedGifUrl;
        @Facebook(value="animated_gif_preview_url")
        private String animatedGifPreviewUrl;
        @Facebook(value="animated_webp_url")
        private String animatedWebpUrl;
        @Facebook(value="animated_webp_preview_url")
        private String animatedWebpPreviewUrl;

        public int getMaxWidth() {
            return this.maxWidth;
        }

        public void setMaxWidth(int maxWidth) {
            this.maxWidth = maxWidth;
        }

        public int getMaxHeight() {
            return this.maxHeight;
        }

        public void setMaxHeight(int maxHeight) {
            this.maxHeight = maxHeight;
        }

        public Boolean getRenderAsSticker() {
            return this.renderAsSticker;
        }

        public void setRenderAsSticker(Boolean renderAsSticker) {
            this.renderAsSticker = renderAsSticker;
        }

        public int getImageType() {
            return this.imageType;
        }

        public void setImageType(int imageType) {
            this.imageType = imageType;
        }

        public String getRawGifImage() {
            return this.rawGifImage;
        }

        public void setRawGifImage(String rawGifImage) {
            this.rawGifImage = rawGifImage;
        }

        public String getRawWebpImage() {
            return this.rawWebpImage;
        }

        public void setRawWebpImage(String rawWebpImage) {
            this.rawWebpImage = rawWebpImage;
        }

        public String getAnimatedGifUrl() {
            return this.animatedGifUrl;
        }

        public void setAnimatedGifUrl(String animatedGifUrl) {
            this.animatedGifUrl = animatedGifUrl;
        }

        public String getAnimatedGifPreviewUrl() {
            return this.animatedGifPreviewUrl;
        }

        public void setAnimatedGifPreviewUrl(String animatedGifPreviewUrl) {
            this.animatedGifPreviewUrl = animatedGifPreviewUrl;
        }

        public String getAnimatedWebpUrl() {
            return this.animatedWebpUrl;
        }

        public void setAnimatedWebpUrl(String animatedWebpUrl) {
            this.animatedWebpUrl = animatedWebpUrl;
        }

        public String getAnimatedWebpPreviewUrl() {
            return this.animatedWebpPreviewUrl;
        }

        public void setAnimatedWebpPreviewUrl(String animatedWebpPreviewUrl) {
            this.animatedWebpPreviewUrl = animatedWebpPreviewUrl;
        }
    }

    public static class Share
    extends NamedFacebookType {
        @Facebook
        private String link;
        @Facebook
        private String description;
        @Facebook
        private String picture;

        public String getLink() {
            return this.link;
        }

        public void setLink(String link) {
            this.link = link;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getPicture() {
            return this.picture;
        }

        public void setPicture(String picture) {
            this.picture = picture;
        }
    }

    public static class Attachment
    extends FacebookType {
        private static final long serialVersionUID = 1L;
        @Facebook
        private String name;
        @Facebook(value="mime_type")
        private String mimeType;
        @Facebook
        private Long size;
        @Facebook(value="file_url")
        private String fileUrl;
        @Facebook(value="image_data")
        private ImageData imageData;
        @Facebook(value="video_data")
        private VideoData videoData;

        public boolean isImage() {
            return null != this.imageData && null == this.videoData;
        }

        public boolean isVideo() {
            return null != this.videoData;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        public Long getSize() {
            return this.size;
        }

        public void setSize(Long size) {
            this.size = size;
        }

        public String getFileUrl() {
            return this.fileUrl;
        }

        public void setFileUrl(String fileUrl) {
            this.fileUrl = fileUrl;
        }

        public ImageData getImageData() {
            return this.imageData;
        }

        public void setImageData(ImageData imageData) {
            this.imageData = imageData;
        }

        public VideoData getVideoData() {
            return this.videoData;
        }

        public void setVideoData(VideoData videoData) {
            this.videoData = videoData;
        }
    }
}

