/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.types;

import com.restfb.Facebook;
import com.restfb.JsonMapper;
import com.restfb.json.Json;
import com.restfb.json.JsonObject;
import com.restfb.types.AbstractFacebookType;
import com.restfb.types.Comment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Comments
extends AbstractFacebookType {
    @Facebook(value="total_count")
    private Long totalCount = 0L;
    private String order;
    private Boolean canComment;
    @Facebook(value="comment_order")
    private String openGraphCommentOrder;
    @Facebook(value="can_comment")
    private Boolean openGraphCanComment;
    @Facebook
    private Long count = 0L;
    @Facebook
    private String summary = null;
    @Facebook
    private List<Comment> data = new ArrayList<Comment>();
    private static final long serialVersionUID = 1L;

    public List<Comment> getData() {
        return Collections.unmodifiableList(this.data);
    }

    public boolean addData(Comment comment) {
        return this.data.add(comment);
    }

    public boolean removeData(Comment comment) {
        return this.data.remove(comment);
    }

    @JsonMapper.JsonMappingCompleted
    private void fillFields() {
        JsonObject summaryObject = null;
        if (this.summary != null) {
            summaryObject = Json.parse(this.summary).asObject();
        }
        this.fillTotalCount(summaryObject);
        this.fillOrder(summaryObject);
        this.fillCanComment(summaryObject);
    }

    private void fillTotalCount(JsonObject summary) {
        if (this.totalCount == 0L && summary != null && summary.get("total_count") != null) {
            this.totalCount = summary.getLong("total_count", this.totalCount);
        }
        if (this.totalCount == 0L && this.count != 0L) {
            this.totalCount = this.count;
        }
    }

    private void fillOrder(JsonObject summary) {
        if (summary != null) {
            this.order = summary.getString("order", this.order);
        }
        if (this.order == null && this.openGraphCommentOrder != null) {
            this.order = this.openGraphCommentOrder;
        }
    }

    private void fillCanComment(JsonObject summary) {
        if (summary != null && summary.get("can_comment") != null) {
            this.canComment = summary.get("can_comment").asBoolean();
        }
        if (this.canComment == null && this.openGraphCanComment != null) {
            this.canComment = this.openGraphCanComment;
        }
    }

    public Long getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(Long totalCount) {
        this.totalCount = totalCount;
    }

    public String getOrder() {
        return this.order;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public Boolean getCanComment() {
        return this.canComment;
    }

    public void setCanComment(Boolean canComment) {
        this.canComment = canComment;
    }
}

