/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.logging;

final class JulMessage {
    private static final String PLACEHOLDER = "{}";
    private static final char ESCAPE_SIGN = '\\';

    private JulMessage() {
        throw new IllegalStateException("JulMessage is a utility class");
    }

    static MessageTuple convertMessageString(String messagePattern, Object ... args) {
        int argsLength;
        Throwable throwable = null;
        if (args.length > 0 && args[args.length - 1] instanceof Throwable) {
            throwable = (Throwable)args[args.length - 1];
        }
        if (!messagePattern.contains(PLACEHOLDER)) {
            return new MessageTuple(messagePattern, throwable);
        }
        StringBuilder sb = new StringBuilder();
        int placeholderCount = 0;
        int k = 0;
        while (messagePattern.indexOf(PLACEHOLDER, k) != -1) {
            int l = messagePattern.indexOf(PLACEHOLDER, k);
            if (l == 0 || messagePattern.charAt(l - 1) != '\\') {
                sb.append(messagePattern, k, l);
                sb.append("%s");
                k = l + 2;
                ++placeholderCount;
                continue;
            }
            sb.append(messagePattern, k, l + 3);
            k = l + 3;
        }
        if (k < messagePattern.length()) {
            sb.append(messagePattern.substring(k));
        }
        int n = argsLength = throwable != null ? args.length - 1 : args.length;
        if (argsLength != placeholderCount) {
            throw new IllegalArgumentException("Placeholder count don't matches argument count (placeholders: " + placeholderCount + ", arguments: " + argsLength + ")");
        }
        Object[] trimmed = new Object[argsLength];
        System.arraycopy(args, 0, trimmed, 0, argsLength);
        return new MessageTuple(String.format(sb.toString(), trimmed), throwable);
    }

    static class MessageTuple {
        private final String message;
        private final Throwable throwable;

        MessageTuple(String message, Throwable throwable) {
            this.message = message;
            this.throwable = throwable;
        }

        public String getMessage() {
            return this.message;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }
    }
}

