/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.json;

import com.restfb.json.JsonWriter;
import java.io.Writer;

public class UnicodeJsonWriter
extends JsonWriter {
    UnicodeJsonWriter(Writer writer) {
        super(writer);
    }

    @Override
    protected char[] getReplacementChars(char ch) {
        if (ch == '\\') {
            return BS_CHARS;
        }
        if (ch == '\"') {
            return QUOT_CHARS;
        }
        if (ch == '\n') {
            return LF_CHARS;
        }
        if (ch == '\r') {
            return CR_CHARS;
        }
        if (ch == '\t') {
            return TAB_CHARS;
        }
        if (ch < ' ' || ch > '\u007f') {
            return new char[]{'\\', 'u', HEX_DIGITS[ch >> 12 & 0xF], HEX_DIGITS[ch >> 8 & 0xF], HEX_DIGITS[ch >> 4 & 0xF], HEX_DIGITS[ch & 0xF]};
        }
        return NO_CHARS;
    }
}

