/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.json;

import com.restfb.json.JsonArray;
import com.restfb.json.JsonObject;
import com.restfb.json.JsonWriter;
import com.restfb.json.WriterConfig;
import com.restfb.json.WritingBuffer;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Objects;

public abstract class JsonValue
implements Serializable {
    private static final String NOT_A_NUMBER = "Not a number: ";
    private static final String NOT_A_STRING = "Not a string: ";
    private static final String NOT_A_BOOLEAN = "Not a boolean: ";
    protected static final String STRING_IS_NULL = "string is null";
    protected static final String OBJECT_IS_NULL = "object is null";
    protected static final String NAME_IS_NULL = "name is null";
    protected static final String VALUE_IS_NULL = "value is null";
    protected static final String ARRAY_IS_NULL = "array is null";

    JsonValue() {
    }

    public boolean isObject() {
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isNumber() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean isTrue() {
        return false;
    }

    public boolean isFalse() {
        return false;
    }

    public boolean isNull() {
        return false;
    }

    public JsonObject asObject() {
        throw new UnsupportedOperationException("Not an object: " + this.toString());
    }

    public JsonArray asArray() {
        throw new UnsupportedOperationException("Not an array: " + this.toString());
    }

    public int asInt() {
        throw new UnsupportedOperationException(NOT_A_NUMBER + this.toString());
    }

    public long asLong() {
        throw new UnsupportedOperationException(NOT_A_NUMBER + this.toString());
    }

    public float asFloat() {
        throw new UnsupportedOperationException(NOT_A_NUMBER + this.toString());
    }

    public double asDouble() {
        throw new UnsupportedOperationException(NOT_A_NUMBER + this.toString());
    }

    public String asString() {
        throw new UnsupportedOperationException(NOT_A_STRING + this.toString());
    }

    public boolean asBoolean() {
        throw new UnsupportedOperationException(NOT_A_BOOLEAN + this.toString());
    }

    public void writeTo(Writer writer) throws IOException {
        this.writeTo(writer, WriterConfig.MINIMAL);
    }

    public void writeTo(Writer writer, WriterConfig config) throws IOException {
        Objects.requireNonNull(writer, "writer is null");
        Objects.requireNonNull(config, "config is null");
        WritingBuffer buffer = new WritingBuffer(writer, 128);
        this.write(config.createWriter(buffer));
        buffer.flush();
    }

    public String toString() {
        return this.toString(WriterConfig.UNICODE);
    }

    public String toString(WriterConfig config) {
        StringWriter writer = new StringWriter();
        try {
            this.writeTo(writer, config);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        return writer.toString();
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public int hashCode() {
        return super.hashCode();
    }

    abstract void write(JsonWriter var1) throws IOException;
}

