/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.exception.generator;

import com.restfb.exception.ExceptionInformation;
import com.restfb.exception.FacebookException;
import com.restfb.exception.FacebookExceptionMapper;
import com.restfb.exception.FacebookGraphException;
import com.restfb.exception.FacebookJsonMappingException;
import com.restfb.exception.FacebookOAuthException;
import com.restfb.exception.FacebookQueryParseException;
import com.restfb.exception.ResponseErrorJsonParsingException;
import com.restfb.exception.generator.FacebookExceptionGenerator;
import com.restfb.json.Json;
import com.restfb.json.JsonObject;
import com.restfb.json.ParseException;
import com.restfb.util.StringUtils;
import java.util.Optional;

public class DefaultFacebookExceptionGenerator
implements FacebookExceptionGenerator {
    protected FacebookExceptionMapper graphFacebookExceptionMapper = this.createGraphFacebookExceptionMapper();

    @Override
    public void throwFacebookResponseStatusExceptionIfNecessary(String json, Integer httpStatusCode) {
        try {
            this.skipResponseStatusExceptionParsing(json);
            this.throwBatchFacebookResponseStatusExceptionIfNecessary(json, httpStatusCode);
            JsonObject errorObject = Json.parse(json).asObject();
            if (!errorObject.contains("error")) {
                return;
            }
            ExceptionInformation container = this.createFacebookResponseTypeAndMessageContainer(errorObject, httpStatusCode);
            throw this.graphFacebookExceptionMapper.exceptionForTypeAndMessage(container);
        }
        catch (ParseException e) {
            throw new FacebookJsonMappingException("Unable to process the Facebook API response", e);
        }
        catch (ResponseErrorJsonParsingException responseErrorJsonParsingException) {
            return;
        }
    }

    protected ExceptionInformation createFacebookResponseTypeAndMessageContainer(JsonObject errorObject, Integer httpStatusCode) {
        JsonObject innerErrorObject = errorObject.get("error").asObject();
        Integer errorCode = Optional.ofNullable(innerErrorObject.get("code")).map(obj -> StringUtils.toInteger(obj.toString())).orElse(null);
        Integer errorSubcode = Optional.ofNullable(innerErrorObject.get("error_subcode")).map(obj -> StringUtils.toInteger(obj.toString())).orElse(null);
        return new ExceptionInformation(errorCode, errorSubcode, httpStatusCode, innerErrorObject.getString("type", null), innerErrorObject.get("message").asString(), innerErrorObject.getString("error_user_title", null), innerErrorObject.getString("error_user_msg", null), innerErrorObject.getBoolean("is_transient", false), errorObject);
    }

    @Override
    public void throwBatchFacebookResponseStatusExceptionIfNecessary(String json, Integer httpStatusCode) {
        try {
            this.skipResponseStatusExceptionParsing(json);
            JsonObject errorObject = this.silentlyCreateObjectFromString(json);
            if (errorObject == null || errorObject.contains("error") || errorObject.contains("error_description")) {
                return;
            }
            ExceptionInformation container = new ExceptionInformation(errorObject.getInt("error", 0), httpStatusCode, errorObject.getString("error_description", null), errorObject);
            throw this.graphFacebookExceptionMapper.exceptionForTypeAndMessage(container);
        }
        catch (ParseException e) {
            throw new FacebookJsonMappingException("Unable to process the Facebook API response", e);
        }
        catch (ResponseErrorJsonParsingException responseErrorJsonParsingException) {
            return;
        }
    }

    protected FacebookExceptionMapper createGraphFacebookExceptionMapper() {
        return new DefaultGraphFacebookExceptionMapper();
    }

    protected void skipResponseStatusExceptionParsing(String json) throws ResponseErrorJsonParsingException {
        if (!json.startsWith("{")) {
            throw new ResponseErrorJsonParsingException();
        }
        int subStrEnd = Math.min(50, json.length());
        if (!json.substring(0, subStrEnd).contains("\"error\"")) {
            throw new ResponseErrorJsonParsingException();
        }
    }

    protected JsonObject silentlyCreateObjectFromString(String json) {
        JsonObject errorObject = null;
        try {
            errorObject = Json.parse(json).asObject();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return errorObject;
    }

    protected static class DefaultGraphFacebookExceptionMapper
    implements FacebookExceptionMapper {
        protected DefaultGraphFacebookExceptionMapper() {
        }

        @Override
        public FacebookException exceptionForTypeAndMessage(ExceptionInformation container) {
            if ("OAuthException".equals(container.getType()) || "OAuthAccessTokenException".equals(container.getType())) {
                return new FacebookOAuthException(container.getType(), container.getMessage(), container.getErrorCode(), container.getErrorSubcode(), container.getHttpStatusCode(), container.getUserTitle(), container.getUserMessage(), container.getIsTransient(), container.getRawError());
            }
            if ("QueryParseException".equals(container.getType())) {
                return new FacebookQueryParseException(container.getType(), container.getMessage(), container.getErrorCode(), container.getErrorSubcode(), container.getHttpStatusCode(), container.getUserTitle(), container.getUserMessage(), container.getIsTransient(), container.getRawError());
            }
            return new FacebookGraphException(container.getType(), container.getMessage(), container.getErrorCode(), container.getErrorSubcode(), container.getHttpStatusCode(), container.getUserTitle(), container.getUserMessage(), container.getIsTransient(), container.getRawError());
        }
    }
}

