/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.exception.devicetoken;

import com.restfb.exception.FacebookOAuthException;
import com.restfb.exception.devicetoken.FacebookDeviceTokenCodeExpiredException;
import com.restfb.exception.devicetoken.FacebookDeviceTokenDeclinedException;
import com.restfb.exception.devicetoken.FacebookDeviceTokenPendingException;
import com.restfb.exception.devicetoken.FacebookDeviceTokenSlowdownException;

public class DeviceTokenExceptionFactory {
    private DeviceTokenExceptionFactory() {
    }

    public static void createFrom(FacebookOAuthException oauthException) throws FacebookDeviceTokenCodeExpiredException, FacebookDeviceTokenPendingException, FacebookDeviceTokenDeclinedException, FacebookDeviceTokenSlowdownException {
        String errorMessage = oauthException.getErrorMessage();
        if ("authorization_pending".equals(errorMessage) || oauthException.getErrorSubcode() == 1349174) {
            throw new FacebookDeviceTokenPendingException(errorMessage, oauthException);
        }
        if ("authorization_declined".equals(errorMessage)) {
            throw new FacebookDeviceTokenDeclinedException(errorMessage, oauthException);
        }
        if ("slow_down".equals(errorMessage) || oauthException.getErrorSubcode() == 1349172) {
            throw new FacebookDeviceTokenSlowdownException(errorMessage, oauthException);
        }
        if ("code_expired".equals(errorMessage) || oauthException.getErrorSubcode() == 1349152) {
            throw new FacebookDeviceTokenCodeExpiredException(errorMessage, oauthException);
        }
        throw oauthException;
    }
}

