/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.batch;

import com.restfb.Facebook;
import com.restfb.Parameter;
import com.restfb.batch.BatchHeader;
import com.restfb.util.ReflectionUtils;
import com.restfb.util.UrlUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class BatchRequest {
    @Facebook
    private String method;
    @Facebook(value="relative_url")
    private String relativeUrl;
    @Facebook
    private String body;
    @Facebook(value="attached_files")
    private String attachedFiles;
    @Facebook(value="depends_on")
    private String dependsOn;
    @Facebook
    private String name;
    @Facebook(value="omit_response_on_success")
    private boolean omitResponseOnSuccess;
    @Facebook
    private List<BatchHeader> headers;

    protected BatchRequest(String relativeUrl, List<Parameter> parameters, String method, List<BatchHeader> headers, List<Parameter> bodyParameters, String attachedFiles, String dependsOn, String name, boolean omitResponseOnSuccess) {
        this.relativeUrl = Optional.ofNullable(relativeUrl).orElseThrow(() -> new IllegalArgumentException("The 'relativeUrl' parameter is required."));
        this.method = method;
        this.headers = headers;
        this.attachedFiles = attachedFiles;
        this.dependsOn = dependsOn;
        this.name = name;
        this.omitResponseOnSuccess = omitResponseOnSuccess;
        if (!parameters.isEmpty()) {
            this.relativeUrl = String.format(!this.relativeUrl.contains("?") ? "%s?%s" : "%s&%s", this.relativeUrl, this.generateParameterString(parameters));
        }
        this.body = this.generateParameterString(bodyParameters);
    }

    protected String generateParameterString(List<Parameter> parameters) {
        if (parameters == null) {
            return "";
        }
        return parameters.stream().map(p -> UrlUtils.urlEncode(p.name) + "=" + UrlUtils.urlEncode(p.value)).collect(Collectors.joining("&"));
    }

    public int hashCode() {
        return ReflectionUtils.hashCode(this);
    }

    public boolean equals(Object that) {
        return ReflectionUtils.equals(this, that);
    }

    public String toString() {
        return ReflectionUtils.toString(this);
    }

    public String getMethod() {
        return this.method;
    }

    public String getRelativeUrl() {
        return this.relativeUrl;
    }

    public String getBody() {
        return this.body;
    }

    public String getAttachedFiles() {
        return this.attachedFiles;
    }

    public String getName() {
        return this.name;
    }

    public String getDependsOn() {
        return this.dependsOn;
    }

    public boolean isOmitResponseOnSuccess() {
        return this.omitResponseOnSuccess;
    }

    public List<BatchHeader> getHeaders() {
        return Collections.unmodifiableList(this.headers);
    }

    public static class BatchRequestBuilder {
        private String method = "GET";
        private String relativeUrl;
        private List<Parameter> parameters = new ArrayList<Parameter>();
        private List<BatchHeader> headers = new ArrayList<BatchHeader>();
        private List<Parameter> bodyParameters = new ArrayList<Parameter>();
        private String attachedFiles;
        private String dependsOn;
        private String name;
        private boolean omitResponseOnSuccess;

        public BatchRequestBuilder(String relativeUrl) {
            this.relativeUrl = relativeUrl;
        }

        public BatchRequestBuilder method(String method) {
            this.method = method;
            return this;
        }

        public BatchRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public BatchRequestBuilder headers(BatchHeader ... headers) {
            this.headers.clear();
            this.headers.addAll(Arrays.asList(headers));
            return this;
        }

        public BatchRequestBuilder body(Parameter ... parameters) {
            this.bodyParameters.clear();
            this.bodyParameters.addAll(Arrays.asList(parameters));
            return this;
        }

        public BatchRequestBuilder attachedFiles(String attachedFiles) {
            this.attachedFiles = attachedFiles;
            return this;
        }

        public BatchRequestBuilder dependsOn(String dependsOn) {
            this.dependsOn = dependsOn;
            return this;
        }

        public BatchRequestBuilder omitResponseOnSuccess(boolean omitResponseOnSuccess) {
            this.omitResponseOnSuccess = omitResponseOnSuccess;
            return this;
        }

        public BatchRequestBuilder parameters(Parameter ... parameters) {
            this.parameters.clear();
            this.parameters.addAll(Arrays.asList(parameters));
            return this;
        }

        public BatchRequest build() {
            return new BatchRequest(this.relativeUrl, this.parameters, this.method, this.headers, this.bodyParameters, this.attachedFiles, this.dependsOn, this.name, this.omitResponseOnSuccess);
        }
    }
}

