/*
 * Decompiled with CFR 0.152.
 */
package com.restfb;

import com.restfb.BinaryAttachment;
import com.restfb.DebugHeaderInfo;
import com.restfb.util.StringUtils;
import java.io.IOException;
import java.util.List;

public interface WebRequestor {
    public Response executeGet(String var1) throws IOException;

    public Response executePost(String var1, String var2) throws IOException;

    public Response executePost(String var1, String var2, List<BinaryAttachment> var3) throws IOException;

    public Response executeDelete(String var1) throws IOException;

    public DebugHeaderInfo getDebugHeaderInfo();

    public static class Response {
        private Integer statusCode;
        private String body;

        public Response(Integer statusCode, String body) {
            this.statusCode = statusCode;
            this.body = StringUtils.trimToEmpty(body);
        }

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public String getBody() {
            return this.body;
        }

        public String toString() {
            if (StringUtils.isBlank(this.getBody())) {
                return String.format("HTTP status code %d and an empty response body.", this.getStatusCode());
            }
            return String.format("HTTP status code %d and response body: %s", this.getStatusCode(), this.getBody());
        }
    }
}

