/*
 * Decompiled with CFR 0.152.
 */
package com.restfb;

import com.restfb.DefaultJsonMapper;
import com.restfb.JsonMapper;
import com.restfb.util.StringUtils;
import java.util.Optional;

public final class Parameter {
    public final String name;
    public final String value;

    private Parameter(String name, Object value, JsonMapper jsonMapper) {
        if (StringUtils.isBlank(name) || value == null) {
            throw new IllegalArgumentException(Parameter.class + " instances must have a non-blank name and non-null value. Got instead name:" + name + ", value:" + value);
        }
        this.value = Optional.ofNullable(jsonMapper).orElseThrow(() -> new IllegalArgumentException("Provided " + JsonMapper.class + " must not be null.")).toJson(value, true);
        this.name = StringUtils.trimToEmpty(name);
    }

    public static Parameter with(String name, Object value) {
        return Parameter.with(name, value, new DefaultJsonMapper());
    }

    public static Parameter with(String name, Object value, JsonMapper jsonMapper) {
        return new Parameter(name, value, jsonMapper);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        Parameter other = (Parameter)obj;
        if (this.name != other.name && !this.name.equals(other.name)) {
            return false;
        }
        return this.value == other.value || this.value.equals(other.value);
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + this.name.hashCode();
        hash = 41 * hash + this.value.hashCode();
        return hash;
    }

    public String toString() {
        return String.format("Parameter[%s=%s]", this.name, this.value);
    }
}

