/*
 * Decompiled with CFR 0.152.
 */
package com.restfb;

import com.restfb.BinaryAttachment;
import com.restfb.DebugHeaderInfo;
import com.restfb.Version;
import com.restfb.WebRequestor;
import com.restfb.logging.RestFBLogger;
import com.restfb.util.StringUtils;
import com.restfb.util.UrlUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class DefaultWebRequestor
implements WebRequestor {
    private static final String MULTIPART_BOUNDARY = "**boundarystringwhichwill**neverbeencounteredinthewild**";
    private static final String MULTIPART_CARRIAGE_RETURN_AND_NEWLINE = "\r\n";
    private static final String MULTIPART_TWO_HYPHENS = "--";
    private static final int MULTIPART_DEFAULT_BUFFER_SIZE = 8192;
    private static final int DEFAULT_READ_TIMEOUT_IN_MS = 180000;
    private Map<String, List<String>> currentHeaders;
    private DebugHeaderInfo debugHeaderInfo;
    private boolean autocloseBinaryAttachmentStream = true;

    @Override
    public WebRequestor.Response executeGet(String url) throws IOException {
        return this.execute(url, HttpMethod.GET);
    }

    @Override
    public WebRequestor.Response executePost(String url, String parameters) throws IOException {
        return this.executePost(url, parameters, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebRequestor.Response executePost(String url, String parameters, List<BinaryAttachment> binaryAttachments) throws IOException {
        WebRequestor.Response response;
        OutputStream outputStream;
        HttpURLConnection httpUrlConnection;
        block8: {
            binaryAttachments = Optional.ofNullable(binaryAttachments).orElse(new ArrayList());
            if (RestFBLogger.HTTP_LOGGER.isDebugEnabled()) {
                RestFBLogger.HTTP_LOGGER.debug("Executing a POST to " + url + " with parameters " + (!binaryAttachments.isEmpty() ? "" : "(sent in request body): ") + UrlUtils.urlDecode(parameters) + (!binaryAttachments.isEmpty() ? " and " + binaryAttachments.size() + " binary attachment[s]." : ""), new Object[0]);
            }
            httpUrlConnection = null;
            outputStream = null;
            try {
                httpUrlConnection = this.openConnection(new URL(url + (!binaryAttachments.isEmpty() ? "?" + parameters : "")));
                httpUrlConnection.setReadTimeout(180000);
                this.customizeConnection(httpUrlConnection);
                httpUrlConnection.setRequestMethod(HttpMethod.POST.name());
                httpUrlConnection.setDoOutput(true);
                httpUrlConnection.setUseCaches(false);
                if (!binaryAttachments.isEmpty()) {
                    httpUrlConnection.setRequestProperty("Connection", "Keep-Alive");
                    httpUrlConnection.setRequestProperty("Content-Type", "multipart/form-data;boundary=**boundarystringwhichwill**neverbeencounteredinthewild**");
                }
                httpUrlConnection.connect();
                outputStream = httpUrlConnection.getOutputStream();
                if (!binaryAttachments.isEmpty()) {
                    for (BinaryAttachment binaryAttachment2 : binaryAttachments) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append(MULTIPART_TWO_HYPHENS).append(MULTIPART_BOUNDARY).append(MULTIPART_CARRIAGE_RETURN_AND_NEWLINE).append("Content-Disposition: form-data; name=\"").append(this.createFormFieldName(binaryAttachment2)).append("\"; filename=\"").append(binaryAttachment2.getFilename()).append("\"");
                        stringBuilder.append(MULTIPART_CARRIAGE_RETURN_AND_NEWLINE).append("Content-Type: ").append(binaryAttachment2.getContentType());
                        stringBuilder.append(MULTIPART_CARRIAGE_RETURN_AND_NEWLINE).append(MULTIPART_CARRIAGE_RETURN_AND_NEWLINE);
                        outputStream.write(stringBuilder.toString().getBytes(StringUtils.ENCODING_CHARSET));
                        this.write(binaryAttachment2.getData(), outputStream, 8192);
                        outputStream.write("\r\n--**boundarystringwhichwill**neverbeencounteredinthewild**--\r\n".getBytes(StringUtils.ENCODING_CHARSET));
                    }
                } else {
                    outputStream.write(parameters.getBytes(StringUtils.ENCODING_CHARSET));
                }
                RestFBLogger.HTTP_LOGGER.debug("Response headers: {}", httpUrlConnection.getHeaderFields());
                this.fillHeaderAndDebugInfo(httpUrlConnection);
                WebRequestor.Response response2 = this.fetchResponse(httpUrlConnection);
                RestFBLogger.HTTP_LOGGER.debug("Facebook responded with {}", response2);
                response = response2;
                if (!this.autocloseBinaryAttachmentStream || binaryAttachments.isEmpty()) break block8;
            }
            catch (Throwable throwable) {
                if (this.autocloseBinaryAttachmentStream && !binaryAttachments.isEmpty()) {
                    binaryAttachments.forEach(binaryAttachment -> this.closeQuietly(binaryAttachment.getData()));
                }
                this.closeQuietly(outputStream);
                this.closeQuietly(httpUrlConnection);
                throw throwable;
            }
            binaryAttachments.forEach(binaryAttachment -> this.closeQuietly(binaryAttachment.getData()));
        }
        this.closeQuietly(outputStream);
        this.closeQuietly(httpUrlConnection);
        return response;
    }

    protected HttpURLConnection openConnection(URL url) throws IOException {
        return (HttpURLConnection)url.openConnection();
    }

    protected void customizeConnection(HttpURLConnection connection) {
    }

    protected void closeQuietly(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Exception t) {
            RestFBLogger.HTTP_LOGGER.warn("Unable to close {}: ", closeable, t);
        }
    }

    protected void closeQuietly(HttpURLConnection httpUrlConnection) {
        if (httpUrlConnection == null) {
            return;
        }
        try {
            httpUrlConnection.disconnect();
        }
        catch (Exception t) {
            RestFBLogger.HTTP_LOGGER.warn("Unable to disconnect {}: ", httpUrlConnection, t);
        }
    }

    protected void write(InputStream source, OutputStream destination, int bufferSize) throws IOException {
        int read;
        if (source == null || destination == null) {
            throw new IllegalArgumentException("Must provide non-null source and destination streams.");
        }
        byte[] chunk = new byte[bufferSize];
        while ((read = source.read(chunk)) > 0) {
            destination.write(chunk, 0, read);
        }
    }

    protected String createFormFieldName(BinaryAttachment binaryAttachment) {
        if (binaryAttachment.getFieldName() != null) {
            return binaryAttachment.getFieldName();
        }
        String name = binaryAttachment.getFilename();
        int fileExtensionIndex = name.lastIndexOf(46);
        return fileExtensionIndex > 0 ? name.substring(0, fileExtensionIndex) : name;
    }

    public boolean isAutocloseBinaryAttachmentStream() {
        return this.autocloseBinaryAttachmentStream;
    }

    public void setAutocloseBinaryAttachmentStream(boolean autocloseBinaryAttachmentStream) {
        this.autocloseBinaryAttachmentStream = autocloseBinaryAttachmentStream;
    }

    public Map<String, List<String>> getCurrentHeaders() {
        return this.currentHeaders;
    }

    @Override
    public WebRequestor.Response executeDelete(String url) throws IOException {
        return this.execute(url, HttpMethod.DELETE);
    }

    @Override
    public DebugHeaderInfo getDebugHeaderInfo() {
        return this.debugHeaderInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WebRequestor.Response execute(String url, HttpMethod httpMethod) throws IOException {
        RestFBLogger.HTTP_LOGGER.debug("Making a {} request to {}", httpMethod.name(), url);
        HttpURLConnection httpUrlConnection = null;
        try {
            httpUrlConnection = this.openConnection(new URL(url));
            httpUrlConnection.setReadTimeout(180000);
            httpUrlConnection.setUseCaches(false);
            httpUrlConnection.setRequestMethod(httpMethod.name());
            this.customizeConnection(httpUrlConnection);
            httpUrlConnection.connect();
            RestFBLogger.HTTP_LOGGER.trace("Response headers: {}", httpUrlConnection.getHeaderFields());
            this.fillHeaderAndDebugInfo(httpUrlConnection);
            WebRequestor.Response response = this.fetchResponse(httpUrlConnection);
            RestFBLogger.HTTP_LOGGER.debug("Facebook responded with {}", response);
            WebRequestor.Response response2 = response;
            this.closeQuietly(httpUrlConnection);
            return response2;
        }
        catch (Throwable throwable) {
            this.closeQuietly(httpUrlConnection);
            throw throwable;
        }
    }

    protected void fillHeaderAndDebugInfo(HttpURLConnection httpUrlConnection) {
        this.currentHeaders = Collections.unmodifiableMap(httpUrlConnection.getHeaderFields());
        String usedApiVersion = StringUtils.trimToEmpty(httpUrlConnection.getHeaderField("facebook-api-version"));
        RestFBLogger.HTTP_LOGGER.debug("Facebook used the API {} to answer your request", usedApiVersion);
        String fbTraceId = StringUtils.trimToEmpty(httpUrlConnection.getHeaderField("x-fb-trace-id"));
        String fbRev = StringUtils.trimToEmpty(httpUrlConnection.getHeaderField("x-fb-rev"));
        String fbDebug = StringUtils.trimToEmpty(httpUrlConnection.getHeaderField("x-fb-debug"));
        String fbAppUsage = StringUtils.trimToEmpty(httpUrlConnection.getHeaderField("x-app-usage"));
        String fbPageUsage = StringUtils.trimToEmpty(httpUrlConnection.getHeaderField("x-page-usage"));
        String fbAdAccountUsage = StringUtils.trimToEmpty(httpUrlConnection.getHeaderField("x-ad-account-usage"));
        String fbBusinessUseCaseUsage = StringUtils.trimToEmpty(httpUrlConnection.getHeaderField("x-business-use-case-usage"));
        Version usedVersion = Version.getVersionFromString(usedApiVersion);
        this.debugHeaderInfo = DebugHeaderInfo.DebugHeaderInfoFactory.create().setVersion(usedVersion).setTraceId(fbTraceId).setDebug(fbDebug).setRev(fbRev).setAppUsage(fbAppUsage).setPageUsage(fbPageUsage).setAdAccountUsage(fbAdAccountUsage).setBusinessUseCaseUsage(fbBusinessUseCaseUsage).build();
    }

    protected WebRequestor.Response fetchResponse(HttpURLConnection httpUrlConnection) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = httpUrlConnection.getResponseCode() != 200 ? httpUrlConnection.getErrorStream() : httpUrlConnection.getInputStream();
        }
        catch (IOException e) {
            RestFBLogger.HTTP_LOGGER.warn("An error occurred while making a {} request to {}:", httpUrlConnection.getRequestMethod(), httpUrlConnection.getURL(), e);
        }
        return new WebRequestor.Response(httpUrlConnection.getResponseCode(), StringUtils.fromInputStream(inputStream));
    }

    protected static enum HttpMethod {
        GET,
        DELETE,
        POST;

    }
}

