/*
 * Decompiled with CFR 0.152.
 */
package com.restfb;

import com.restfb.Facebook;
import com.restfb.JsonHelper;
import com.restfb.JsonMapper;
import com.restfb.exception.FacebookJsonMappingException;
import com.restfb.json.Json;
import com.restfb.json.JsonArray;
import com.restfb.json.JsonObject;
import com.restfb.json.JsonValue;
import com.restfb.json.ParseException;
import com.restfb.logging.RestFBLogger;
import com.restfb.types.Comments;
import com.restfb.util.DateUtils;
import com.restfb.util.ObjectUtil;
import com.restfb.util.ReflectionUtils;
import com.restfb.util.StringJsonUtils;
import com.restfb.util.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class DefaultJsonMapper
implements JsonMapper {
    private final JsonHelper jsonHelper = new JsonHelper();

    @Override
    public <T> List<T> toJavaList(String json, Class<T> type) {
        type = Optional.ofNullable(type).orElseThrow(() -> new FacebookJsonMappingException("You must specify the Java type to map to."));
        if (StringUtils.isBlank(json = StringUtils.trimToEmpty(json))) {
            throw new FacebookJsonMappingException("JSON is an empty string - can't map it.");
        }
        if (StringJsonUtils.isObject(json)) {
            if (StringJsonUtils.isEmptyObject(json)) {
                RestFBLogger.MAPPER_LOGGER.trace("Encountered \\{} when we should've seen []. Mapping the \\{} as an empty list and moving on...", new Object[0]);
                return new ArrayList();
            }
            try {
                JsonObject jsonObject = Json.parse(json).asObject();
                List<String> fieldNames = jsonObject.names();
                if (!fieldNames.isEmpty()) {
                    boolean hasSingleDataProperty = fieldNames.size() == 1;
                    JsonValue jsonDataObject = jsonObject.get(fieldNames.get(0));
                    if (!hasSingleDataProperty && !(jsonDataObject instanceof JsonArray)) {
                        throw new FacebookJsonMappingException("JSON is an object but is being mapped as a list instead. Offending JSON is '" + json + "'.");
                    }
                    json = ((Object)jsonDataObject).toString();
                }
            }
            catch (ParseException e) {
                throw new FacebookJsonMappingException("Unable to convert Facebook response JSON to a list of " + type.getName() + " instances.  Offending JSON is '" + json + "'.", e);
            }
        }
        try {
            JsonArray jsonArray = Json.parse(json).asArray();
            ArrayList<T> list = new ArrayList<T>(jsonArray.size());
            for (JsonValue jsonValue : jsonArray) {
                String innerJson = this.jsonHelper.getStringFrom(jsonValue);
                if (jsonValue.isString() && innerJson.startsWith("[")) {
                    innerJson = '\"' + innerJson + '\"';
                }
                list.add(this.toJavaObject(innerJson, type));
            }
            return Collections.unmodifiableList(list);
        }
        catch (FacebookJsonMappingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FacebookJsonMappingException("Unable to convert Facebook response JSON to a list of " + type.getName() + " instances", e);
        }
    }

    @Override
    public <T> T toJavaObject(String json, Class<T> type) {
        if (StringJsonUtils.isEmptyList(json)) {
            return this.toJavaObject("{}", type);
        }
        this.basicJsonStringChecks(json);
        try {
            if (type.equals(JsonObject.class)) {
                return (T)Json.parse(json).asObject();
            }
            List<ReflectionUtils.FieldWithAnnotation<Facebook>> fieldsWithAnnotation = ReflectionUtils.findFieldsWithAnnotation(type, Facebook.class);
            Set<String> facebookFieldNamesWithMultipleMappings = this.facebookFieldNamesWithMultipleMappings(fieldsWithAnnotation);
            if (fieldsWithAnnotation.isEmpty()) {
                if (StringJsonUtils.isEmptyObject(json)) {
                    T instance = ReflectionUtils.createInstance(type);
                    this.invokeJsonMappingCompletedMethods(instance);
                    return instance;
                }
                return this.toPrimitiveJavaType(json, type);
            }
            if (StringJsonUtils.isNull(json)) {
                return null;
            }
            if (StringJsonUtils.isFalse(json)) {
                RestFBLogger.MAPPER_LOGGER.debug("Encountered 'false' from Facebook when trying to map to {} - mapping null instead.", type.getSimpleName());
                return null;
            }
            JsonValue jsonValue = Json.parse(json);
            T instance = ReflectionUtils.createInstance(type);
            if (instance instanceof JsonObject) {
                return (T)jsonValue.asObject();
            }
            if (!jsonValue.isObject()) {
                return null;
            }
            JsonObject jsonObject = jsonValue.asObject();
            for (ReflectionUtils.FieldWithAnnotation<Facebook> fieldWithAnnotation : fieldsWithAnnotation) {
                String facebookFieldName = this.getFacebookFieldName(fieldWithAnnotation);
                if (!jsonObject.contains(facebookFieldName)) {
                    RestFBLogger.MAPPER_LOGGER.trace("No JSON value present for '{}', skipping. JSON is '{}'.", facebookFieldName, json);
                    continue;
                }
                fieldWithAnnotation.getField().setAccessible(true);
                if (facebookFieldNamesWithMultipleMappings.contains(facebookFieldName)) {
                    try {
                        fieldWithAnnotation.getField().set(instance, this.toJavaType(fieldWithAnnotation, jsonObject, facebookFieldName));
                    }
                    catch (FacebookJsonMappingException | ParseException | UnsupportedOperationException e) {
                        this.logMultipleMappingFailedForField(facebookFieldName, fieldWithAnnotation, json);
                    }
                    continue;
                }
                fieldWithAnnotation.getField().set(instance, this.toJavaType(fieldWithAnnotation, jsonObject, facebookFieldName));
            }
            this.invokeJsonMappingCompletedMethods(instance);
            return instance;
        }
        catch (FacebookJsonMappingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FacebookJsonMappingException("Unable to map JSON to Java. Offending JSON is '" + json + "'.", e);
        }
    }

    private void basicJsonStringChecks(String json) {
        if (StringUtils.isBlank(json)) {
            throw new FacebookJsonMappingException("JSON is an empty string - can't map it.");
        }
        if (StringJsonUtils.isList(json)) {
            throw new FacebookJsonMappingException("JSON is an array but is being mapped as an object - you should map it as a List instead. Offending JSON is '" + json + "'.");
        }
    }

    protected void invokeJsonMappingCompletedMethods(Object object) throws IllegalAccessException, InvocationTargetException {
        for (Method method : ReflectionUtils.findMethodsWithAnnotation(object.getClass(), JsonMapper.JsonMappingCompleted.class)) {
            method.setAccessible(true);
            if (method.getParameterTypes().length == 0) {
                method.invoke(object, new Object[0]);
                continue;
            }
            if (method.getParameterTypes().length == 1 && JsonMapper.class.equals(method.getParameterTypes()[0])) {
                method.invoke(object, this);
                continue;
            }
            throw new FacebookJsonMappingException(String.format("Methods annotated with @%s must take 0 parameters or a single %s parameter. Your method was %s", JsonMapper.JsonMappingCompleted.class.getSimpleName(), JsonMapper.class.getSimpleName(), method));
        }
    }

    protected void logMultipleMappingFailedForField(String facebookFieldName, ReflectionUtils.FieldWithAnnotation<Facebook> fieldWithAnnotation, String json) {
        if (!RestFBLogger.MAPPER_LOGGER.isTraceEnabled()) {
            return;
        }
        Field field = fieldWithAnnotation.getField();
        RestFBLogger.MAPPER_LOGGER.trace("Could not map '{}' to {}. {}, but continuing on because '{}' is mapped to multiple fields in {}. JSON is {}", facebookFieldName, field.getDeclaringClass().getSimpleName(), field.getName(), facebookFieldName, field.getDeclaringClass().getSimpleName(), json);
    }

    protected String getFacebookFieldName(ReflectionUtils.FieldWithAnnotation<Facebook> fieldWithAnnotation) {
        String facebookFieldName = fieldWithAnnotation.getAnnotation().value();
        Field field = fieldWithAnnotation.getField();
        if (StringUtils.isBlank(facebookFieldName)) {
            RestFBLogger.MAPPER_LOGGER.trace("No explicit Facebook field name found for {}, so defaulting to the field name itself ({})", field, field.getName());
            facebookFieldName = field.getName();
        }
        return facebookFieldName;
    }

    protected Set<String> facebookFieldNamesWithMultipleMappings(List<ReflectionUtils.FieldWithAnnotation<Facebook>> fieldsWithAnnotation) {
        HashMap<String, Integer> facebookFieldsNamesWithOccurrenceCount = new HashMap<String, Integer>();
        HashSet facebookFieldNamesWithMultipleMappings = new HashSet();
        for (ReflectionUtils.FieldWithAnnotation<Facebook> fieldWithAnnotation : fieldsWithAnnotation) {
            String fieldName = this.getFacebookFieldName(fieldWithAnnotation);
            int occurrenceCount = facebookFieldsNamesWithOccurrenceCount.getOrDefault(fieldName, 0);
            facebookFieldsNamesWithOccurrenceCount.put(fieldName, occurrenceCount + 1);
        }
        facebookFieldNamesWithMultipleMappings.addAll(facebookFieldsNamesWithOccurrenceCount.entrySet().stream().filter(entry -> (Integer)entry.getValue() > 1).map(Map.Entry::getKey).collect(Collectors.toList()));
        return Collections.unmodifiableSet(facebookFieldNamesWithMultipleMappings);
    }

    @Override
    public String toJson(Object object) {
        return this.toJson(object, false);
    }

    @Override
    public String toJson(Object object, boolean ignoreNullValuedProperties) {
        JsonValue jsonObj = this.toJsonInternal(object, ignoreNullValuedProperties);
        return this.jsonHelper.getStringFrom(jsonObj);
    }

    protected JsonValue toJsonInternal(Object object, boolean ignoreNullValuedProperties) {
        if (object == null) {
            return Json.NULL;
        }
        if (object instanceof JsonValue) {
            return (JsonValue)object;
        }
        if (object instanceof List) {
            JsonArray jsonArray = new JsonArray();
            for (Object o : (List)object) {
                jsonArray.add(this.toJsonInternal(o, ignoreNullValuedProperties));
            }
            return jsonArray;
        }
        if (object instanceof Map) {
            JsonObject jsonObject = new JsonObject();
            for (Map.Entry entry : ((Map)object).entrySet()) {
                if (!(entry.getKey() instanceof String)) {
                    throw new FacebookJsonMappingException("Your Map keys must be of type " + String.class + " in order to be converted to JSON.  Offending map is " + object);
                }
                try {
                    jsonObject.add((String)entry.getKey(), this.toJsonInternal(entry.getValue(), ignoreNullValuedProperties));
                }
                catch (ParseException | IllegalArgumentException e) {
                    throw new FacebookJsonMappingException("Unable to process value '" + entry.getValue() + "' for key '" + entry.getKey() + "' in Map " + object, e);
                }
            }
            return jsonObject;
        }
        if (ReflectionUtils.isPrimitive(object)) {
            return this.primitiveToJsonValue(object);
        }
        if (object instanceof BigInteger) {
            return Json.value(((BigInteger)object).longValue());
        }
        if (object instanceof BigDecimal) {
            return Json.value(((BigDecimal)object).doubleValue());
        }
        if (object instanceof Enum) {
            return Json.value(((Enum)object).name());
        }
        if (object instanceof Date) {
            return Json.value(DateUtils.toLongFormatFromDate((Date)object));
        }
        List<ReflectionUtils.FieldWithAnnotation<Facebook>> fieldsWithAnnotation = ReflectionUtils.findFieldsWithAnnotation(object.getClass(), Facebook.class);
        JsonObject jsonObject = new JsonObject();
        Set<String> facebookFieldNamesWithMultipleMappings = this.facebookFieldNamesWithMultipleMappings(fieldsWithAnnotation);
        if (!facebookFieldNamesWithMultipleMappings.isEmpty() && RestFBLogger.MAPPER_LOGGER.isDebugEnabled()) {
            RestFBLogger.MAPPER_LOGGER.debug("Unable to convert to JSON because multiple @{} annotations for the same name are present: {}", Facebook.class.getSimpleName(), facebookFieldNamesWithMultipleMappings);
        }
        for (ReflectionUtils.FieldWithAnnotation<Facebook> fieldWithAnnotation : fieldsWithAnnotation) {
            String facebookFieldName = this.getFacebookFieldName(fieldWithAnnotation);
            fieldWithAnnotation.getField().setAccessible(true);
            try {
                Object fieldValue = fieldWithAnnotation.getField().get(object);
                if (ignoreNullValuedProperties && (fieldValue == null || ObjectUtil.isEmptyCollectionOrMap(fieldValue))) continue;
                jsonObject.add(facebookFieldName, this.toJsonInternal(fieldValue, ignoreNullValuedProperties));
            }
            catch (Exception e) {
                throw new FacebookJsonMappingException("Unable to process field '" + facebookFieldName + "' for " + object.getClass(), e);
            }
        }
        return jsonObject;
    }

    protected <T> T toPrimitiveJavaType(String json, Class<T> type) {
        if (json.length() > 1 && json.startsWith("\"") && json.endsWith("\"")) {
            json = json.replaceFirst("\"", "");
            json = json.substring(0, json.length() - 1);
        }
        if (String.class.equals(type)) {
            return (T)json;
        }
        if (Integer.class.equals(type) || Integer.TYPE.equals(type)) {
            return (T)Integer.valueOf(json);
        }
        if (Boolean.class.equals(type) || Boolean.TYPE.equals(type)) {
            return (T)Boolean.valueOf(json);
        }
        if (Long.class.equals(type) || Long.TYPE.equals(type)) {
            return (T)Long.valueOf(json);
        }
        if (Double.class.equals(type) || Double.TYPE.equals(type)) {
            return (T)Double.valueOf(json);
        }
        if (Float.class.equals(type) || Float.TYPE.equals(type)) {
            return (T)Float.valueOf(json);
        }
        if (BigInteger.class.equals(type)) {
            return (T)new BigInteger(json);
        }
        if (BigDecimal.class.equals(type)) {
            return (T)new BigDecimal(json);
        }
        throw new FacebookJsonMappingException("Don't know how to map JSON to " + type + ". Are you sure you're mapping to the right class?\nOffending JSON is '" + json + "'.");
    }

    protected Object toJavaType(ReflectionUtils.FieldWithAnnotation<Facebook> fieldWithAnnotation, JsonObject jsonObject, String facebookFieldName) {
        Class<?> type = fieldWithAnnotation.getField().getType();
        JsonValue rawValue = jsonObject.get(facebookFieldName);
        if (rawValue.isNull()) {
            return null;
        }
        if (String.class.equals(type)) {
            if (rawValue.isArray() && rawValue.asArray().isEmpty()) {
                RestFBLogger.MAPPER_LOGGER.trace("Coercing an empty JSON array to an empty string for {}", fieldWithAnnotation);
                return "";
            }
            return this.jsonHelper.getStringFrom(rawValue);
        }
        if (Integer.class.equals(type) || Integer.TYPE.equals(type)) {
            return this.jsonHelper.getIntegerFrom(rawValue);
        }
        if (Boolean.class.equals(type) || Boolean.TYPE.equals(type)) {
            return this.jsonHelper.getBooleanFrom(rawValue);
        }
        if (Long.class.equals(type) || Long.TYPE.equals(type)) {
            return this.jsonHelper.getLongFrom(rawValue);
        }
        if (Double.class.equals(type) || Double.TYPE.equals(type)) {
            return this.jsonHelper.getDoubleFrom(rawValue);
        }
        if (Float.class.equals(type) || Float.TYPE.equals(type)) {
            return this.jsonHelper.getFloatFrom(rawValue);
        }
        if (BigInteger.class.equals(type)) {
            return this.jsonHelper.getBigIntegerFrom(rawValue);
        }
        if (BigDecimal.class.equals(type)) {
            return this.jsonHelper.getBigDecimalFrom(rawValue);
        }
        if (List.class.equals(type)) {
            return this.toJavaList(rawValue.toString(), ReflectionUtils.getFirstParameterizedTypeArgument(fieldWithAnnotation.getField()));
        }
        if (Map.class.equals(type)) {
            return this.convertJsonObjectToMap(rawValue.toString(), fieldWithAnnotation.getField());
        }
        if (type.isEnum()) {
            Class<Enum> enumType = type.asSubclass(Enum.class);
            try {
                return Enum.valueOf(enumType, rawValue.asString());
            }
            catch (IllegalArgumentException iae) {
                RestFBLogger.MAPPER_LOGGER.debug("Cannot map string {} to enum {}, try fallback toUpperString next...", rawValue.asString(), enumType.getName());
                try {
                    return Enum.valueOf(enumType, rawValue.asString().toUpperCase());
                }
                catch (IllegalArgumentException iae2) {
                    RestFBLogger.MAPPER_LOGGER.debug("Mapping string {} to enum {} not possible", rawValue.asString(), enumType.getName());
                }
            }
        }
        if (Date.class.equals(type)) {
            return DateUtils.toDateFromLongFormat(this.jsonHelper.getStringFrom(rawValue));
        }
        String rawValueAsString = this.jsonHelper.getStringFrom(rawValue);
        if (Comments.class.isAssignableFrom(type) && rawValue instanceof JsonArray) {
            RestFBLogger.MAPPER_LOGGER.debug("Encountered comment array '{}' but expected a {} object instead.  Working around that by coercing into an empty {} instance...", rawValueAsString, Comments.class.getSimpleName(), Comments.class.getSimpleName());
            JsonObject workaroundJsonObject = new JsonObject();
            workaroundJsonObject.add("total_count", 0);
            workaroundJsonObject.add("data", new JsonArray());
            rawValueAsString = workaroundJsonObject.toString();
        }
        return this.toJavaObject(rawValueAsString, type);
    }

    private Map convertJsonObjectToMap(String json, Field field) {
        Class<?> firstParam = ReflectionUtils.getFirstParameterizedTypeArgument(field);
        if (!String.class.equals(firstParam)) {
            throw new FacebookJsonMappingException("The java type map needs to have a 'String' key, but is " + firstParam);
        }
        Class<?> secondParam = ReflectionUtils.getSecondParameterizedTypeArgument(field);
        if (StringJsonUtils.isObject(json)) {
            JsonObject jsonObject = Json.parse(json).asObject();
            HashMap map = new HashMap();
            for (String key : jsonObject.names()) {
                String value = this.jsonHelper.getStringFrom(jsonObject.get(key));
                map.put(key, this.toJavaObject(value, secondParam));
            }
            return map;
        }
        return null;
    }

    private JsonValue primitiveToJsonValue(Object object) {
        if (object == null) {
            return Json.NULL;
        }
        Class<?> type = object.getClass();
        if (object instanceof String) {
            return Json.value((String)object);
        }
        if (object instanceof Integer || Integer.TYPE.equals(type)) {
            return Json.value((Integer)object);
        }
        if (object instanceof Boolean || Boolean.TYPE.equals(type)) {
            return Json.value((Boolean)object);
        }
        if (object instanceof Long || Long.TYPE.equals(type)) {
            return Json.value((Long)object);
        }
        if (object instanceof Double || Double.TYPE.equals(type)) {
            return Json.value((Double)object);
        }
        if (object instanceof Float || Float.TYPE.equals(type)) {
            return Json.value(((Float)object).floatValue());
        }
        if (object instanceof Byte || Byte.TYPE.equals(type)) {
            return Json.value(((Byte)object).byteValue());
        }
        if (object instanceof Short || Short.TYPE.equals(type)) {
            return Json.value(((Short)object).shortValue());
        }
        if (object instanceof Character || Character.TYPE.equals(type)) {
            return Json.value(Character.toString(((Character)object).charValue()));
        }
        return Json.NULL;
    }
}

