/*
 * Decompiled with CFR 0.152.
 */
package com.restfb;

import com.restfb.DefaultJsonMapper;
import com.restfb.Facebook;
import com.restfb.Version;
import com.restfb.json.Json;
import com.restfb.json.JsonObject;
import com.restfb.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DebugHeaderInfo {
    private final String debug;
    private final String rev;
    private final String traceId;
    private final Version usedVersion;
    private final HeaderUsage appUsage;
    private final HeaderUsage pageUsage;
    private final HeaderUsage adAccountUsage;
    private final BusinessUseCaseUsage businessUseCaseUsage;

    private DebugHeaderInfo(String debug, String rev, String traceId, Version version, String appUsage, String pageUsage, String adAccountUsage, String businessUsage) {
        this.debug = debug;
        this.rev = rev;
        this.traceId = traceId;
        this.usedVersion = version;
        this.appUsage = this.createUsage(appUsage);
        this.pageUsage = this.createUsage(pageUsage);
        this.adAccountUsage = this.createUsage(adAccountUsage);
        this.businessUseCaseUsage = this.createBusinessUsage(businessUsage);
    }

    public String getDebug() {
        return this.debug;
    }

    public String getRev() {
        return this.rev;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public Version getUsedVersion() {
        return this.usedVersion;
    }

    public HeaderUsage getAppUsage() {
        return this.appUsage;
    }

    public HeaderUsage getPageUsage() {
        return this.pageUsage;
    }

    public HeaderUsage getAdAccountUsage() {
        return this.adAccountUsage;
    }

    public BusinessUseCaseUsage getBusinessUseCaseUsage() {
        return this.businessUseCaseUsage;
    }

    private BusinessUseCaseUsage createBusinessUsage(String businessUsageInformation) {
        if (StringUtils.isBlank(businessUsageInformation)) {
            return null;
        }
        try {
            DefaultJsonMapper jsonMapper = new DefaultJsonMapper();
            JsonObject jsonObject = Json.parse(businessUsageInformation).asObject();
            BusinessUseCaseUsage usage = new BusinessUseCaseUsage();
            for (String key : jsonObject.names()) {
                usage.put(key, jsonMapper.toJavaList(jsonObject.get(key).toString(), InnerBusinessUseCaseUsage.class));
            }
            return usage;
        }
        catch (Exception e) {
            return null;
        }
    }

    private HeaderUsage createUsage(String usageInformation) {
        if (StringUtils.isBlank(usageInformation)) {
            return null;
        }
        try {
            JsonObject jsonValue = Json.parse(usageInformation).asObject();
            if (jsonValue.names().size() == 1 && jsonValue.contains("acc_id_util_pct")) {
                return new HeaderUsage(jsonValue.getDouble("acc_id_util_pct", 0.0));
            }
            return new HeaderUsage(jsonValue.getInt("call_count", -1), jsonValue.getInt("total_time", -1), jsonValue.getInt("total_cputime", -1));
        }
        catch (Exception e) {
            return new HeaderUsage(usageInformation);
        }
    }

    public static class DebugHeaderInfoFactory {
        private String debug;
        private String rev;
        private String traceId;
        private Version version;
        private String appUsage;
        private String pageUsage;
        private String adAccountUsage;
        private String businessUseCaseUsage;

        public static DebugHeaderInfoFactory create() {
            return new DebugHeaderInfoFactory();
        }

        public DebugHeaderInfoFactory setVersion(Version version) {
            this.version = version;
            return this;
        }

        public DebugHeaderInfoFactory setDebug(String debug) {
            this.debug = debug;
            return this;
        }

        public DebugHeaderInfoFactory setRev(String rev) {
            this.rev = rev;
            return this;
        }

        public DebugHeaderInfoFactory setTraceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        public DebugHeaderInfoFactory setAppUsage(String appUsage) {
            this.appUsage = appUsage;
            return this;
        }

        public DebugHeaderInfoFactory setPageUsage(String pageUsage) {
            this.pageUsage = pageUsage;
            return this;
        }

        public DebugHeaderInfoFactory setAdAccountUsage(String adAccountUsage) {
            this.adAccountUsage = adAccountUsage;
            return this;
        }

        public DebugHeaderInfoFactory setBusinessUseCaseUsage(String businessUseCaseUsage) {
            this.businessUseCaseUsage = businessUseCaseUsage;
            return this;
        }

        public DebugHeaderInfo build() {
            return new DebugHeaderInfo(this.debug, this.rev, this.traceId, this.version, this.appUsage, this.pageUsage, this.adAccountUsage, this.businessUseCaseUsage);
        }
    }

    public static class HeaderUsage {
        private final boolean percentageOnly;
        private final boolean adAccountHeader;
        private String percentage;
        private Integer callCount;
        private Integer totalTime;
        private Integer totalCputime;
        private Double accIdUtilPct;

        HeaderUsage(String percentage) {
            this.percentage = percentage;
            this.percentageOnly = true;
            this.adAccountHeader = false;
        }

        HeaderUsage(Integer callCount, Integer totalTime, Integer totalCputime) {
            this.callCount = callCount;
            this.totalTime = totalTime;
            this.totalCputime = totalCputime;
            this.percentageOnly = false;
            this.adAccountHeader = false;
        }

        HeaderUsage(Double percentage) {
            this.accIdUtilPct = percentage;
            this.percentageOnly = false;
            this.adAccountHeader = true;
        }

        public boolean isPercentageOnly() {
            return this.percentageOnly;
        }

        public boolean isAdAccountHeader() {
            return this.adAccountHeader;
        }

        public String getPercentage() {
            return this.percentage;
        }

        public Integer getCallCount() {
            return this.callCount;
        }

        public Integer getTotalTime() {
            return this.totalTime;
        }

        public Integer getTotalCputime() {
            return this.totalCputime;
        }

        public Double getAccIdUtilPct() {
            return this.accIdUtilPct;
        }
    }

    public static class InnerBusinessUseCaseUsage {
        @Facebook(value="call_count")
        private Integer callCount;
        @Facebook(value="total_cputime")
        private Integer totalCputime;
        @Facebook(value="total_time")
        private Integer totalTime;
        @Facebook
        private String type;
        @Facebook(value="estimated_time_to_regain_access")
        private Integer estimatedTimeToRegainAccess;

        public Integer getCallCount() {
            return this.callCount;
        }

        public Integer getTotalCputime() {
            return this.totalCputime;
        }

        public Integer getTotalTime() {
            return this.totalTime;
        }

        public String getType() {
            return this.type;
        }

        public Integer getEstimatedTimeToRegainAccess() {
            return this.estimatedTimeToRegainAccess;
        }
    }

    public static class BusinessUseCaseUsage {
        private Map<String, List<InnerBusinessUseCaseUsage>> usageMap = new HashMap<String, List<InnerBusinessUseCaseUsage>>();

        void put(String key, List<InnerBusinessUseCaseUsage> businessUseCaseUsageList) {
            this.usageMap.put(key, businessUseCaseUsageList);
        }

        public List<InnerBusinessUseCaseUsage> get(String businessId) {
            return this.usageMap.get(businessId);
        }

        public List<String> getBusinessIds() {
            return new ArrayList<String>(this.usageMap.keySet());
        }
    }
}

