/*
 * Decompiled with CFR 0.152.
 */
package com.restfb;

import com.restfb.ConnectionIterator;
import com.restfb.FacebookClient;
import com.restfb.exception.FacebookJsonMappingException;
import com.restfb.json.Json;
import com.restfb.json.JsonArray;
import com.restfb.json.JsonObject;
import com.restfb.json.ParseException;
import com.restfb.util.ReflectionUtils;
import com.restfb.util.StringUtils;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;

public class Connection<T>
implements Iterable<List<T>> {
    private FacebookClient facebookClient;
    private Class<T> connectionType;
    private List<T> data;
    private String previousPageUrl;
    private String nextPageUrl;
    private Long totalCount;
    private String beforeCursor;
    private String afterCursor;

    @Override
    public ConnectionIterator<T> iterator() {
        return new Itr(this);
    }

    public Connection(FacebookClient facebookClient, String json, Class<T> connectionType) {
        JsonObject jsonSummary;
        JsonObject jsonObject;
        try {
            jsonObject = Optional.ofNullable(json).map(j -> Json.parse(j).asObject()).orElseThrow(() -> new FacebookJsonMappingException("You must supply non-null connection JSON."));
        }
        catch (ParseException e) {
            throw new FacebookJsonMappingException("The connection JSON you provided was invalid: " + json, e);
        }
        JsonArray jsonData = jsonObject.get("data").asArray();
        List dataItem = jsonData.valueStream().map(jsonValue -> connectionType.equals(JsonObject.class) ? jsonValue : facebookClient.getJsonMapper().toJavaObject(jsonValue.toString(), connectionType)).collect(Collectors.toList());
        if (jsonObject.contains("paging")) {
            JsonObject jsonPaging = jsonObject.get("paging").asObject();
            this.previousPageUrl = this.fixProtocol(jsonPaging.getString("previous", null));
            this.nextPageUrl = this.fixProtocol(jsonPaging.getString("next", null));
            if (jsonPaging.contains("cursors")) {
                JsonObject jsonCursors = jsonPaging.get("cursors").asObject();
                this.beforeCursor = jsonCursors.getString("before", null);
                this.afterCursor = jsonCursors.getString("after", null);
            }
        } else {
            this.previousPageUrl = null;
            this.nextPageUrl = null;
        }
        this.totalCount = jsonObject.contains("summary") ? ((jsonSummary = jsonObject.get("summary").asObject()).contains("total_count") ? Long.valueOf(jsonSummary.getLong("total_count", 0L)) : null) : null;
        this.data = Collections.unmodifiableList(dataItem);
        this.facebookClient = facebookClient;
        this.connectionType = connectionType;
    }

    protected Connection<T> fetchNextPage() {
        return this.facebookClient.fetchConnectionPage(this.getNextPageUrl(), this.connectionType);
    }

    public String toString() {
        return ReflectionUtils.toString(this);
    }

    public boolean equals(Object object) {
        return ReflectionUtils.equals(this, object);
    }

    public int hashCode() {
        return ReflectionUtils.hashCode(this);
    }

    public List<T> getData() {
        return this.data;
    }

    public String getPreviousPageUrl() {
        return this.previousPageUrl;
    }

    protected void setPreviousPageUrl(String previousPageUrl) {
        this.previousPageUrl = previousPageUrl;
    }

    public String getNextPageUrl() {
        return this.nextPageUrl;
    }

    protected void setNextPageUrl(String nextPageUrl) {
        this.nextPageUrl = nextPageUrl;
    }

    public boolean hasPrevious() {
        return !StringUtils.isBlank(this.getPreviousPageUrl()) && !this.isSameCursor();
    }

    public boolean hasNext() {
        return !StringUtils.isBlank(this.getNextPageUrl()) && !this.getData().isEmpty() && !this.isSameCursor();
    }

    public Long getTotalCount() {
        return this.totalCount;
    }

    public String getBeforeCursor() {
        return this.beforeCursor;
    }

    public String getAfterCursor() {
        return this.afterCursor;
    }

    private String fixProtocol(String pageUrl) {
        return Optional.ofNullable(pageUrl).filter(s -> s.startsWith("http://")).map(s -> s.replaceFirst("http://", "https://")).orElse(pageUrl);
    }

    private boolean isSameCursor() {
        return this.getBeforeCursor() != null && this.getAfterCursor() != null && this.getBeforeCursor().equals(this.getAfterCursor());
    }

    protected static class Itr<T>
    implements ConnectionIterator<T> {
        private Connection<T> connection;
        private boolean initialPage = true;

        protected Itr(Connection<T> connection) {
            this.connection = connection;
        }

        @Override
        public boolean hasNext() {
            return this.initialPage || this.connection.hasNext();
        }

        @Override
        public List<T> next() {
            if (this.initialPage) {
                this.initialPage = false;
                return this.connection.getData();
            }
            if (!this.connection.hasNext()) {
                throw new NoSuchElementException("There are no more pages in the connection.");
            }
            this.connection = this.connection.fetchNextPage();
            return this.connection.getData();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException(Itr.class.getSimpleName() + " doesn't support the remove() operation.");
        }

        @Override
        public Connection<T> snapshot() {
            return this.connection;
        }
    }
}

